/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.ImageFormat;
import android.graphics.Rect;
import android.hardware.Camera;
import android.os.Build;
import android.util.Log;
import android.view.SurfaceHolder;
import android.view.WindowManager;
import eu.nets.pia.cardio.CardIOActivity;
import eu.nets.pia.cardio.CardIONativeLibsConfig;
import eu.nets.pia.cardio.DetectionInfo;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

class CardScanner
implements Camera.PreviewCallback,
Camera.AutoFocusCallback,
SurfaceHolder.Callback {
    private static final String TAG;
    private static final float MIN_FOCUS_SCORE = 6.0f;
    private static final int DEFAULT_UNBLUR_DIGITS = -1;
    private static final int CAMERA_CONNECT_TIMEOUT = 5000;
    private static final int CAMERA_CONNECT_RETRY_INTERVAL = 50;
    static final int ORIENTATION_PORTRAIT = 1;
    static final int CREDIT_CARD_TARGET_WIDTH = 428;
    static final int CREDIT_CARD_TARGET_HEIGHT = 270;
    private static boolean manualFallbackForError;
    private static boolean processingInProgress;
    static final /* synthetic */ boolean $assertionsDisabled;
    private Bitmap detectedBitmap;
    protected WeakReference<CardIOActivity> mScanActivityRef;
    private boolean mSuppressScan = false;
    private boolean mScanExpiry;
    private int mUnblurDigits = -1;
    int mPreviewWidth = 640;
    int mPreviewHeight = 480;
    int preferredPreviewWidth = 640;
    int preferredPreviewHeight = 480;
    private int mFrameOrientation = 1;
    private boolean mFirstPreviewFrame = true;
    private long captureStart;
    private long mAutoFocusStartedAt;
    private long mAutoFocusCompletedAt;
    private Camera mCamera;
    private byte[] mPreviewBuffer;
    protected boolean useCamera = true;
    private boolean isSurfaceValid;
    private int numManualRefocus;
    private int numAutoRefocus;
    private int numManualTorchChange;
    private int numFramesSkipped;

    public static native boolean nUseNeon();

    public static native boolean nUseTegra();

    public static native boolean nUseX86();

    private native void nSetup(boolean var1, float var2);

    private native void nSetup(boolean var1, float var2, int var3);

    private native void nResetAnalytics();

    private native void nGetGuideFrame(int var1, int var2, int var3, Rect var4);

    private native void nScanFrame(byte[] var1, int var2, int var3, int var4, DetectionInfo var5, Bitmap var6, boolean var7);

    private native int nGetNumFramesScanned();

    private native void nCleanup();

    private static void loadLibrary(String string2) {
        UnsatisfiedLinkError unsatisfiedLinkError2;
        block3: {
            try {
                System.loadLibrary(string2);
            }
            catch (UnsatisfiedLinkError unsatisfiedLinkError2) {
                String string3 = CardIONativeLibsConfig.getAlternativeLibsPath();
                if (string3 == null || string3.length() == 0) break block3;
                String string4 = File.separator;
                String string5 = string3;
                if (!string4.equals(Character.valueOf(string5.charAt(string5.length() - 1)))) {
                    string3 = string3 + string4;
                }
                System.load(string3 + Build.CPU_ABI + string4 + System.mapLibraryName(string2));
            }
            return;
        }
        throw unsatisfiedLinkError2;
    }

    private static boolean usesSupportedProcessorArch() {
        return CardScanner.nUseNeon() || CardScanner.nUseTegra() || CardScanner.nUseX86();
    }

    public static boolean processorSupported() {
        return !manualFallbackForError && CardScanner.usesSupportedProcessorArch();
    }

    public CardScanner(CardIOActivity cardIOActivity, int n, int n2, int n3) {
        WeakReference<CardIOActivity> weakReference;
        Intent intent = cardIOActivity.getIntent();
        CardScanner cardScanner = weakReference2;
        cardScanner.preferredPreviewWidth = n2;
        cardScanner.preferredPreviewHeight = n3;
        if (intent != null) {
            ((CardScanner)((Object)weakReference2)).mSuppressScan = intent.getBooleanExtra("io.card.payment.suppressScan", false);
            n2 = intent.getBooleanExtra("io.card.payment.requireExpiry", false) && intent.getBooleanExtra("io.card.payment.scanExpiry", true) ? 1 : 0;
            ((CardScanner)((Object)weakReference2)).mScanExpiry = n2;
            ((CardScanner)((Object)weakReference2)).mUnblurDigits = intent.getIntExtra("io.card.payment.unblurDigits", -1);
        }
        CardScanner cardScanner2 = weakReference2;
        WeakReference<CardIOActivity> weakReference2 = weakReference;
        weakReference = new WeakReference<CardIOActivity>(cardIOActivity);
        cardScanner2.mScanActivityRef = weakReference2;
        cardScanner2.mFrameOrientation = n;
        boolean bl = cardScanner2.mSuppressScan;
        int n4 = cardScanner2.mUnblurDigits;
        cardScanner2.nSetup(bl, 6.0f, n4);
    }

    private Camera connectToCamera(int n, int n2) {
        long l = System.currentTimeMillis();
        if (this.useCamera) {
            do {
                try {
                    return Camera.open();
                }
                catch (Exception exception) {
                    int n3;
                    Log.e((String)"card.io", (String)"Unexpected exception. Please report it as a GitHub issue", (Throwable)exception);
                    n2 = n3 = 0;
                }
                catch (RuntimeException runtimeException) {
                    int n4 = n;
                    Log.w((String)"card.io", (String)"Wasn't able to connect to camera service. Waiting and trying again...");
                    try {
                        Thread.sleep(n4);
                    }
                    catch (InterruptedException interruptedException) {
                        Log.e((String)"card.io", (String)"Interrupted while waiting for camera", (Throwable)interruptedException);
                    }
                }
            } while (System.currentTimeMillis() - l < (long)n2);
        }
        return null;
    }

    private Camera.Size getOptimalPreviewSize(int n, int n2) {
        Iterator iterator = ((CardScanner)((Object)iterator)).mCamera.getParameters().getSupportedPreviewSizes();
        double d2 = (double)n / (double)n2;
        if (iterator == null) {
            return null;
        }
        Camera.Size size = null;
        double d3 = Double.MAX_VALUE;
        Iterator iterator2 = iterator.iterator();
        while (iterator2.hasNext()) {
            Camera.Size size2;
            Camera.Size size3 = (Camera.Size)iterator2.next();
            if (Math.abs((double)size2.width / (double)size3.height - d2) > 0.1 || !((double)Math.abs(size3.height - n2) < d3)) continue;
            d3 = Math.abs(size3.height - n2);
            size = size3;
        }
        if (size == null) {
            d2 = Double.MAX_VALUE;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                Camera.Size size4;
                Camera.Size size5 = (Camera.Size)iterator.next();
                if (!((double)Math.abs(size4.height - n2) < d2)) continue;
                d2 = Math.abs(size5.height - n2);
                size = size5;
            }
        }
        return size;
    }

    private boolean makePreviewGo(SurfaceHolder surfaceHolder) {
        boolean bl = $assertionsDisabled;
        if (!bl && surfaceHolder == null) {
            throw new AssertionError();
        }
        if (!bl && surfaceHolder.getSurface() == null) {
            throw new AssertionError();
        }
        this.mFirstPreviewFrame = true;
        if (this.useCamera) {
            CardScanner cardScanner;
            CardScanner cardScanner2;
            try {
                CardScanner cardScanner3 = this;
                cardScanner2 = cardScanner3;
                cardScanner = cardScanner3;
                cardScanner3.mCamera.setPreviewDisplay(surfaceHolder);
            }
            catch (IOException iOException) {
                return false;
            }
            try {
                cardScanner.mCamera.startPreview();
                cardScanner2.mCamera.autoFocus((Camera.AutoFocusCallback)this);
            }
            catch (RuntimeException runtimeException) {
                return false;
            }
        }
        return true;
    }

    private void setCameraDisplayOrientation(Camera camera) {
        int n;
        if (Build.VERSION.SDK_INT >= 21) {
            Camera.CameraInfo cameraInfo;
            CardScanner cardScanner = cardScanner2;
            CardScanner cardScanner2 = cameraInfo;
            cameraInfo = new Camera.CameraInfo();
            Camera.getCameraInfo((int)0, (Camera.CameraInfo)cardScanner2);
            n = (((Camera.CameraInfo)cardScanner2).orientation - cardScanner.getRotationalOffset() + 360) % 360;
        } else {
            n = 90;
        }
        camera.setDisplayOrientation(n);
    }

    /*
     * Exception decompiling
     */
    static {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[TRYBLOCK]], but top level block is 11[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void prepareScanner() {
        cardScanner3.mFirstPreviewFrame = true;
        cardScanner3.mAutoFocusStartedAt = 0L;
        cardScanner3.mAutoFocusCompletedAt = 0L;
        cardScanner3.numManualRefocus = 0;
        cardScanner3.numAutoRefocus = 0;
        cardScanner3.numManualTorchChange = 0;
        cardScanner3.numFramesSkipped = 0;
        if (cardScanner3.useCamera && cardScanner3.mCamera == null) {
            Camera camera;
            cardScanner3.mCamera = camera = cardScanner3.connectToCamera(50, 5000);
            if (camera == null) {
                Log.e((String)"card.io", (String)"prepare scanner couldn't connect to camera!");
                return;
            }
            CardScanner cardScanner = cardScanner3;
            cardScanner.setCameraDisplayOrientation(camera);
            camera = cardScanner.mCamera.getParameters();
            List list = camera.getSupportedPreviewSizes();
            if (list != null) {
                Camera.Size size = null;
                for (Camera.Size size2 : list) {
                    if (size2.width != 640 || size2.height != 480) continue;
                    size = size2;
                    break;
                }
                if (size == null) {
                    Log.w((String)"card.io", (String)"Didn't find a supported 640x480 resolution, so forcing");
                    Camera.Size size3 = (Camera.Size)list.get(0);
                    size3.width = cardScanner3.mPreviewWidth;
                    size3.height = cardScanner3.mPreviewHeight;
                }
            }
            CardScanner cardScanner2 = cardScanner3;
            int n = cardScanner2.mPreviewWidth;
            camera.setPreviewSize(n, cardScanner2.mPreviewHeight);
            cardScanner3.mCamera.setParameters((Camera.Parameters)camera);
        }
        if (cardScanner3.detectedBitmap == null) {
            CardScanner cardScanner = cardScanner3;
            CardScanner cardScanner3 = Bitmap.Config.ARGB_8888;
            cardScanner.detectedBitmap = Bitmap.createBitmap((int)428, (int)270, (Bitmap.Config)cardScanner3);
        }
    }

    public boolean resumeScanning(SurfaceHolder surfaceHolder) {
        int n;
        if (this.mCamera == null) {
            this.prepareScanner();
        }
        if ((n = this.useCamera) != 0 && this.mCamera == null) {
            return false;
        }
        if (!$assertionsDisabled && surfaceHolder == null) {
            throw new AssertionError();
        }
        if (n != 0 && this.mPreviewBuffer == null) {
            CardScanner cardScanner = this;
            n = ImageFormat.getBitsPerPixel((int)cardScanner.mCamera.getParameters().getPreviewFormat()) / 8;
            byte[] byArray = new byte[cardScanner.mPreviewWidth * this.mPreviewHeight * n * 3];
            cardScanner.mPreviewBuffer = byArray;
            cardScanner.mCamera.addCallbackBuffer(byArray);
        }
        SurfaceHolder surfaceHolder2 = surfaceHolder;
        surfaceHolder2.addCallback((SurfaceHolder.Callback)this);
        surfaceHolder2.setType(3);
        if (this.useCamera) {
            this.mCamera.setPreviewCallbackWithBuffer((Camera.PreviewCallback)this);
        }
        if (this.isSurfaceValid) {
            this.makePreviewGo(surfaceHolder);
        }
        CardScanner cardScanner = this;
        cardScanner.setFlashOn(false);
        cardScanner.captureStart = System.currentTimeMillis();
        cardScanner.nResetAnalytics();
        return true;
    }

    public void pauseScanning() {
        CardScanner cardScanner = this;
        cardScanner.setFlashOn(false);
        Camera camera = cardScanner.mCamera;
        if (camera != null) {
            try {
                camera.stopPreview();
                this.mCamera.setPreviewDisplay(null);
            }
            catch (IOException iOException) {
                Log.w((String)"card.io", (String)"can't stop preview display", (Throwable)iOException);
            }
            CardScanner cardScanner2 = this;
            cardScanner2.mCamera.setPreviewCallback(null);
            cardScanner2.mCamera.release();
            cardScanner2.mPreviewBuffer = null;
            cardScanner2.mCamera = null;
        }
    }

    public void endScanning() {
        if (this.mCamera != null) {
            this.pauseScanning();
        }
        this.nCleanup();
        this.mPreviewBuffer = null;
    }

    public void surfaceCreated(SurfaceHolder surfaceHolder) {
        if (this.mCamera == null && this.useCamera) {
            Log.wtf((String)"card.io", (String)"CardScanner.surfaceCreated() - camera is null!");
            return;
        }
        this.isSurfaceValid = true;
        this.makePreviewGo(surfaceHolder);
    }

    public void surfaceChanged(SurfaceHolder surfaceHolder, int n, int n2, int n3) {
    }

    public void surfaceDestroyed(SurfaceHolder surfaceHolder) {
        surfaceHolder = this.mCamera;
        if (surfaceHolder != null) {
            try {
                surfaceHolder.stopPreview();
            }
            catch (Exception exception) {
                Log.e((String)"card.io", (String)"error stopping camera", (Throwable)exception);
            }
        }
        this.isSurfaceValid = false;
    }

    public void onPreviewFrame(byte[] byArray, Camera camera) {
        DetectionInfo detectionInfo;
        if (byArray == null) {
            return;
        }
        if (processingInProgress) {
            ++this.numFramesSkipped;
            if (camera != null) {
                camera.addCallbackBuffer(byArray);
            }
            return;
        }
        processingInProgress = true;
        if (this.mFirstPreviewFrame) {
            this.mFirstPreviewFrame = false;
            this.mFrameOrientation = 1;
            ((CardIOActivity)((Object)this.mScanActivityRef.get())).onFirstFrame();
        }
        CardScanner cardScanner = this;
        DetectionInfo detectionInfo2 = detectionInfo;
        detectionInfo = new DetectionInfo();
        int n = cardScanner.mFrameOrientation;
        Bitmap bitmap = cardScanner.detectedBitmap;
        boolean bl = cardScanner.mScanExpiry;
        this.nScanFrame(byArray, 640, 480, n, detectionInfo2, bitmap, bl);
        if (!(detectionInfo2.focusScore >= 6.0f)) {
            this.triggerAutoFocus(false);
        } else if (detectionInfo2.predicted() || this.mSuppressScan && detectionInfo2.detected()) {
            ((CardIOActivity)((Object)this.mScanActivityRef.get())).onCardDetected(this.detectedBitmap, detectionInfo2);
        }
        if (camera != null) {
            camera.addCallbackBuffer(byArray);
        }
        processingInProgress = false;
    }

    public void onEdgeUpdate(DetectionInfo detectionInfo) {
        ((CardIOActivity)((Object)this.mScanActivityRef.get())).onEdgeUpdate(detectionInfo);
    }

    public Rect getGuideFrame(int n, int n2, int n3) {
        Rect rect = null;
        if (CardScanner.processorSupported()) {
            Rect rect2;
            rect = rect2;
            rect2 = new Rect();
            this.nGetGuideFrame(n, n2, n3, rect);
        }
        return rect;
    }

    public Rect getGuideFrame() {
        CardScanner cardScanner = this;
        int n = cardScanner.mFrameOrientation;
        int n2 = cardScanner.mPreviewHeight;
        int n3 = cardScanner.mPreviewWidth;
        return cardScanner.getGuideFrame(n, n2, n3);
    }

    public Rect getGuideFrame(int n, int n2) {
        CardScanner cardScanner = this;
        return cardScanner.getGuideFrame(cardScanner.mFrameOrientation, n, n2);
    }

    public void setDeviceOrientation(int n) {
        this.mFrameOrientation = n;
    }

    public int getDeviceOrientation() {
        return this.mFrameOrientation;
    }

    public Map<String, Object> getAnalytics() {
        HashMap<String, Object> hashMap;
        HashMap<String, Object> hashMap2;
        HashMap<String, Object> hashMap3 = hashMap2 = hashMap;
        hashMap2(11);
        hashMap2.put("num_frames_scanned", this.nGetNumFramesScanned());
        hashMap3.put("num_frames_skipped", this.numFramesSkipped);
        hashMap3.put("elapsed_time", Double.valueOf((System.currentTimeMillis() - this.captureStart) / 1000L));
        hashMap2.put("num_manual_refocusings", this.numManualRefocus);
        hashMap2.put("num_auto_triggered_refocusings", this.numAutoRefocus);
        hashMap.put("num_manual_torch_changes", this.numManualTorchChange);
        return hashMap;
    }

    public void onAutoFocus(boolean bl, Camera camera) {
        this.mAutoFocusCompletedAt = System.currentTimeMillis();
    }

    public boolean isAutoFocusing() {
        return this.mAutoFocusCompletedAt < this.mAutoFocusStartedAt;
    }

    public void toggleFlash() {
        CardScanner cardScanner = this;
        cardScanner.setFlashOn(cardScanner.isFlashOn() ^ true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void triggerAutoFocus(boolean bl) {
        if (!this.useCamera) return;
        if (this.isAutoFocusing()) return;
        try {
            this.mAutoFocusStartedAt = System.currentTimeMillis();
            this.mCamera.autoFocus((Camera.AutoFocusCallback)this);
            if (bl) {
                ++this.numManualRefocus;
                return;
            }
            ++this.numAutoRefocus;
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.w((String)TAG, (String)("could not trigger auto focus: " + runtimeException));
        }
    }

    public boolean isFlashOn() {
        if (!this.useCamera) {
            return false;
        }
        return this.mCamera.getParameters().getFlashMode().equals("torch");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean setFlashOn(boolean bl) {
        Camera camera = this.mCamera;
        if (camera != null) {
            try {
                Camera.Parameters parameters = camera.getParameters();
                String string2 = bl ? "torch" : "off";
                CardScanner cardScanner = this;
                parameters.setFlashMode(string2);
                cardScanner.mCamera.setParameters(parameters);
                ++cardScanner.numManualTorchChange;
                return true;
            }
            catch (RuntimeException runtimeException) {
                Log.w((String)TAG, (String)("Could not set flash mode: " + runtimeException));
            }
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getRotationalOffset() {
        int n = ((WindowManager)((CardIOActivity)((Object)this.mScanActivityRef.get())).getSystemService("window")).getDefaultDisplay().getRotation();
        if (n == 0) {
            return 0;
        }
        if (n == 1) {
            return 90;
        }
        if (n == 2) {
            return 180;
        }
        if (n != 3) return 0;
        return 270;
    }
}

