/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.text.TextUtils;
import android.util.Pair;
import eu.nets.pia.utils.StringUtils;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public final class CardType
extends Enum<CardType> {
    public static final /* enum */ CardType AMEX;
    public static final /* enum */ CardType DINERSCLUB;
    public static final /* enum */ CardType DISCOVER;
    public static final /* enum */ CardType JCB;
    public static final /* enum */ CardType MASTERCARD;
    public static final /* enum */ CardType VISA;
    public static final /* enum */ CardType MAESTRO;
    public static final /* enum */ CardType UNKNOWN;
    public static final /* enum */ CardType INSUFFICIENT_DIGITS;
    private static int minDigits;
    private static HashMap<Pair<String, String>, CardType> intervalLookup;
    private static final /* synthetic */ CardType[] $VALUES;
    public final String name;

    public static CardType[] values() {
        return (CardType[])$VALUES.clone();
    }

    public static CardType valueOf(String string2) {
        return Enum.valueOf(CardType.class, string2);
    }

    private CardType(String string3) {
        this.name = string3;
    }

    private static boolean isNumberInInterval(String string2, String string3, String string4) {
        String string5 = string2;
        int n = Math.min(string5.length(), string3.length());
        int n2 = Math.min(string5.length(), string4.length());
        if (Integer.parseInt(StringUtils.safeSubString(string5, 0, n)) < Integer.parseInt(StringUtils.safeSubString(string3, 0, n))) {
            return false;
        }
        return Integer.parseInt(StringUtils.safeSubString(string2, 0, n2)) <= Integer.parseInt(StringUtils.safeSubString(string4, 0, n2));
    }

    private static HashMap<Pair<String, String>, CardType> getIntervalLookup() {
        return intervalLookup;
    }

    private static Pair<String, String> getNewPair(String string2, String string3) {
        if (string3 == null) {
            string3 = string2;
        }
        return new Pair((Object)string2, (Object)string3);
    }

    public static CardType fromString(String string2) {
        if (string2 == null) {
            return UNKNOWN;
        }
        for (CardType cardType : CardType.values()) {
            if (cardType == UNKNOWN || cardType == INSUFFICIENT_DIGITS || !string2.equalsIgnoreCase(cardType.toString())) continue;
            return cardType;
        }
        return UNKNOWN;
    }

    public static CardType fromCardNumber(String string2) {
        HashSet<CardType> hashSet;
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return UNKNOWN;
        }
        HashSet<CardType> hashSet2 = hashSet;
        hashSet = new HashSet<CardType>();
        for (Map.Entry<Pair<String, String>, CardType> entry : CardType.getIntervalLookup().entrySet()) {
            if (!CardType.isNumberInInterval(string2, (String)entry.getKey().first, (String)entry.getKey().second)) continue;
            hashSet2.add(entry.getValue());
        }
        if (hashSet2.size() > 1) {
            return INSUFFICIENT_DIGITS;
        }
        if (hashSet2.size() == 1) {
            return (CardType)((Object)hashSet2.iterator().next());
        }
        return UNKNOWN;
    }

    static {
        CardType cardType;
        CardType cardType2;
        CardType cardType3;
        CardType cardType4;
        CardType cardType5;
        CardType cardType6;
        CardType cardType7;
        CardType cardType8;
        CardType cardType9;
        CardType cardType10 = cardType9;
        AMEX = new CardType("AmEx");
        CardType object2 = cardType8;
        DINERSCLUB = new CardType("DinersClub");
        CardType cardType11 = cardType7;
        DISCOVER = new CardType("Discover");
        CardType cardType12 = cardType6;
        JCB = new CardType("JCB");
        CardType cardType13 = cardType5;
        MASTERCARD = new CardType("MasterCard");
        CardType cardType14 = cardType4;
        VISA = new CardType("Visa");
        CardType cardType15 = cardType3;
        MAESTRO = new CardType("Maestro");
        CardType cardType16 = cardType2;
        UNKNOWN = new CardType("Unknown");
        CardType cardType17 = cardType;
        INSUFFICIENT_DIGITS = new CardType("More digits required");
        $VALUES = new CardType[]{cardType10, object2, cardType11, cardType12, cardType13, cardType14, cardType15, cardType16, cardType17};
        minDigits = 1;
        intervalLookup = new HashMap<Pair<String, String>, CardType>();
        intervalLookup.put(CardType.getNewPair("2221", "2720"), cardType13);
        intervalLookup.put(CardType.getNewPair("300", "305"), object2);
        intervalLookup.put(CardType.getNewPair("309", null), object2);
        intervalLookup.put(CardType.getNewPair("34", null), cardType10);
        intervalLookup.put(CardType.getNewPair("3528", "3589"), cardType12);
        intervalLookup.put(CardType.getNewPair("36", null), object2);
        intervalLookup.put(CardType.getNewPair("37", null), cardType10);
        intervalLookup.put(CardType.getNewPair("38", "39"), object2);
        intervalLookup.put(CardType.getNewPair("4", null), cardType14);
        intervalLookup.put(CardType.getNewPair("50", null), cardType15);
        intervalLookup.put(CardType.getNewPair("51", "55"), cardType13);
        intervalLookup.put(CardType.getNewPair("56", "59"), cardType15);
        intervalLookup.put(CardType.getNewPair("6011", null), cardType11);
        intervalLookup.put(CardType.getNewPair("61", null), cardType15);
        intervalLookup.put(CardType.getNewPair("62", null), cardType11);
        intervalLookup.put(CardType.getNewPair("63", null), cardType15);
        intervalLookup.put(CardType.getNewPair("644", "649"), cardType11);
        intervalLookup.put(CardType.getNewPair("65", null), cardType11);
        intervalLookup.put(CardType.getNewPair("66", "69"), cardType15);
        intervalLookup.put(CardType.getNewPair("88", null), cardType11);
        for (Map.Entry entry : CardType.getIntervalLookup().entrySet()) {
            minDigits = Math.max(minDigits, ((String)((Pair)entry.getKey()).first).length());
            if (((Pair)entry.getKey()).second == null) continue;
            minDigits = Math.max(minDigits, ((String)((Pair)entry.getKey()).second).length());
        }
    }

    public String toString() {
        return this.name;
    }

    public int numberLength() {
        int n;
        switch (1.$SwitchMap$eu$nets$pia$cardio$CardType[this.ordinal()]) {
            default: {
                n = -1;
                break;
            }
            case 8: {
                n = minDigits;
                break;
            }
            case 7: {
                n = 14;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n = 16;
                break;
            }
            case 1: {
                n = 15;
            }
        }
        return n;
    }

    public int cvvLength() {
        int n;
        switch (1.$SwitchMap$eu$nets$pia$cardio$CardType[this.ordinal()]) {
            default: {
                n = -1;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                n = 3;
                break;
            }
            case 1: {
                n = 4;
            }
        }
        return n;
    }
}

