/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.os.Parcel;
import android.os.Parcelable;
import eu.nets.pia.cardio.CardType;
import eu.nets.pia.cardio.CreditCardNumber;
import java.util.UUID;

public class CreditCard
implements Parcelable {
    public static final int EXPIRY_MAX_FUTURE_YEARS = 15;
    private static final String TAG = "CreditCard";
    public static final Parcelable.Creator<CreditCard> CREATOR = new Parcelable.Creator<CreditCard>(){

        public CreditCard createFromParcel(Parcel parcel) {
            return new CreditCard(parcel, null);
        }

        public CreditCard[] newArray(int n) {
            return new CreditCard[n];
        }
    };
    public String cardNumber;
    public int expiryMonth;
    public int expiryYear;
    public String cvv;
    public String postalCode;
    public String cardholderName;
    String scanId;
    boolean flipped;
    int yoff;
    int[] xoff;

    public CreditCard() {
        this.expiryMonth = 0;
        this.expiryYear = 0;
        this.flipped = false;
        this.xoff = new int[16];
        this.scanId = UUID.randomUUID().toString();
    }

    public CreditCard(String string2, int n, int n2, String string3, String string4, String string5) {
        this.flipped = false;
        this.cardNumber = string2;
        this.expiryMonth = n;
        this.expiryYear = n2;
        this.cvv = string3;
        this.postalCode = string4;
        this.cardholderName = string5;
    }

    private CreditCard(Parcel parcel) {
        this.expiryMonth = 0;
        this.expiryYear = 0;
        this.flipped = false;
        this.cardNumber = parcel.readString();
        this.expiryMonth = parcel.readInt();
        this.expiryYear = parcel.readInt();
        this.cvv = parcel.readString();
        this.postalCode = parcel.readString();
        this.cardholderName = parcel.readString();
        this.scanId = parcel.readString();
        this.yoff = parcel.readInt();
        this.xoff = parcel.createIntArray();
    }

    public /* synthetic */ CreditCard(Parcel parcel, 1 var2_2) {
        this(parcel);
    }

    public int describeContents() {
        return 0;
    }

    public final void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.cardNumber);
        parcel.writeInt(this.expiryMonth);
        parcel.writeInt(this.expiryYear);
        parcel.writeString(this.cvv);
        parcel.writeString(this.postalCode);
        parcel.writeString(this.cardholderName);
        parcel.writeString(this.scanId);
        parcel.writeInt(this.yoff);
        parcel.writeIntArray(this.xoff);
    }

    public String getLastFourDigitsOfCardNumber() {
        String string2 = this.cardNumber;
        if (string2 != null) {
            int n = Math.min(4, string2.length());
            String string3 = this.cardNumber;
            return string3.substring(string3.length() - n);
        }
        return "";
    }

    public String getRedactedCardNumber() {
        String string2 = this.cardNumber;
        if (string2 != null) {
            String string3 = string2;
            string2 = "";
            if (string3.length() > 4) {
                string2 = "" + String.format("%" + (this.cardNumber.length() - 4) + "s", "").replace(' ', '\u2022');
            }
            return CreditCardNumber.formatString(string2 + this.getLastFourDigitsOfCardNumber(), false, CardType.fromCardNumber(this.cardNumber));
        }
        return "";
    }

    public CardType getCardType() {
        return CardType.fromCardNumber(this.cardNumber);
    }

    public String getFormattedCardNumber() {
        return CreditCardNumber.formatString(this.cardNumber);
    }

    public boolean isExpiryValid() {
        return CreditCardNumber.isDateValid(this.expiryMonth, this.expiryYear);
    }

    public String toString() {
        String string2 = "{" + (Object)((Object)((CreditCard)((Object)stringBuilder)).getCardType()) + ": " + ((CreditCard)((Object)stringBuilder)).getRedactedCardNumber();
        if (((CreditCard)((Object)stringBuilder)).expiryMonth > 0 || ((CreditCard)((Object)stringBuilder)).expiryYear > 0) {
            string2 = string2 + "  expiry:" + ((CreditCard)((Object)stringBuilder)).expiryMonth + "/" + ((CreditCard)((Object)stringBuilder)).expiryYear;
        }
        if (((CreditCard)((Object)stringBuilder)).postalCode != null) {
            string2 = string2 + "  postalCode:" + ((CreditCard)((Object)stringBuilder)).postalCode;
        }
        if (((CreditCard)((Object)stringBuilder)).cardholderName != null) {
            string2 = string2 + "  cardholderName:" + ((CreditCard)((Object)stringBuilder)).cardholderName;
        }
        if (((CreditCard)((Object)stringBuilder)).cvv != null) {
            CreditCard creditCard = stringBuilder;
            StringBuilder stringBuilder = new StringBuilder().append(string2).append("  cvvLength:");
            string2 = creditCard.cvv;
            int n = string2 != null ? string2.length() : 0;
            string2 = stringBuilder.append(n).toString();
        }
        return string2 + "}";
    }
}

