/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.text.Editable;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import eu.nets.pia.cardio.CreditCardNumber;
import eu.nets.pia.cardio.Validator;
import java.util.Date;

class ExpiryValidator
implements Validator {
    public int month;
    public int year;
    private boolean fullLength;

    public ExpiryValidator() {
    }

    public ExpiryValidator(int n, int n2) {
        this.month = n;
        this.year = n2;
        n = n > 0 && n2 > 0 ? 1 : 0;
        this.fullLength = n;
        if (n2 < 2000) {
            this.year = n2 + 2000;
        }
    }

    public void afterTextChanged(Editable object) {
        int n;
        boolean bl = object.length() >= 5;
        this.fullLength = bl;
        if ((object = object.toString()) == null) {
            return;
        }
        if ((object = CreditCardNumber.getDateForString((String)object)) == null) {
            return;
        }
        this.month = ((Date)object).getMonth() + 1;
        this.year = n = ((Date)object).getYear();
        if (n < 1900) {
            this.year = n + 1900;
        }
    }

    public void beforeTextChanged(CharSequence charSequence, int n, int n2, int n3) {
        ExpiryValidator expiryValidator = this;
        expiryValidator.month = 0;
        expiryValidator.year = 0;
        expiryValidator.fullLength = false;
    }

    public void onTextChanged(CharSequence charSequence, int n, int n2, int n3) {
    }

    @Override
    public String getValue() {
        Object[] objectArray = new Object[2];
        Object[] objectArray2 = objectArray;
        objectArray2[0] = this.month;
        objectArray[1] = this.year % 100;
        return String.format("%02d/%02d", objectArray2);
    }

    @Override
    public boolean hasFullLength() {
        return this.fullLength;
    }

    @Override
    public boolean isValid() {
        int n = this.month;
        if (n >= 1 && 12 >= n) {
            Date date;
            Date date2 = date;
            date = new Date();
            if (this.year > date2.getYear() + 1900 + 15) {
                return false;
            }
            return this.year > date2.getYear() + 1900 || this.year == date2.getYear() + 1900 && this.month >= date2.getMonth() + 1;
        }
        return false;
    }

    public CharSequence filter(CharSequence charSequence, int n, int n2, Spanned spanned, int n3, int n4) {
        String string2;
        int n5;
        SpannableStringBuilder spannableStringBuilder;
        ExpiryValidator expiryValidator = spannableStringBuilder;
        spannableStringBuilder = new SpannableStringBuilder(charSequence);
        if (n3 == 0 && expiryValidator.length() > 0 && '1' < expiryValidator.charAt(0) && expiryValidator.charAt(0) <= '9') {
            expiryValidator.insert(0, "0");
            ++n2;
        }
        if (n3 - (n5 = n4 - n3) <= 2 && n3 + n2 - n5 >= 2 && ((n5 = 2 - n3) == n2 || n5 >= 0 && n5 < n2 && expiryValidator.charAt(n5) != '/')) {
            expiryValidator.insert(n5, "/");
            ++n2;
        }
        if ((string2 = new SpannableStringBuilder((CharSequence)spanned).replace(n3, n4, (CharSequence)((Object)expiryValidator), n, n2).toString()).length() >= 1 && (string2.charAt(0) < '0' || '1' < string2.charAt(0))) {
            return "";
        }
        if (string2.length() >= 2) {
            if (string2.charAt(0) != '0' && string2.charAt(1) > '2') {
                return "";
            }
            if (string2.charAt(0) == '0' && string2.charAt(1) == '0') {
                return "";
            }
        }
        if (string2.length() > 5) {
            return "";
        }
        return expiryValidator;
    }
}

