/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.Point;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.graphics.drawable.GradientDrawable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.MotionEvent;
import android.view.View;
import eu.nets.pia.cardio.CardIOActivity;
import eu.nets.pia.cardio.CreditCard;
import eu.nets.pia.cardio.DetectionInfo;
import eu.nets.pia.cardio.Logo;
import eu.nets.pia.cardio.Torch;
import eu.nets.pia.cardio.Util;
import java.lang.ref.WeakReference;

class OverlayView
extends View {
    private static final String TAG = "OverlayView";
    private static final float GUIDE_FONT_SIZE = 26.0f;
    private static final float GUIDE_LINE_PADDING = 8.0f;
    private static final float GUIDE_LINE_HEIGHT = 34.0f;
    private static final float CARD_NUMBER_MARKUP_FONT_SIZE = 28.0f;
    private static final GradientDrawable.Orientation[] GRADIENT_ORIENTATIONS = new GradientDrawable.Orientation[]{GradientDrawable.Orientation.TOP_BOTTOM, GradientDrawable.Orientation.LEFT_RIGHT, GradientDrawable.Orientation.BOTTOM_TOP, GradientDrawable.Orientation.RIGHT_LEFT};
    private static final int GUIDE_STROKE_WIDTH = 17;
    private static final float CORNER_RADIUS_SIZE = 0.06666667f;
    private static final int TORCH_WIDTH = 70;
    private static final int TORCH_HEIGHT = 50;
    private static final int LOGO_MAX_WIDTH = 100;
    private static final int LOGO_MAX_HEIGHT = 50;
    private static final int BUTTON_TOUCH_TOLERANCE = 20;
    private final WeakReference<CardIOActivity> mScanActivityRef;
    private DetectionInfo mDInfo;
    private Bitmap mBitmap;
    GradientDrawable mScanLineDrawable;
    private Rect mGuide;
    private CreditCard mDetectedCard;
    private int mRotation;
    private int mState;
    private int guideColor;
    private boolean hideCardIOLogo;
    private String scanInstructions;
    private GradientDrawable mGradientDrawable;
    private final Paint mGuidePaint;
    private final Paint mLockedBackgroundPaint;
    private Path mLockedBackgroundPath;
    private Rect mCameraPreviewRect;
    private final Torch mTorch;
    private final Logo mLogo;
    private Rect mTorchRect;
    private Rect mLogoRect;
    private final boolean mShowTorch;
    private int mRotationFlip;
    private float mScale = 1.0f;
    private Context mContext;
    private int surfaceViewTop = 0;

    public OverlayView(CardIOActivity cardIOActivity, AttributeSet attributeSet, boolean bl, Context context) {
        super((Context)cardIOActivity, attributeSet);
        float f2;
        this.mContext = context;
        this.mShowTorch = bl;
        this.mScanActivityRef = new WeakReference<CardIOActivity>(cardIOActivity);
        this.mRotationFlip = 1;
        this.mScale = f2 = this.getResources().getDisplayMetrics().density / 1.5f;
        float f3 = f2;
        f2 = f3 * 70.0f;
        this.mTorch = new Torch(f2, f3 * 50.0f);
        this.mLogo = new Logo((Context)cardIOActivity);
        this.mGuidePaint = new Paint(1);
        this.mLockedBackgroundPaint = new Paint(1);
        this.mLockedBackgroundPaint.clearShadowLayer();
        this.mLockedBackgroundPaint.setStyle(Paint.Style.FILL);
        this.mLockedBackgroundPaint.setColor(-1157627904);
        this.scanInstructions = "";
    }

    private Rect guideStrokeRect(int n, int n2, int n3, int n4) {
        Rect rect;
        int n5 = (int)(this.mScale * 8.0f);
        Rect rect2 = rect;
        rect2();
        rect2.left = Math.min(n, n3) - n5;
        rect2.right = Math.max(n, n3) + n5;
        rect2.top = Math.min(n2, n4) - n5;
        rect.bottom = Math.max(n2, n4) + n5;
        return rect;
    }

    private void decorateBitmap() {
        Canvas canvas;
        Paint paint;
        Paint paint2;
        Canvas canvas2;
        RectF rectF;
        OverlayView overlayView = this;
        RectF rectF2 = rectF;
        OverlayView overlayView2 = this;
        float f2 = overlayView2.mBitmap.getWidth() - 2;
        float f3 = overlayView2.mBitmap.getHeight() - 2;
        rectF = new RectF(2.0f, 2.0f, f2, f3);
        f2 = (float)overlayView.mBitmap.getHeight() * 0.06666667f;
        Bitmap bitmap = Bitmap.createBitmap((int)overlayView.mBitmap.getWidth(), (int)this.mBitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas3 = canvas2;
        RectF rectF3 = rectF2;
        Canvas canvas4 = canvas3;
        canvas4(bitmap);
        canvas4.drawColor(0);
        rectF2 = paint2;
        new Paint(1).setColor(-16777216);
        rectF2.setStyle(Paint.Style.FILL);
        canvas2.drawRoundRect(rectF3, f2, f2, (Paint)rectF2);
        rectF2 = paint;
        new Paint().setFilterBitmap(false);
        Canvas canvas5 = canvas;
        canvas5(this.mBitmap);
        rectF2.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, (Paint)rectF2);
        rectF2.setXfermode(null);
        bitmap.recycle();
    }

    public int getGuideColor() {
        return this.guideColor;
    }

    public void setGuideColor(int n) {
        this.guideColor = n;
    }

    public boolean getHideCardIOLogo() {
        return this.hideCardIOLogo;
    }

    public void setHideCardIOLogo(boolean bl) {
        this.hideCardIOLogo = bl;
    }

    public String getScanInstructions() {
        return this.scanInstructions;
    }

    public void setScanInstructions(String string2) {
        this.scanInstructions = string2;
    }

    public void setGuideAndRotation(Rect rect, int n) {
        float f2;
        Point point;
        int n2;
        OverlayView overlayView = this;
        this.mRotation = n;
        overlayView.mGuide = rect;
        overlayView.invalidate();
        if (overlayView.mScale < 1.0f) {
            OverlayView overlayView2 = this;
            float f3 = ((CardIOActivity)((Object)overlayView2.mScanActivityRef.get())).getActionBarSize();
            DisplayMetrics displayMetrics = ((CardIOActivity)((Object)overlayView2.mScanActivityRef.get())).getResources().getDisplayMetrics();
            n2 = (int)TypedValue.applyDimension((int)1, (float)f3, (DisplayMetrics)displayMetrics);
        } else {
            n2 = 0;
        }
        if (this.mRotation % 180 != 0) {
            Point point2;
            point = point2;
            f2 = this.mScale;
            int n3 = (int)(f2 * 40.0f);
            point2 = new Point(n3, (int)((float)(n2 + 40) * f2));
            this.mRotationFlip = -1;
        } else {
            Point point3;
            point = point3;
            f2 = this.mScale;
            int n4 = (int)(f2 * 40.0f);
            point3 = new Point(n4, (int)((float)(n2 + 40) * f2));
            this.mRotationFlip = 1;
        }
        if (this.mCameraPreviewRect != null) {
            OverlayView overlayView3 = this;
            Rect rect2 = this.mCameraPreviewRect;
            float f4 = this.mScale;
            int n5 = (int)(f4 * 70.0f);
            overlayView3.mTorchRect = Util.rectGivenCenter(new Point(rect2.left + point.x, rect2.top + point.y), n5, (int)(f4 * 50.0f));
            Rect rect3 = this.mCameraPreviewRect;
            float f5 = this.mScale;
            int n6 = (int)(f5 * 100.0f);
            overlayView3.mLogoRect = Util.rectGivenCenter(new Point(rect3.right - point.x, rect3.top + point.y), n6, (int)(f5 * 50.0f));
            int[] nArray = new int[2];
            int[] nArray2 = nArray;
            nArray[0] = -1;
            nArray[1] = -16777216;
            point = GRADIENT_ORIENTATIONS[this.mRotation / 90 % 4];
            this.mGradientDrawable = new GradientDrawable((GradientDrawable.Orientation)point, nArray2);
            this.mGradientDrawable.setGradientType(0);
            overlayView3.mGradientDrawable.setBounds(this.mGuide);
            overlayView3.mGradientDrawable.setAlpha(50);
            this.mLockedBackgroundPath = new Path();
            this.mLockedBackgroundPath.addRect(new RectF(this.mCameraPreviewRect), Path.Direction.CW);
            overlayView3.mLockedBackgroundPath.addRect(new RectF(this.mGuide), Path.Direction.CCW);
        }
    }

    public void setBitmap(Bitmap bitmap) {
        Bitmap bitmap2 = this.mBitmap;
        if (bitmap2 != null) {
            bitmap2.recycle();
        }
        this.mBitmap = bitmap;
        if (bitmap != null) {
            this.decorateBitmap();
        }
    }

    public Bitmap getBitmap() {
        return this.mBitmap;
    }

    public void setDetectionInfo(DetectionInfo detectionInfo) {
        DetectionInfo detectionInfo2 = this.mDInfo;
        if (detectionInfo2 != null && !detectionInfo2.sameEdgesAs(detectionInfo)) {
            this.invalidate();
        }
        this.mDInfo = detectionInfo;
    }

    public int getCardX() {
        return this.mGuide.centerX() - this.mBitmap.getWidth() / 2;
    }

    public int getCardY() {
        return this.mGuide.centerY() - this.mBitmap.getHeight() / 2;
    }

    public Bitmap getCardImage() {
        Bitmap bitmap = this.mBitmap;
        if (bitmap != null && !bitmap.isRecycled()) {
            Bitmap bitmap2 = this.mBitmap;
            int n = bitmap2.getWidth();
            int n2 = this.mBitmap.getHeight();
            return Bitmap.createBitmap((Bitmap)bitmap2, (int)0, (int)0, (int)n, (int)n2);
        }
        return null;
    }

    public void onDraw(Canvas canvas) {
        if (this.mGuide != null && this.mCameraPreviewRect != null) {
            int n;
            OverlayView overlayView = this;
            canvas.save();
            overlayView.mGradientDrawable.draw(canvas);
            int n2 = overlayView.mRotation;
            if (n2 != 0 && n2 != 180) {
                Rect rect = this.mGuide;
                n = (rect.right - rect.left) / 4;
            } else {
                Rect rect = this.mGuide;
                n = (rect.bottom - rect.top) / 4;
            }
            DetectionInfo detectionInfo = this.mDInfo;
            if (detectionInfo != null && detectionInfo.numVisibleEdges() == 4) {
                OverlayView overlayView2 = this;
                detectionInfo = overlayView2.mLockedBackgroundPath;
                canvas.drawPath((Path)detectionInfo, overlayView2.mLockedBackgroundPaint);
            }
            OverlayView overlayView3 = this;
            OverlayView overlayView4 = this;
            OverlayView overlayView5 = this;
            OverlayView overlayView6 = this;
            OverlayView overlayView7 = this;
            OverlayView overlayView8 = this;
            OverlayView overlayView9 = this;
            OverlayView overlayView10 = this;
            overlayView10.mGuidePaint.clearShadowLayer();
            overlayView10.mGuidePaint.setStyle(Paint.Style.FILL);
            overlayView10.mGuidePaint.setColor(this.guideColor);
            detectionInfo = overlayView10.mGuide;
            int n3 = ((Rect)detectionInfo).left;
            int n4 = ((Rect)detectionInfo).top;
            Rect rect = overlayView10.guideStrokeRect(n3, n4, n3 + n, n4);
            canvas.drawRect(rect, overlayView10.mGuidePaint);
            Rect rect2 = overlayView9.mGuide;
            int n5 = rect2.left;
            int n6 = rect2.top;
            int n7 = n6 + n;
            Rect rect3 = overlayView9.guideStrokeRect(n5, n6, n5, n7);
            canvas.drawRect(rect3, overlayView9.mGuidePaint);
            rect3 = overlayView8.mGuide;
            int n8 = rect3.right;
            int n9 = rect3.top;
            Rect rect4 = overlayView8.guideStrokeRect(n8, n9, n8 - n, n9);
            canvas.drawRect(rect4, overlayView8.mGuidePaint);
            Rect rect5 = overlayView7.mGuide;
            int n10 = rect5.right;
            n6 = rect5.top;
            n7 = n6 + n;
            Rect rect6 = overlayView7.guideStrokeRect(n10, n6, n10, n7);
            canvas.drawRect(rect6, overlayView7.mGuidePaint);
            rect6 = overlayView6.mGuide;
            int n11 = rect6.left;
            int n12 = rect6.bottom;
            Rect rect7 = overlayView6.guideStrokeRect(n11, n12, n11 + n, n12);
            canvas.drawRect(rect7, overlayView6.mGuidePaint);
            Rect rect8 = overlayView5.mGuide;
            int n13 = rect8.left;
            n6 = rect8.bottom;
            n7 = n6 - n;
            Rect rect9 = overlayView5.guideStrokeRect(n13, n6, n13, n7);
            canvas.drawRect(rect9, overlayView5.mGuidePaint);
            rect9 = overlayView4.mGuide;
            int n14 = rect9.right;
            int n15 = rect9.bottom;
            Rect rect10 = overlayView4.guideStrokeRect(n14, n15, n14 - n, n15);
            canvas.drawRect(rect10, overlayView4.mGuidePaint);
            Rect rect11 = overlayView3.mGuide;
            int n16 = rect11.right;
            n6 = rect11.bottom;
            n = n6 - n;
            Object object = overlayView3.guideStrokeRect(n16, n6, n16, n);
            canvas.drawRect(object, overlayView3.mGuidePaint);
            object = this.mDInfo;
            if (object != null) {
                if (object.topEdge) {
                    OverlayView overlayView11 = this;
                    Rect rect12 = overlayView11.mGuide;
                    int n17 = rect12.left;
                    n16 = rect12.top;
                    n6 = rect12.right;
                    object = overlayView11.guideStrokeRect(n17, n16, n6, n16);
                    canvas.drawRect(object, overlayView11.mGuidePaint);
                }
                if (this.mDInfo.bottomEdge) {
                    OverlayView overlayView12 = this;
                    Rect rect13 = overlayView12.mGuide;
                    int n18 = rect13.left;
                    n16 = rect13.bottom;
                    n6 = rect13.right;
                    object = overlayView12.guideStrokeRect(n18, n16, n6, n16);
                    canvas.drawRect(object, overlayView12.mGuidePaint);
                }
                if (this.mDInfo.leftEdge) {
                    OverlayView overlayView13 = this;
                    Rect rect14 = overlayView13.mGuide;
                    int n19 = rect14.left;
                    n16 = rect14.top;
                    n6 = rect14.bottom;
                    object = overlayView13.guideStrokeRect(n19, n16, n19, n6);
                    canvas.drawRect(object, overlayView13.mGuidePaint);
                }
                if (this.mDInfo.rightEdge) {
                    OverlayView overlayView14 = this;
                    Rect rect15 = overlayView14.mGuide;
                    int n20 = rect15.right;
                    n16 = rect15.top;
                    n6 = rect15.bottom;
                    object = overlayView14.guideStrokeRect(n20, n16, n20, n6);
                    canvas.drawRect(object, overlayView14.mGuidePaint);
                }
                if (this.mDInfo.numVisibleEdges() < 3) {
                    OverlayView overlayView15 = this;
                    float f2 = overlayView15.mScale;
                    float f3 = f2 * 34.0f;
                    float f4 = f2 * 26.0f;
                    Util.setupTextPaintStyle(overlayView15.mGuidePaint, this.mContext);
                    overlayView15.mGuidePaint.setTextAlign(Paint.Align.CENTER);
                    overlayView15.mGuidePaint.setTextSize(f4);
                    n6 = overlayView15.surfaceViewTop;
                    if (n6 == 0) {
                        n6 = this.mGuide.top;
                    } else {
                        int n21 = n6;
                        n6 = this.mGuide.top;
                        n6 = n21 / 3 + n6;
                    }
                    Rect rect16 = this.mGuide;
                    n7 = rect16.left;
                    canvas.translate((float)(rect16.width() / 2 + n7), (float)(this.mGuide.height() / 2 + n6));
                    canvas.rotate((float)(this.mRotationFlip * this.mRotation));
                    String[] stringArray = this.scanInstructions;
                    if (this.scanInstructions != null && stringArray != "") {
                        stringArray = stringArray.split("\n");
                        Rect rect17 = this.mGuide;
                        n7 = rect17.top;
                        n7 = (int)((float)(rect17.height() / 2 + n7)) / 2;
                        f4 = -((f3 * (float)(stringArray.length - 1) - f4) / 2.0f) - 3.0f - (float)n7;
                        for (n7 = 0; n7 < stringArray.length; ++n7) {
                            String string2 = stringArray[n7];
                            Paint paint = this.mGuidePaint;
                            canvas.drawText(string2, 0.0f, f4, paint);
                            f4 += f3;
                        }
                    }
                }
            }
            canvas.restore();
            if (!this.hideCardIOLogo) {
                canvas.save();
                canvas.translate(this.mLogoRect.exactCenterX(), this.mLogoRect.exactCenterY());
                canvas.rotate((float)(this.mRotationFlip * this.mRotation));
                float f5 = this.mScale;
                float f6 = f5 * 100.0f;
                this.mLogo.draw(canvas, f6, f5 * 50.0f);
                canvas.restore();
            }
            if (this.mShowTorch) {
                canvas.save();
                canvas.translate(this.mTorchRect.exactCenterX(), this.mTorchRect.exactCenterY());
                canvas.rotate((float)(this.mRotationFlip * this.mRotation));
                this.mTorch.draw(canvas);
                canvas.restore();
            }
            return;
        }
    }

    public void setDetectedCard(CreditCard creditCard) {
        this.mDetectedCard = creditCard;
    }

    /*
     * Unable to fully structure code
     */
    public boolean onTouchEvent(MotionEvent var1_1) {
        block9: {
            try {
                if ((var1_1.getAction() & 255) != 0) break block9;
            }
            catch (NullPointerException v0) {}
            v1 = this;
            v2 = v3;
            v4 = v3;
            v5 = (int)var1_1.getX();
            v6 = (int)var1_1.getY();
            v2(v5, v6);
            var1_1 = Util.rectGivenCenter(v4, 20, 20);
            if (!v1.mShowTorch) ** GOTO lbl24
            var2_2 = this.mTorchRect;
            if (var2_2 == null) ** GOTO lbl24
            if (!Rect.intersects((Rect)var2_2, (Rect)var1_1)) ** GOTO lbl24
            ((CardIOActivity)this.mScanActivityRef.get()).toggleFlash();
            break block9;
lbl24:
            // 3 sources

            ((CardIOActivity)this.mScanActivityRef.get()).triggerAutoFocus();
        }
        return false;
    }

    public void markupCard() {
        CreditCard creditCard;
        if (this.mBitmap != null && (creditCard = this.mDetectedCard) != null) {
            Paint paint;
            Canvas canvas;
            int n;
            if (creditCard.flipped) {
                Matrix matrix;
                creditCard = matrix;
                OverlayView overlayView = this;
                creditCard();
                float f2 = overlayView.mBitmap.getWidth() / 2;
                float f3 = overlayView.mBitmap.getHeight() / 2;
                matrix.setRotate(180.0f, f2, f3);
                Bitmap bitmap = this.mBitmap;
                int n2 = bitmap.getWidth();
                n = this.mBitmap.getHeight();
                this.mBitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)n2, (int)n, (Matrix)creditCard, (boolean)false);
            }
            OverlayView overlayView = this;
            creditCard = canvas;
            canvas = new Canvas(this.mBitmap);
            Paint paint2 = paint;
            paint2();
            Util.setupTextPaintStyle(paint2, this.mContext);
            paint.setTextSize(this.mScale * 28.0f);
            n = overlayView.mDetectedCard.cardNumber.length();
            float f4 = (float)overlayView.mBitmap.getWidth() / 428.0f;
            int n3 = (int)((float)overlayView.mDetectedCard.yoff * f4 - 6.0f);
            for (int i = 0; i < n; ++i) {
                String string2 = "" + this.mDetectedCard.cardNumber.charAt(i);
                float f5 = (int)((float)this.mDetectedCard.xoff[i] * f4);
                float f6 = n3;
                creditCard.drawText(string2, f5, f6, paint2);
            }
            return;
        }
    }

    public boolean isAnimating() {
        return this.mState != 0;
    }

    public void setCameraPreviewRect(Rect rect) {
        this.mCameraPreviewRect = rect;
    }

    public void setTorchOn(boolean bl) {
        OverlayView overlayView = this;
        overlayView.mTorch.setOn(bl);
        overlayView.invalidate();
    }

    public void setUseCardIOLogo(boolean bl) {
        this.mLogo.loadLogo(bl);
    }

    public Rect getTorchRect() {
        return this.mTorchRect;
    }

    public void setSurfaceViewTop(int n) {
        this.surfaceViewTop = n;
    }
}

