/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.drawable.shapes.RoundRectShape;
import java.util.Arrays;

class Torch {
    private static final String TAG = "Torch";
    private static final float CORNER_RADIUS = 5.0f;
    private static final int BG_ALPHA = 96;
    private boolean mOn = false;
    private float mWidth;
    private float mHeight;

    public Torch(float f2, float f3) {
        this.mWidth = f2;
        this.mHeight = f3;
    }

    private static Path createBoltPath() {
        Matrix matrix;
        Path path = new Path();
        path.moveTo(10.0f, 0.0f);
        path.lineTo(0.0f, 11.0f);
        path.lineTo(6.0f, 11.0f);
        path.lineTo(2.0f, 20.0f);
        path.lineTo(13.0f, 8.0f);
        path.lineTo(7.0f, 8.0f);
        path.lineTo(10.0f, 0.0f);
        path.setLastPoint(10.0f, 0.0f);
        Matrix matrix2 = matrix;
        new Matrix().postTranslate(-6.5f, -10.0f);
        matrix2.postScale(0.05f, 0.05f);
        path.transform(matrix2);
        return path;
    }

    public void draw(Canvas canvas) {
        Paint paint;
        RoundRectShape roundRectShape;
        Paint paint2;
        Paint paint3;
        canvas.save();
        canvas.translate(-this.mWidth / 2.0f, -this.mHeight / 2.0f);
        float f2 = 5.0f;
        Paint paint4 = paint3;
        new Paint().setColor(-16777216);
        paint4.setStyle(Paint.Style.STROKE);
        paint4.setAntiAlias(true);
        paint4.setStrokeWidth(1.5f);
        Paint paint5 = paint2;
        new Paint().setStyle(Paint.Style.FILL);
        paint5.setColor(-1);
        if (this.mOn) {
            paint5.setAlpha(192);
        } else {
            paint5.setAlpha(96);
        }
        float[] fArray = new float[8];
        Arrays.fill(fArray, f2);
        RoundRectShape roundRectShape2 = roundRectShape;
        Torch torch = this;
        roundRectShape2(fArray, null, null);
        float f3 = torch.mWidth;
        roundRectShape2.resize(f3, torch.mHeight);
        roundRectShape2.draw(canvas, paint5);
        roundRectShape.draw(canvas, paint4);
        Paint paint6 = paint;
        new Paint().setStyle(Paint.Style.FILL_AND_STROKE);
        paint6.setAntiAlias(true);
        if (this.mOn) {
            paint6.setColor(-1);
        } else {
            paint6.setColor(-16777216);
        }
        Canvas canvas2 = canvas;
        canvas = Torch.createBoltPath();
        Matrix matrix = new Matrix();
        float f4 = this.mHeight * 0.8f;
        matrix.postScale(f4, f4);
        canvas.transform(matrix);
        canvas2.translate(this.mWidth / 2.0f, this.mHeight / 2.0f);
        canvas2.drawPath((Path)canvas, paint6);
        canvas2.restore();
    }

    public void setOn(boolean bl) {
        this.mOn = bl;
    }
}

