/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio;

import android.content.Context;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Point;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.hardware.Camera;
import android.os.Build;
import android.os.Debug;
import android.util.Log;
import eu.nets.pia.PiaInterfaceConfiguration;
import eu.nets.pia.cardio.CardScanner;
import eu.nets.pia.cardio.OverlayView;
import eu.nets.pia.ui.themes.PiaTheme;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;

class Util {
    private static final String TAG = "Util";
    private static final boolean TORCH_BLACK_LISTED = Build.MODEL.equals("DROID2");
    public static final String PUBLIC_LOG_TAG = "card.io";
    private static Boolean sHardwareSupported;

    public static boolean deviceSupportsTorch(Context context) {
        return !TORCH_BLACK_LISTED && context.getPackageManager().hasSystemFeature("android.hardware.camera.flash");
    }

    public static String manifestHasConfigChange(ResolveInfo objectArray, Class clazz) {
        String string2 = null;
        if (objectArray == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = clazz.getName();
            string2 = String.format("Didn't find %s in the AndroidManifest.xml", objectArray);
        } else if (!Util.hasConfigFlag(objectArray.activityInfo.configChanges, 128)) {
            string2 = clazz.getName().concat(" requires attribute android:configChanges=\"orientation\"");
        }
        if (string2 != null) {
            Log.e((String)PUBLIC_LOG_TAG, (String)string2);
        }
        return string2;
    }

    public static boolean hasConfigFlag(int n, int n2) {
        return (n & n2) == n2;
    }

    public static boolean hardwareSupported() {
        if (sHardwareSupported == null) {
            sHardwareSupported = Util.hardwareSupportCheck();
        }
        return sHardwareSupported;
    }

    private static boolean hardwareSupportCheck() {
        if (!CardScanner.processorSupported()) {
            Log.w((String)PUBLIC_LOG_TAG, (String)"- Processor type is not supported");
            return false;
        }
        Camera camera = null;
        try {
            camera = Camera.open();
        }
        catch (RuntimeException runtimeException) {
            if (Build.VERSION.SDK_INT >= 23) {
                return true;
            }
            Log.w((String)PUBLIC_LOG_TAG, (String)("- Error opening camera: " + runtimeException));
        }
        if (camera == null) {
            Log.w((String)PUBLIC_LOG_TAG, (String)"- No camera found");
            return false;
        }
        List list = camera.getParameters().getSupportedPreviewSizes();
        camera.release();
        boolean bl = false;
        for (Camera.Size size : list) {
            if (size.width != 640 || size.height != 480) continue;
            bl = true;
            break;
        }
        if (!bl) {
            Log.w((String)PUBLIC_LOG_TAG, (String)"- Camera resolution is insufficient");
            return false;
        }
        return true;
    }

    public static String getNativeMemoryStats() {
        return "(free/alloc'd/total)" + Debug.getNativeHeapFreeSize() + "/" + Debug.getNativeHeapAllocatedSize() + "/" + Debug.getNativeHeapSize();
    }

    public static void logNativeMemoryStats() {
        Util.getNativeMemoryStats();
    }

    public static Rect rectGivenCenter(Point point, int n, int n2) {
        Point point2 = point;
        int n3 = point2.x;
        int n4 = n3 - (n /= 2);
        int n5 = point2.y;
        n3 = n2 / 2;
        n2 = n5 - n3;
        n = n3 + n;
        n3 = n5 + n3;
        return new Rect(n4, n2, n, n3);
    }

    public static void setupTextPaintStyle(Paint object, Context context) {
        Paint paint = object;
        paint.setColor(PiaTheme.getUiTheme(context).getCardIOTextColor());
        paint.setStyle(Paint.Style.FILL);
        if (PiaInterfaceConfiguration.getInstance().getCardIOTextFont() != null) {
            object.setTypeface(Typeface.create((Typeface)PiaInterfaceConfiguration.getInstance().getCardIOTextFont(), (int)1));
        } else {
            object.setTypeface(Typeface.create((Typeface)Typeface.SANS_SERIF, (int)1));
        }
        Paint paint2 = object;
        paint2.setAntiAlias(true);
        float[] fArray = new float[3];
        object = fArray;
        fArray[0] = 0.0f;
        fArray[1] = 0.0f;
        fArray[2] = 0.0f;
        int n = Color.HSVToColor((int)200, (float[])object);
        paint2.setShadowLayer(1.5f, 0.5f, 0.0f, n);
    }

    public static void writeCapturedCardImageIfNecessary(Intent object, Intent intent, OverlayView overlayView) {
        if (object.getBooleanExtra("io.card.payment.returnCardImage", false) && overlayView != null && overlayView.getBitmap() != null) {
            ByteArrayOutputStream byteArrayOutputStream;
            object = byteArrayOutputStream;
            object();
            overlayView.getBitmap().compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)object);
            intent.putExtra("io.card.payment.capturedCardImage", byteArrayOutputStream.toByteArray());
        }
    }
}

