/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio.ui;

import android.app.ActionBar;
import android.app.Activity;
import android.content.res.Resources;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.widget.TextView;
import eu.nets.pia.cardio.ui.Appearance;

public class ActivityHelper {
    public static void addActionBarIfSupported(Activity activity) {
        if (ActivityHelper.actionBarSupported()) {
            activity.requestWindowFeature(8);
        }
    }

    public static void setupActionBarIfSupported(Activity activity, TextView textView, String string2, String string3, Drawable drawable2) {
        if (string3 == null) {
            string3 = "";
        }
        activity.setTitle((CharSequence)(string3 + string2));
        if (ActivityHelper.actionBarSupported() && ActivityHelper.actionBarNonNull(activity)) {
            ActivityHelper.setupActionBar(activity, string2, drawable2);
            if (textView != null) {
                textView.setVisibility(8);
            }
        } else if (textView != null) {
            textView.setText((CharSequence)string2);
        }
    }

    private static boolean actionBarNonNull(Activity activity) {
        return activity.getActionBar() != null;
    }

    private static void setupActionBar(Activity activity, String string2, Drawable drawable2) {
        Activity activity2 = activity;
        activity = activity2.getActionBar();
        activity.setBackgroundDrawable(Appearance.ACTIONBAR_BACKGROUND);
        activity.setTitle((CharSequence)string2);
        string2 = (TextView)activity2.findViewById(Resources.getSystem().getIdentifier("action_bar_title", "id", "android"));
        if (string2 != null) {
            string2.setTextColor(-1);
        }
        activity.setDisplayHomeAsUpEnabled(false);
        if (drawable2 != null && Build.VERSION.SDK_INT >= 14) {
            ActivityHelper.setActionBarHomeIcon((ActionBar)activity, drawable2);
        } else {
            activity.setDisplayShowHomeEnabled(false);
        }
    }

    private static boolean actionBarSupported() {
        return Build.VERSION.SDK_INT >= 11;
    }

    private static void setActionBarHomeIcon(ActionBar actionBar, Drawable drawable2) {
        actionBar.setIcon(drawable2);
    }

    public static boolean holoSupported() {
        return Build.VERSION.SDK_INT >= 11;
    }

    public static void setActivityTheme(Activity activity, boolean bl) {
        if (bl && activity.getApplicationInfo().theme != 0) {
            Activity activity2 = activity;
            activity2.setTheme(activity2.getApplicationInfo().theme);
        } else if (ActivityHelper.holoSupported()) {
            activity.setTheme(16973934);
        } else {
            activity.setTheme(16973836);
        }
    }

    public static void setFlagSecure(Activity activity) {
        if (Build.VERSION.SDK_INT >= 11) {
            activity.getWindow().addFlags(8192);
        }
    }
}

