/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio.ui;

import android.content.Context;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.LayerDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.Shape;
import eu.nets.pia.cardio.ui.ViewUtil;

public class Appearance {
    public static final String CONTAINER_MARGIN_HORIZONTAL = "16dip";
    public static final String CONTAINER_MARGIN_VERTICAL = "20dip";
    public static final String BASE_SPACING = "4dip";
    public static final String VERTICAL_SPACING = "8dip";
    public static final String BUTTON_HEIGHT = "54dip";
    public static final String SMALL_BUTTON_HEIGHT = "42dip";
    public static final int[] BUTTON_STATE_PRESSED;
    public static final int[] BUTTON_STATE_NORMAL;
    public static final int[] BUTTON_STATE_DISABLED;
    public static final int[] BUTTON_STATE_FOCUSED;
    public static final int PAY_BLUE_COLOR;
    public static final int PAL_BLUE_COLOR;
    public static final int PAL_BLUE_COLOR_OPACITY_66;
    public static final Drawable ACTIONBAR_BACKGROUND;
    public static final int DEFAULT_BACKGROUND_COLOR;
    public static final int BUTTON_PRIMARY_NORMAL_COLOR;
    public static final int BUTTON_PRIMARY_FOCUS_COLOR;
    public static final int BUTTON_PRIMARY_PRESSED_COLOR;
    public static final int BUTTON_PRIMARY_DISABLED_COLOR;
    public static final int BUTTON_SECONDARY_NORMAL_COLOR;
    public static final int BUTTON_SECONDARY_FOCUS_COLOR;
    public static final int BUTTON_SECONDARY_PRESSED_COLOR;
    public static final int BUTTON_SECONDARY_DISABLED_COLOR;
    public static final int TEXT_COLOR_LIGHT;
    public static final int TEXT_COLOR_EDIT_TEXT = -12303292;
    public static final int TEXT_COLOR_EDIT_TEXT_HINT = -3355444;
    public static final int TEXT_COLOR_ERROR;
    public static final int TEXT_COLOR_LABEL;
    public static final int TEXT_COLOR_BUTTON = -1;
    public static final float TEXT_SIZE_BUTTON = 20.0f;
    public static final float TEXT_SIZE_MEDIUM_BUTTON = 16.0f;
    public static final float TEXT_SIZE_SMALL_BUTTON = 14.0f;
    public static final Typeface TYPEFACE_BUTTON;
    public static final String FOCUS_BORDER_PADDING = "4dip";

    public static Drawable buttonBackgroundPrimary(Context object) {
        StateListDrawable stateListDrawable;
        StateListDrawable stateListDrawable2 = stateListDrawable;
        Context context = object;
        Context context2 = object;
        StateListDrawable stateListDrawable3 = stateListDrawable2;
        stateListDrawable3();
        stateListDrawable3.addState(BUTTON_STATE_PRESSED, (Drawable)new ColorDrawable(BUTTON_PRIMARY_PRESSED_COLOR));
        stateListDrawable3.addState(BUTTON_STATE_DISABLED, (Drawable)new ColorDrawable(BUTTON_PRIMARY_DISABLED_COLOR));
        object = BUTTON_STATE_FOCUSED;
        stateListDrawable2.addState((int[])object, Appearance.buttonBackgroundPrimaryFocused(context2));
        object = BUTTON_STATE_NORMAL;
        stateListDrawable.addState((int[])object, Appearance.buttonBackgroundPrimaryNormal(context));
        return stateListDrawable;
    }

    private static float getFocusBorderWidthPixels(Context context) {
        return ViewUtil.typedDimensionValueToPixels("4dip", context) / 2.0f * context.getResources().getDisplayMetrics().density;
    }

    private static Drawable buttonBackgroundPrimaryNormal(Context context) {
        return Appearance.buttonNormal(BUTTON_PRIMARY_NORMAL_COLOR, Appearance.getFocusBorderWidthPixels(context));
    }

    private static Drawable buttonBackgroundPrimaryFocused(Context context) {
        int n = BUTTON_PRIMARY_FOCUS_COLOR;
        return Appearance.buttonFocused(BUTTON_PRIMARY_NORMAL_COLOR, n, Appearance.getFocusBorderWidthPixels(context));
    }

    public static Drawable buttonBackgroundSecondary(Context object) {
        StateListDrawable stateListDrawable;
        StateListDrawable stateListDrawable2 = stateListDrawable;
        Context context = object;
        Context context2 = object;
        StateListDrawable stateListDrawable3 = stateListDrawable2;
        stateListDrawable3();
        stateListDrawable3.addState(BUTTON_STATE_PRESSED, (Drawable)new ColorDrawable(BUTTON_SECONDARY_PRESSED_COLOR));
        stateListDrawable3.addState(BUTTON_STATE_DISABLED, (Drawable)new ColorDrawable(BUTTON_SECONDARY_DISABLED_COLOR));
        object = BUTTON_STATE_FOCUSED;
        stateListDrawable2.addState((int[])object, Appearance.buttonBackgroundSecondaryFocused(context2));
        object = BUTTON_STATE_NORMAL;
        stateListDrawable.addState((int[])object, Appearance.buttonBackgroundSecondaryNormal(context));
        return stateListDrawable;
    }

    private static Drawable buttonBackgroundSecondaryNormal(Context context) {
        return Appearance.buttonNormal(BUTTON_SECONDARY_NORMAL_COLOR, Appearance.getFocusBorderWidthPixels(context));
    }

    private static Drawable buttonBackgroundSecondaryFocused(Context context) {
        int n = BUTTON_SECONDARY_FOCUS_COLOR;
        return Appearance.buttonFocused(BUTTON_SECONDARY_NORMAL_COLOR, n, Appearance.getFocusBorderWidthPixels(context));
    }

    private static Drawable buttonNormal(int n, float f2) {
        ShapeDrawable shapeDrawable;
        ColorDrawable colorDrawable;
        Drawable[] drawableArray = new Drawable[2];
        Drawable[] drawableArray2 = drawableArray;
        ColorDrawable colorDrawable2 = colorDrawable;
        colorDrawable = new ColorDrawable(n);
        drawableArray[0] = colorDrawable2;
        ShapeDrawable shapeDrawable2 = shapeDrawable;
        new ShapeDrawable((Shape)new RectShape()).getPaint().setStrokeWidth(f2 * 2.0f);
        shapeDrawable2.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable2.getPaint().setColor(DEFAULT_BACKGROUND_COLOR);
        drawableArray[1] = shapeDrawable2;
        return new LayerDrawable(drawableArray2);
    }

    private static Drawable buttonFocused(int n, int n2, float f2) {
        ShapeDrawable shapeDrawable;
        ShapeDrawable shapeDrawable2;
        ColorDrawable colorDrawable;
        Drawable[] drawableArray = new Drawable[3];
        Drawable[] drawableArray2 = drawableArray;
        ColorDrawable colorDrawable2 = colorDrawable;
        colorDrawable = new ColorDrawable(n);
        drawableArray[0] = colorDrawable2;
        ShapeDrawable shapeDrawable3 = shapeDrawable2;
        new ShapeDrawable((Shape)new RectShape()).getPaint().setStrokeWidth(f2 * 2.0f);
        shapeDrawable3.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable3.getPaint().setColor(DEFAULT_BACKGROUND_COLOR);
        drawableArray[1] = shapeDrawable3;
        shapeDrawable3 = shapeDrawable;
        new ShapeDrawable((Shape)new RectShape()).getPaint().setStrokeWidth(f2);
        shapeDrawable3.getPaint().setStyle(Paint.Style.STROKE);
        shapeDrawable3.getPaint().setColor(n2);
        drawableArray[2] = shapeDrawable3;
        return new LayerDrawable(drawableArray2);
    }

    private static Typeface typefaceLight() {
        return Typeface.create((String)"sans-serif-light", (int)0);
    }

    static {
        int n;
        BUTTON_STATE_PRESSED = new int[]{16842919, 16842910};
        BUTTON_STATE_NORMAL = new int[]{16842910};
        BUTTON_STATE_DISABLED = new int[]{-16842910};
        BUTTON_STATE_FOCUSED = new int[]{16842908};
        PAY_BLUE_COLOR = Color.parseColor((String)"#003087");
        PAL_BLUE_COLOR = n = Color.parseColor((String)"#009CDE");
        PAL_BLUE_COLOR_OPACITY_66 = Color.parseColor((String)"#aa009CDE");
        ACTIONBAR_BACKGROUND = new ColorDrawable(Color.parseColor((String)"#717074"));
        DEFAULT_BACKGROUND_COLOR = Color.parseColor((String)"#f5f5f5");
        BUTTON_PRIMARY_NORMAL_COLOR = n;
        BUTTON_PRIMARY_FOCUS_COLOR = PAL_BLUE_COLOR_OPACITY_66;
        BUTTON_PRIMARY_PRESSED_COLOR = PAY_BLUE_COLOR;
        BUTTON_PRIMARY_DISABLED_COLOR = Color.parseColor((String)"#c5ddeb");
        BUTTON_SECONDARY_NORMAL_COLOR = Color.parseColor((String)"#717074");
        BUTTON_SECONDARY_FOCUS_COLOR = Color.parseColor((String)"#aa717074");
        BUTTON_SECONDARY_PRESSED_COLOR = Color.parseColor((String)"#5a5a5d");
        BUTTON_SECONDARY_DISABLED_COLOR = Color.parseColor((String)"#f5f5f5");
        TEXT_COLOR_LIGHT = Color.parseColor((String)"#515151");
        TEXT_COLOR_ERROR = Color.parseColor((String)"#b32317");
        TEXT_COLOR_LABEL = TEXT_COLOR_LIGHT;
        TYPEFACE_BUTTON = Appearance.typefaceLight();
    }
}

