/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio.ui;

import android.content.Context;
import android.text.InputFilter;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import eu.nets.pia.PiaInterfaceConfiguration;
import eu.nets.pia.ui.themes.PiaTheme;

public class CustomToolbar
extends LinearLayout {
    private ToolbarCallback mToolbarNavigationListener;
    private LinearLayout mTextTitleContainer;
    private TextView mTitle;
    private RelativeLayout mRightViewContainer;
    private View mRightView;
    private RelativeLayout mLeftViewContainer;
    private View mLeftView;
    private int textColor;

    public CustomToolbar(Context context) {
        this(context, null);
    }

    public CustomToolbar(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public CustomToolbar(Context context, AttributeSet attributeSet, int n) {
        CustomToolbar customToolbar = this;
        super(context, attributeSet, n);
        customToolbar.customize(context);
    }

    private void customize(Context context) {
        CustomToolbar customToolbar = this;
        this.setOrientation(0);
        this.setBackgroundColor(PiaTheme.getUiTheme(context).getToolbarColor());
        customToolbar.textColor = PiaTheme.getUiTheme(context).getToolbarTitleColor();
        customToolbar.setupLeftViewContainer();
        customToolbar.setupTitleContainer();
        customToolbar.setupRightViewContainer();
    }

    private void setupTitleContainer() {
        LinearLayout.LayoutParams layoutParams;
        CustomToolbar customToolbar = this;
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        new LinearLayout.LayoutParams((int)0, (int)-1).weight = 4.0f;
        this.mTextTitleContainer = new LinearLayout(this.getContext());
        this.mTextTitleContainer.setOrientation(1);
        customToolbar.mTextTitleContainer.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        this.mTitle = new TextView(this.getContext());
        this.mTitle.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        customToolbar.mTitle.setGravity(17);
        customToolbar.mTitle.setTextSize(18.0f);
        customToolbar.mTitle.setTextColor(this.textColor);
        if (PiaInterfaceConfiguration.getInstance().getLabelFont() != null) {
            this.mTitle.setTypeface(PiaInterfaceConfiguration.getInstance().getLabelFont());
        }
        CustomToolbar customToolbar2 = this;
        customToolbar2.mTextTitleContainer.addView((View)this.mTitle);
        customToolbar2.setMaxLength(customToolbar2.mTitle, 30);
        customToolbar2.addView((View)customToolbar2.mTextTitleContainer);
    }

    private void setupRightViewContainer() {
        RelativeLayout relativeLayout;
        RelativeLayout relativeLayout2;
        LinearLayout.LayoutParams layoutParams;
        CustomToolbar customToolbar = this;
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        new LinearLayout.LayoutParams((int)0, (int)-1).weight = 1.0f;
        new LinearLayout.LayoutParams((int)0, (int)-1).rightMargin = 20;
        new LinearLayout.LayoutParams((int)0, (int)-1).gravity = 17;
        RelativeLayout relativeLayout3 = relativeLayout2 = relativeLayout;
        relativeLayout3(this.getContext());
        this.mRightViewContainer = relativeLayout3;
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        customToolbar.addView((View)customToolbar.mRightViewContainer);
    }

    private void setupLeftViewContainer() {
        RelativeLayout relativeLayout;
        RelativeLayout relativeLayout2;
        LinearLayout.LayoutParams layoutParams;
        CustomToolbar customToolbar = this;
        LinearLayout.LayoutParams layoutParams2 = layoutParams;
        new LinearLayout.LayoutParams((int)0, (int)-1).weight = 1.0f;
        new LinearLayout.LayoutParams((int)0, (int)-1).leftMargin = 20;
        new LinearLayout.LayoutParams((int)0, (int)-1).gravity = 17;
        RelativeLayout relativeLayout3 = relativeLayout2 = relativeLayout;
        relativeLayout3(this.getContext());
        this.mLeftViewContainer = relativeLayout3;
        relativeLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        customToolbar.addView((View)customToolbar.mLeftViewContainer);
    }

    private void setMaxLength(TextView textView, int n) {
        InputFilter.LengthFilter lengthFilter;
        TextView textView2 = textView;
        InputFilter[] inputFilterArray = new InputFilter[1];
        InputFilter[] inputFilterArray2 = inputFilterArray;
        textView = lengthFilter;
        lengthFilter = new InputFilter.LengthFilter(n);
        inputFilterArray[0] = textView;
        textView2.setFilters(inputFilterArray2);
    }

    public void addCallback(ToolbarCallback toolbarCallback) {
        this.mToolbarNavigationListener = toolbarCallback;
    }

    public void setTitle(int n) {
        CustomToolbar customToolbar = this;
        customToolbar.mTextTitleContainer.setVisibility(0);
        customToolbar.mTitle.setText(n);
    }

    public void setTitle(CharSequence charSequence) {
        CustomToolbar customToolbar = this;
        customToolbar.mTextTitleContainer.setVisibility(0);
        customToolbar.mTitle.setText(charSequence);
    }

    public void setTitleTextColor(int n) {
        this.mTitle.setTextColor(n);
    }

    public void setupRightView(View view) {
        RelativeLayout.LayoutParams layoutParams;
        CustomToolbar customToolbar = this;
        this.mRightView = view;
        view = view.getLayoutParams();
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        View view2 = view;
        int n = view2.width;
        new RelativeLayout.LayoutParams(n, view2.height).addRule(15, -1);
        layoutParams2.addRule(11, -1);
        customToolbar.mRightView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        customToolbar.mRightViewContainer.removeAllViews();
        customToolbar.mRightViewContainer.addView(this.mRightView);
    }

    public void removeRightView() {
        this.mRightViewContainer.removeAllViews();
    }

    public void setLeftView(View view) {
        RelativeLayout.LayoutParams layoutParams;
        CustomToolbar customToolbar = this;
        View view2 = this.mLeftView = view;
        RelativeLayout.LayoutParams layoutParams2 = layoutParams;
        new RelativeLayout.LayoutParams(-2, -2).addRule(15, -1);
        layoutParams2.addRule(9, -1);
        layoutParams2.height = 100;
        layoutParams2.width = 100;
        this.mLeftView.setLayoutParams((ViewGroup.LayoutParams)layoutParams2);
        view2.setPadding(10, 10, 10, 10);
        view2.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (CustomToolbar.this.mToolbarNavigationListener != null) {
                    CustomToolbar.this.mToolbarNavigationListener.onLeftAction();
                }
            }
        });
        customToolbar.mLeftViewContainer.removeAllViews();
        customToolbar.mLeftViewContainer.addView(view);
    }

    public void removeLeftView() {
        this.mLeftViewContainer.removeAllViews();
    }

    public static interface ToolbarCallback {
        public void onLeftAction();
    }
}

