/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.cardio.ui;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import eu.nets.pia.cardio.ui.Appearance;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ViewUtil {
    private static final Map<String, Integer> DIMENSION_STRING_CONSTANT = ViewUtil.initDimensionStringConstantMap();
    static Pattern DIMENSION_VALUE_PATTERN = Pattern.compile("^\\s*(\\d+(\\.\\d+)*)\\s*([a-zA-Z]+)\\s*$");
    static HashMap<String, Float> pxDimensionLookupTable = new HashMap();

    public static void setBackground(View view, Drawable drawable2) {
        if (Build.VERSION.SDK_INT >= 16) {
            view.setBackground(drawable2);
        } else {
            view.setBackgroundDrawable(drawable2);
        }
    }

    public static Map<String, Integer> initDimensionStringConstantMap() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        hashMap.put("px", 0);
        hashMap.put("dip", 1);
        hashMap.put("dp", 1);
        hashMap.put("sp", 2);
        hashMap.put("pt", 3);
        hashMap.put("in", 4);
        hashMap.put("mm", 5);
        return Collections.unmodifiableMap(hashMap);
    }

    public static int typedDimensionValueToPixelsInt(String string2, Context context) {
        if (string2 == null) {
            return 0;
        }
        return (int)ViewUtil.typedDimensionValueToPixels(string2, context);
    }

    public static float typedDimensionValueToPixels(String string2, Context context) {
        if (string2 == null) {
            return 0.0f;
        }
        if (pxDimensionLookupTable.containsKey(string2 = string2.toLowerCase())) {
            return pxDimensionLookupTable.get(string2).floatValue();
        }
        Matcher matcher = DIMENSION_VALUE_PATTERN.matcher(string2);
        if (matcher.matches()) {
            Matcher matcher2 = matcher;
            float f2 = Float.parseFloat(matcher2.group(1));
            Integer n = DIMENSION_STRING_CONSTANT.get(matcher2.group(3).toLowerCase());
            if (n == null) {
                n = 1;
            }
            float f3 = TypedValue.applyDimension((int)n, (float)f2, (DisplayMetrics)context.getResources().getDisplayMetrics());
            pxDimensionLookupTable.put(string2, Float.valueOf(f3));
            return f3;
        }
        throw new NumberFormatException();
    }

    public static void setPadding(View view, String string2, String string3, String string4, String string5) {
        View view2 = view;
        view = view.getContext();
        int n = ViewUtil.typedDimensionValueToPixelsInt(string2, (Context)view);
        int n2 = ViewUtil.typedDimensionValueToPixelsInt(string3, (Context)view);
        int n3 = ViewUtil.typedDimensionValueToPixelsInt(string4, (Context)view);
        int n4 = ViewUtil.typedDimensionValueToPixelsInt(string5, (Context)view);
        view2.setPadding(n, n2, n3, n4);
    }

    public static void setMargins(View view, String string2, String string3, String string4, String string5) {
        View view2 = view;
        view = view2.getContext();
        ViewGroup.LayoutParams layoutParams = view2.getLayoutParams();
        if (layoutParams instanceof ViewGroup.MarginLayoutParams) {
            int n = ViewUtil.typedDimensionValueToPixelsInt(string2, (Context)view);
            int n2 = ViewUtil.typedDimensionValueToPixelsInt(string3, (Context)view);
            int n3 = ViewUtil.typedDimensionValueToPixelsInt(string4, (Context)view);
            int n4 = ViewUtil.typedDimensionValueToPixelsInt(string5, (Context)view);
            ((ViewGroup.MarginLayoutParams)layoutParams).setMargins(n, n2, n3, n4);
        }
    }

    public static void setDimensions(View view, int n, int n2) {
        ViewGroup.LayoutParams layoutParams = view.getLayoutParams();
        layoutParams.width = n;
        layoutParams.height = n2;
    }

    public static void styleAsButton(Button button, boolean bl, Context context, boolean bl2) {
        Button button2 = button;
        ViewUtil.setDimensions((View)button2, -1, -2);
        button2.setFocusable(true);
        ViewUtil.setPadding((View)button2, "10dip", "0dip", "10dip", "0dip");
        if (!bl2) {
            Drawable drawable2 = bl ? Appearance.buttonBackgroundPrimary(context) : Appearance.buttonBackgroundSecondary(context);
            Button button3 = button;
            ViewUtil.setBackground((View)button3, drawable2);
            button3.setGravity(17);
            button3.setMinimumHeight(ViewUtil.typedDimensionValueToPixelsInt("54dip", context));
            button3.setTextColor(-1);
            button3.setTextSize(20.0f);
            button3.setTypeface(Appearance.TYPEFACE_BUTTON);
        }
    }
}

