/*
 * Decompiled with CFR 0.152.
 */
package eu.nets.pia.wallets;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.ResultReceiver;
import eu.nets.pia.ExtensionsKt;
import eu.nets.pia.PiaSDK;
import eu.nets.pia.wallets.AppSwitchActivityKt;
import eu.nets.pia.wallets.HostApp;
import eu.nets.pia.wallets.MobileWallet;
import eu.nets.pia.wallets.MobileWalletError;
import eu.nets.pia.wallets.MobileWalletFailure;
import eu.nets.pia.wallets.MobileWalletInterruption;
import eu.nets.pia.wallets.MobileWalletListener;
import eu.nets.pia.wallets.MobileWalletSuccess;
import eu.nets.pia.wallets.PiASDK;
import eu.nets.pia.wallets.RedirectResult;
import eu.nets.pia.wallets.WalletAppLifecycle;
import eu.nets.pia.wallets.WalletIntentData;
import java.lang.ref.WeakReference;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\b \u0018\u0000 \"2\u00020\u0001:\u0001\"B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\nH\u0016J\b\u0010\u000e\u001a\u00020\nH\u0002J\u0012\u0010\u000f\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u001d\u0010\u0012\u001a\u00020\n\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u0013\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u0017\u001a\u00020\n2\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J\u001f\u0010\u001a\u001a\u00020\n\"\b\b\u0000\u0010\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u0002H\u0013H\u0002\u00a2\u0006\u0002\u0010\u0016J\u0012\u0010\u001b\u001a\u00020\n2\b\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0014J\u0012\u0010\u001e\u001a\u00020\n2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0014J\b\u0010\u001f\u001a\u00020\nH\u0014J\u0010\u0010 \u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u0019H&J\b\u0010!\u001a\u00020\nH&R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0005\u001a\u00020\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006#"}, d2={"Leu/nets/pia/wallets/AppSwitchActivity;", "Landroid/app/Activity;", "()V", "isWaitingForRedirect", "", "mobileWallet", "Leu/nets/pia/wallets/MobileWallet;", "getMobileWallet", "()Leu/nets/pia/wallets/MobileWallet;", "didFailToLaunchWalletApp", "", "error", "Leu/nets/pia/wallets/MobileWalletError;", "didInterruptRedirect", "didOpenFromRedirect", "didReceiveIntent", "intent", "Landroid/content/Intent;", "dismissWithResult", "Result", "Leu/nets/pia/wallets/RedirectResult;", "result", "(Leu/nets/pia/wallets/RedirectResult;)V", "launchApp", "wallet", "Leu/nets/pia/wallets/WalletIntentData;", "launchHostActivityWith", "onCreate", "savedInstanceState", "Landroid/os/Bundle;", "onNewIntent", "onResume", "openApp", "setAppswitchActivityContentView", "Companion", "pia_release"})
public abstract class AppSwitchActivity
extends Activity {
    public static final Companion Companion = new Companion(null);
    private static WeakReference<AppSwitchActivity> instance;
    private boolean isWaitingForRedirect;

    private final void didOpenFromRedirect() {
        this.dismissWithResult(MobileWalletSuccess.INSTANCE);
    }

    private final void didReceiveIntent(Intent intent) {
        if (PiASDK.INSTANCE.isTransactionInProgress()) {
            this.finish();
            return;
        }
        if ((intent != null ? AppSwitchActivityKt.resultReceiver(intent) : null) == null) {
            this.didOpenFromRedirect();
        } else {
            HostApp.INSTANCE.setResultReceiver(AppSwitchActivityKt.resultReceiver(intent));
            this.launchApp(AppSwitchActivityKt.walletData(intent));
        }
    }

    private final <Result extends RedirectResult> void launchHostActivityWith(Result Result2) {
        Object object = HostApp.INSTANCE;
        String string2 = ((HostApp)object).redirectReceiverActivityName(this.getMobileWallet(), (Context)this);
        if (string2 != null) {
            HostApp hostApp = object;
            object = Class.forName(string2);
            Intent intent = new Intent((Context)this, (Class)object);
            intent.setFlags(0x10000000);
            AppSwitchActivityKt.setRedirectResultLaunchedBy(intent, this.getMobileWallet(), Result2);
            this.startActivity(intent);
            if (hostApp.getShowsSDKProgressIndicator()) {
                PiaSDK.addProgressIndicator(this);
            }
        }
    }

    public abstract MobileWallet getMobileWallet();

    public void didInterruptRedirect() {
        this.dismissWithResult(MobileWalletInterruption.INSTANCE);
    }

    public final void didFailToLaunchWalletApp(MobileWalletError mobileWalletError) {
        MobileWalletFailure mobileWalletFailure;
        AppSwitchActivity appSwitchActivity = object;
        Intrinsics.checkNotNullParameter((Object)((Object)mobileWalletError), (String)"error");
        Object object = mobileWalletFailure;
        mobileWalletFailure = new MobileWalletFailure(mobileWalletError);
        appSwitchActivity.dismissWithResult(object);
    }

    public void onCreate(Bundle bundle) {
        AppSwitchActivity appSwitchActivity = this;
        super.onCreate(bundle);
        instance = new WeakReference<AppSwitchActivity>(this);
        appSwitchActivity.setAppswitchActivityContentView();
        appSwitchActivity.didReceiveIntent(appSwitchActivity.getIntent());
        if (HostApp.INSTANCE.getShowsSDKProgressIndicator()) {
            PiaSDK.addProgressIndicator(this);
        }
        Intent intent = this.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent, (String)"intent");
        boolean bl = AppSwitchActivityKt.walletAppLifecycle(intent) != null;
        AppSwitchActivity appSwitchActivity2 = this;
        ExtensionsKt.assertDebug((Object)appSwitchActivity2, bl, "WalletAppLifecycle must be set");
        Intent intent2 = appSwitchActivity2.getIntent();
        Intrinsics.checkNotNullExpressionValue((Object)intent2, (String)"intent");
        WalletAppLifecycle walletAppLifecycle = AppSwitchActivityKt.walletAppLifecycle(intent2);
        if (walletAppLifecycle != null) {
            walletAppLifecycle.launchFrom(this);
        }
    }

    public abstract void setAppswitchActivityContentView();

    public void onNewIntent(Intent intent) {
        AppSwitchActivity appSwitchActivity = this;
        super.onNewIntent(intent);
        appSwitchActivity.didReceiveIntent(intent);
    }

    public void onResume() {
        AppSwitchActivity appSwitchActivity = this;
        super.onResume();
        if (appSwitchActivity.isWaitingForRedirect) {
            this.didInterruptRedirect();
        }
    }

    public abstract void openApp(WalletIntentData var1);

    public void launchApp(WalletIntentData walletIntentData) {
        if (walletIntentData == null) {
            return;
        }
        if (AppSwitchActivityKt.canOpenAppForScheme((Context)this, String.valueOf(walletIntentData.getWalletURL().getScheme()))) {
            this.openApp(walletIntentData);
            this.isWaitingForRedirect = true;
        } else {
            MobileWalletError mobileWalletError = MobileWalletError.WALLET_APP_NOT_FOUND;
            mobileWalletError.setDescription("The wallet app for scheme: " + walletIntentData.getWalletURL().getScheme() + " is not found in the device");
            this.didFailToLaunchWalletApp(mobileWalletError);
        }
    }

    public final <Result extends RedirectResult> void dismissWithResult(Result Result2) {
        Intrinsics.checkNotNullParameter(Result2, (String)"result");
        this.isWaitingForRedirect = false;
        HostApp hostApp = HostApp.INSTANCE;
        ResultReceiver resultReceiver = hostApp.getResultReceiver();
        Bundle bundle = hostApp.getAppSwitchListener();
        if ((bundle != null ? (MobileWalletListener)bundle.get() : null) != null) {
            Bundle bundle2;
            bundle = bundle2;
            AppSwitchActivityKt.setRedirectResult(new Bundle(), Result2);
            if (resultReceiver != null) {
                resultReceiver.send(1004, bundle);
            }
        } else {
            this.launchHostActivityWith(Result2);
        }
        this.finish();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Leu/nets/pia/wallets/AppSwitchActivity$Companion;", "", "()V", "instance", "Ljava/lang/ref/WeakReference;", "Leu/nets/pia/wallets/AppSwitchActivity;", "getInstance", "()Ljava/lang/ref/WeakReference;", "setInstance", "(Ljava/lang/ref/WeakReference;)V", "pia_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker defaultConstructorMarker) {
            this();
        }

        public final WeakReference<AppSwitchActivity> getInstance() {
            return instance;
        }

        public final void setInstance(WeakReference<AppSwitchActivity> weakReference) {
            instance = weakReference;
        }
    }
}

