/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j;

import eu.neverblink.jelly.core.NamespaceDeclaration;
import eu.neverblink.jelly.core.utils.DatasetAdapter;
import eu.neverblink.jelly.core.utils.GraphAdapter;
import eu.neverblink.jelly.core.utils.GraphHolder;
import eu.neverblink.jelly.core.utils.IteratorUtils;
import java.util.Set;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;

public final class Rdf4jAdapters {
    public static final GraphAdapter<Statement, Model> GRAPH_ADAPTER = new GraphAdapter<Statement, Model>(){

        public Iterable<Statement> triples(Model model) {
            return () -> model.iterator();
        }

        public Iterable<NamespaceDeclaration> namespaces(Model model) {
            return () -> {
                Set set = model.getNamespaces();
                return IteratorUtils.map(set.iterator(), namespace -> new NamespaceDeclaration(namespace.getPrefix(), namespace.getName()));
            };
        }
    };
    public static final DatasetAdapter<Value, Statement, Statement, Model> DATASET_ADAPTER = new DatasetAdapter<Value, Statement, Statement, Model>(){

        public Iterable<Statement> quads(Model model) {
            return () -> model.iterator();
        }

        public Iterable<GraphHolder<Value, Statement>> graphs(Model model) {
            return () -> {
                Set set = model.contexts();
                return IteratorUtils.map(set.iterator(), resource -> {
                    Iterable iterable = model.getStatements(null, null, null, new Resource[]{resource});
                    return new GraphHolder(resource, iterable);
                });
            };
        }

        public Iterable<NamespaceDeclaration> namespaces(Model model) {
            return GRAPH_ADAPTER.namespaces((Object)model);
        }
    };

    private Rdf4jAdapters() {
    }
}

