/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j;

import eu.neverblink.jelly.convert.rdf4j.Rdf4jDatatype;
import eu.neverblink.jelly.core.ProtoDecoderConverter;
import eu.neverblink.jelly.core.RdfProtoDeserializationError;
import eu.neverblink.jelly.core.utils.QuadMaker;
import eu.neverblink.jelly.core.utils.TripleMaker;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.base.CoreDatatype;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;

public final class Rdf4jDecoderConverter
implements ProtoDecoderConverter<Value, Rdf4jDatatype>,
TripleMaker<Value, Statement>,
QuadMaker<Value, Statement> {
    private final ValueFactory vf;

    public Rdf4jDecoderConverter() {
        this.vf = SimpleValueFactory.getInstance();
    }

    public Rdf4jDecoderConverter(ValueFactory valueFactory) {
        this.vf = valueFactory;
    }

    public Value makeSimpleLiteral(String string) {
        return this.vf.createLiteral(string);
    }

    public Value makeLangLiteral(String string, String string2) {
        return this.vf.createLiteral(string, string2);
    }

    public Value makeDtLiteral(String string, Rdf4jDatatype rdf4jDatatype) {
        return this.vf.createLiteral(string, rdf4jDatatype.dt(), rdf4jDatatype.coreDatatype());
    }

    public Rdf4jDatatype makeDatatype(String string) {
        IRI iRI = this.vf.createIRI(string);
        return new Rdf4jDatatype(iRI, CoreDatatype.from((IRI)iRI));
    }

    public Value makeBlankNode(String string) {
        return this.vf.createBNode(string);
    }

    public Value makeIriNode(String string) {
        return this.vf.createIRI(string);
    }

    public Value makeTripleNode(Value value, Value value2, Value value3) {
        try {
            return this.vf.createTriple((Resource)value, (IRI)value2, value3);
        }
        catch (ClassCastException classCastException) {
            throw new RdfProtoDeserializationError("Cannot create generalized triple node with %s, %s, %s".formatted(value, value2, value3), (Throwable)classCastException);
        }
    }

    public Value makeDefaultGraphNode() {
        return null;
    }

    public Statement makeQuad(Value value, Value value2, Value value3, Value value4) {
        try {
            return this.vf.createStatement((Resource)value, (IRI)value2, value3, (Resource)value4);
        }
        catch (ClassCastException classCastException) {
            throw new RdfProtoDeserializationError("Cannot create generalized quad with %s, %s, %s, %s".formatted(value, value2, value3, value4), (Throwable)classCastException);
        }
    }

    public Statement makeTriple(Value value, Value value2, Value value3) {
        try {
            return this.vf.createStatement((Resource)value, (IRI)value2, value3);
        }
        catch (ClassCastException classCastException) {
            throw new RdfProtoDeserializationError("Cannot create generalized triple with %s, %s, %s".formatted(value, value2, value3), (Throwable)classCastException);
        }
    }
}

