/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j;

import eu.neverblink.jelly.core.NodeEncoder;
import eu.neverblink.jelly.core.ProtoEncoderConverter;
import eu.neverblink.jelly.core.RdfProtoSerializationError;
import eu.neverblink.jelly.core.utils.QuadExtractor;
import eu.neverblink.jelly.core.utils.TripleExtractor;
import java.util.Optional;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.vocabulary.XSD;

public class Rdf4jEncoderConverter
implements ProtoEncoderConverter<Value>,
TripleExtractor<Value, Statement>,
QuadExtractor<Value, Statement> {
    public Object nodeToProto(NodeEncoder<Value> nodeEncoder, Value value) {
        if (value instanceof IRI) {
            IRI iRI = (IRI)value;
            return nodeEncoder.makeIri(iRI.stringValue());
        }
        if (value instanceof BNode) {
            BNode bNode = (BNode)value;
            return nodeEncoder.makeBlankNode(bNode.getID());
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String string = literal.getLabel();
            Optional optional = literal.getLanguage();
            if (optional.isPresent()) {
                return nodeEncoder.makeLangLiteral((Object)literal, string, (String)optional.get());
            }
            IRI iRI = literal.getDatatype();
            if (!iRI.equals((Object)XSD.STRING)) {
                return nodeEncoder.makeDtLiteral((Object)literal, string, iRI.stringValue());
            }
            return nodeEncoder.makeSimpleLiteral(string);
        }
        if (value instanceof Triple) {
            Triple triple = (Triple)value;
            return nodeEncoder.makeQuotedTriple((Object)triple.getSubject(), (Object)triple.getPredicate(), (Object)triple.getObject());
        }
        throw new RdfProtoSerializationError("Cannot encode node: %s".formatted(value));
    }

    public Object graphNodeToProto(NodeEncoder<Value> nodeEncoder, Value value) {
        if (value instanceof IRI) {
            IRI iRI = (IRI)value;
            return nodeEncoder.makeIri(iRI.stringValue());
        }
        if (value instanceof BNode) {
            BNode bNode = (BNode)value;
            return nodeEncoder.makeBlankNode(bNode.getID());
        }
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String string = literal.getLabel();
            Optional optional = literal.getLanguage();
            if (optional.isPresent()) {
                return nodeEncoder.makeLangLiteral((Object)literal, string, (String)optional.get());
            }
            IRI iRI = literal.getDatatype();
            if (!iRI.equals((Object)XSD.STRING)) {
                return nodeEncoder.makeDtLiteral((Object)literal, string, iRI.stringValue());
            }
            return nodeEncoder.makeSimpleLiteral(string);
        }
        if (value == null) {
            return nodeEncoder.makeDefaultGraph();
        }
        throw new RdfProtoSerializationError("Cannot encode graph node: %s".formatted(value));
    }

    public Value getQuadSubject(Statement statement) {
        return statement.getSubject();
    }

    public Value getQuadPredicate(Statement statement) {
        return statement.getPredicate();
    }

    public Value getQuadObject(Statement statement) {
        return statement.getObject();
    }

    public Value getQuadGraph(Statement statement) {
        return statement.getContext();
    }

    public Value getTripleSubject(Statement statement) {
        return statement.getSubject();
    }

    public Value getTriplePredicate(Statement statement) {
        return statement.getPredicate();
    }

    public Value getTripleObject(Statement statement) {
        return statement.getObject();
    }
}

