/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j.rio;

import eu.neverblink.jelly.convert.rdf4j.Rdf4jConverterFactory;
import eu.neverblink.jelly.convert.rdf4j.rio.JellyFormat;
import eu.neverblink.jelly.convert.rdf4j.rio.JellyParserSettings;
import eu.neverblink.jelly.core.ProtoDecoder;
import eu.neverblink.jelly.core.RdfHandler;
import eu.neverblink.jelly.core.memory.RowBuffer;
import eu.neverblink.jelly.core.proto.v1.RdfStreamFrame;
import eu.neverblink.jelly.core.proto.v1.RdfStreamOptions;
import eu.neverblink.jelly.core.utils.IoUtils;
import eu.neverblink.protoc.java.runtime.MessageCollection;
import eu.neverblink.protoc.java.runtime.MessageFactory;
import eu.neverblink.protoc.java.runtime.ProtoMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Collection;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFParser;

public final class JellyParser
extends AbstractRDFParser {
    private Rdf4jConverterFactory converterFactory;

    public JellyParser(Rdf4jConverterFactory rdf4jConverterFactory) {
        this.converterFactory = rdf4jConverterFactory;
    }

    public RDFFormat getRDFFormat() {
        return JellyFormat.JELLY;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        Collection collection = super.getSupportedSettings();
        collection.add(JellyParserSettings.PROTO_VERSION);
        collection.add(JellyParserSettings.ALLOW_GENERALIZED_STATEMENTS);
        collection.add(JellyParserSettings.ALLOW_RDF_STAR);
        collection.add(JellyParserSettings.MAX_NAME_TABLE_SIZE);
        collection.add(JellyParserSettings.MAX_PREFIX_TABLE_SIZE);
        collection.add(JellyParserSettings.MAX_DATATYPE_TABLE_SIZE);
        return collection;
    }

    public JellyParser setValueFactory(ValueFactory valueFactory) {
        super.setValueFactory(valueFactory);
        this.converterFactory = Rdf4jConverterFactory.getInstance(valueFactory);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(InputStream inputStream, String string) throws IOException, RDFParseException, RDFHandlerException {
        if (inputStream == null) {
            throw new IllegalArgumentException("Input stream must not be null");
        }
        ParserConfig parserConfig = this.getParserConfig();
        RdfStreamOptions.Mutable mutable = RdfStreamOptions.newInstance().setGeneralizedStatements(((Boolean)parserConfig.get((RioSetting)JellyParserSettings.ALLOW_GENERALIZED_STATEMENTS)).booleanValue()).setRdfStar(((Boolean)parserConfig.get((RioSetting)JellyParserSettings.ALLOW_RDF_STAR)).booleanValue()).setMaxNameTableSize(((Integer)parserConfig.get((RioSetting)JellyParserSettings.MAX_NAME_TABLE_SIZE)).intValue()).setMaxPrefixTableSize(((Integer)parserConfig.get((RioSetting)JellyParserSettings.MAX_PREFIX_TABLE_SIZE)).intValue()).setMaxDatatypeTableSize(((Integer)parserConfig.get((RioSetting)JellyParserSettings.MAX_DATATYPE_TABLE_SIZE)).intValue()).setVersion(((Integer)parserConfig.get((RioSetting)JellyParserSettings.PROTO_VERSION)).intValue());
        RdfHandler.AnyStatementHandler<Value> anyStatementHandler = new RdfHandler.AnyStatementHandler<Value>(){

            public void handleNamespace(String string, Value value) {
                JellyParser.this.rdfHandler.handleNamespace(string, value.stringValue());
            }

            public void handleQuad(Value value, Value value2, Value value3, Value value4) {
                JellyParser.this.rdfHandler.handleStatement(JellyParser.this.converterFactory.decoderConverter().makeQuad(value, value2, value3, value4));
            }

            public void handleTriple(Value value, Value value2, Value value3) {
                JellyParser.this.rdfHandler.handleStatement(JellyParser.this.converterFactory.decoderConverter().makeTriple(value, value2, value3));
            }
        };
        ProtoDecoder protoDecoder = this.converterFactory.anyStatementDecoder((RdfHandler.AnyStatementHandler)anyStatementHandler, (RdfStreamOptions)mutable);
        RowBuffer rowBuffer = RowBuffer.newSingle(arg_0 -> ((ProtoDecoder)protoDecoder).ingestRow(arg_0));
        RdfStreamFrame.Mutable mutable2 = RdfStreamFrame.newInstance().setRows((MessageCollection)rowBuffer);
        MessageFactory messageFactory = () -> mutable2;
        this.rdfHandler.startRDF();
        try {
            IoUtils.AutodetectDelimitingResponse autodetectDelimitingResponse = IoUtils.autodetectDelimiting((InputStream)inputStream);
            if (autodetectDelimitingResponse.isDelimited()) {
                IoUtils.readStream((InputStream)autodetectDelimitingResponse.newInput(), (MessageFactory)messageFactory, rdfStreamFrame -> rowBuffer.clear());
            } else {
                ProtoMessage.parseFrom((InputStream)autodetectDelimitingResponse.newInput(), (MessageFactory)messageFactory);
                rowBuffer.clear();
            }
        }
        finally {
            this.rdfHandler.endRDF();
        }
    }

    public void parse(Reader reader, String string) throws IOException, RDFParseException, RDFHandlerException {
        throw new UnsupportedOperationException("Parsing from Reader is not supported.");
    }
}

