/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j.rio;

import eu.neverblink.jelly.core.JellyOptions;
import eu.neverblink.jelly.core.proto.v1.RdfStreamOptions;
import org.eclipse.rdf4j.rio.ParserConfig;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;
import org.eclipse.rdf4j.rio.helpers.IntegerRioSetting;

public final class JellyParserSettings {
    public static final IntegerRioSetting PROTO_VERSION = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.protoVersion", "Maximum supported Jelly protocol version", Integer.valueOf(JellyOptions.DEFAULT_SUPPORTED_OPTIONS.getVersion()));
    public static final BooleanRioSetting ALLOW_GENERALIZED_STATEMENTS = new BooleanRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.allowGeneralizedStatements", "Allow decoding generalized statements", Boolean.valueOf(JellyOptions.DEFAULT_SUPPORTED_OPTIONS.getGeneralizedStatements()));
    public static final BooleanRioSetting ALLOW_RDF_STAR = new BooleanRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.allowRdfStar", "Allow decoding RDF-star statements", Boolean.valueOf(JellyOptions.DEFAULT_SUPPORTED_OPTIONS.getRdfStar()));
    public static final IntegerRioSetting MAX_NAME_TABLE_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.maxNameTableSize", "Maximum size of the name table", Integer.valueOf(JellyOptions.DEFAULT_SUPPORTED_OPTIONS.getMaxNameTableSize()));
    public static final IntegerRioSetting MAX_PREFIX_TABLE_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.maxPrefixTableSize", "Maximum size of the prefix table", Integer.valueOf(JellyOptions.DEFAULT_SUPPORTED_OPTIONS.getMaxPrefixTableSize()));
    public static final IntegerRioSetting MAX_DATATYPE_TABLE_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.maxDatatypeTableSize", "Maximum size of the datatype table", Integer.valueOf(JellyOptions.DEFAULT_SUPPORTED_OPTIONS.getMaxDatatypeTableSize()));

    private JellyParserSettings() {
    }

    public static ParserConfig from(RdfStreamOptions rdfStreamOptions) {
        ParserConfig parserConfig = new ParserConfig();
        parserConfig.set((RioSetting)PROTO_VERSION, (Object)rdfStreamOptions.getVersion());
        parserConfig.set((RioSetting)ALLOW_GENERALIZED_STATEMENTS, (Object)rdfStreamOptions.getGeneralizedStatements());
        parserConfig.set((RioSetting)ALLOW_RDF_STAR, (Object)rdfStreamOptions.getRdfStar());
        parserConfig.set((RioSetting)MAX_NAME_TABLE_SIZE, (Object)rdfStreamOptions.getMaxNameTableSize());
        parserConfig.set((RioSetting)MAX_PREFIX_TABLE_SIZE, (Object)rdfStreamOptions.getMaxPrefixTableSize());
        parserConfig.set((RioSetting)MAX_DATATYPE_TABLE_SIZE, (Object)rdfStreamOptions.getMaxDatatypeTableSize());
        return parserConfig;
    }
}

