/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j.rio;

import com.google.protobuf.CodedOutputStream;
import eu.neverblink.jelly.convert.rdf4j.Rdf4jConverterFactory;
import eu.neverblink.jelly.convert.rdf4j.rio.JellyFormat;
import eu.neverblink.jelly.convert.rdf4j.rio.JellyWriterSettings;
import eu.neverblink.jelly.core.ProtoEncoder;
import eu.neverblink.jelly.core.memory.EncoderAllocator;
import eu.neverblink.jelly.core.memory.ReusableRowBuffer;
import eu.neverblink.jelly.core.memory.RowBuffer;
import eu.neverblink.jelly.core.proto.v1.LogicalStreamType;
import eu.neverblink.jelly.core.proto.v1.PhysicalStreamType;
import eu.neverblink.jelly.core.proto.v1.RdfStreamFrame;
import eu.neverblink.jelly.core.proto.v1.RdfStreamOptions;
import eu.neverblink.protoc.java.runtime.MessageCollection;
import eu.neverblink.protoc.java.runtime.ProtobufUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;

public final class JellyWriter
extends AbstractRDFWriter {
    private final Rdf4jConverterFactory converterFactory;
    private final ValueFactory valueFactory;
    private final OutputStream outputStream;
    private final CodedOutputStream codedOutput;
    private ReusableRowBuffer buffer = null;
    private EncoderAllocator allocator = null;
    private final RdfStreamFrame.Mutable reusableFrame;
    private RdfStreamOptions options;
    private ProtoEncoder<Value> encoder;
    private int frameSize = 256;
    private boolean enableNamespaceDeclarations = true;
    private boolean isDelimited = false;

    public JellyWriter(Rdf4jConverterFactory rdf4jConverterFactory, ValueFactory valueFactory, OutputStream outputStream) {
        this.converterFactory = rdf4jConverterFactory;
        this.valueFactory = valueFactory;
        this.outputStream = outputStream;
        this.codedOutput = ProtobufUtil.createCodedOutputStream((OutputStream)outputStream);
        this.reusableFrame = RdfStreamFrame.newInstance();
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        Collection collection = super.getSupportedSettings();
        collection.add(JellyWriterSettings.STREAM_NAME);
        collection.add(JellyWriterSettings.PHYSICAL_TYPE);
        collection.add(JellyWriterSettings.ALLOW_RDF_STAR);
        collection.add(JellyWriterSettings.MAX_NAME_TABLE_SIZE);
        collection.add(JellyWriterSettings.MAX_PREFIX_TABLE_SIZE);
        collection.add(JellyWriterSettings.MAX_DATATYPE_TABLE_SIZE);
        collection.add(JellyWriterSettings.FRAME_SIZE);
        collection.add(JellyWriterSettings.ENABLE_NAMESPACE_DECLARATIONS);
        collection.add(JellyWriterSettings.DELIMITED_OUTPUT);
        return collection;
    }

    public RDFFormat getRDFFormat() {
        return JellyFormat.JELLY;
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        WriterConfig writerConfig = this.getWriterConfig();
        PhysicalStreamType physicalStreamType = (PhysicalStreamType)writerConfig.get(JellyWriterSettings.PHYSICAL_TYPE);
        if (physicalStreamType == null || physicalStreamType == PhysicalStreamType.UNSPECIFIED) {
            physicalStreamType = PhysicalStreamType.QUADS;
        }
        LogicalStreamType logicalStreamType = (LogicalStreamType)writerConfig.get(JellyWriterSettings.LOGICAL_TYPE);
        if (physicalStreamType == PhysicalStreamType.TRIPLES && logicalStreamType == LogicalStreamType.UNSPECIFIED) {
            logicalStreamType = LogicalStreamType.FLAT_TRIPLES;
        } else if (physicalStreamType == PhysicalStreamType.QUADS && logicalStreamType == LogicalStreamType.UNSPECIFIED) {
            logicalStreamType = LogicalStreamType.FLAT_QUADS;
        } else if (logicalStreamType == LogicalStreamType.UNSPECIFIED) {
            throw new IllegalStateException("Unsupported stream type: " + String.valueOf(physicalStreamType));
        }
        this.options = RdfStreamOptions.newInstance().setStreamName((String)writerConfig.get((RioSetting)JellyWriterSettings.STREAM_NAME)).setPhysicalType(physicalStreamType).setLogicalType(logicalStreamType).setGeneralizedStatements(false).setRdfStar(((Boolean)writerConfig.get((RioSetting)JellyWriterSettings.ALLOW_RDF_STAR)).booleanValue()).setMaxNameTableSize(((Integer)writerConfig.get((RioSetting)JellyWriterSettings.MAX_NAME_TABLE_SIZE)).intValue()).setMaxPrefixTableSize(((Integer)writerConfig.get((RioSetting)JellyWriterSettings.MAX_PREFIX_TABLE_SIZE)).intValue()).setMaxDatatypeTableSize(((Integer)writerConfig.get((RioSetting)JellyWriterSettings.MAX_DATATYPE_TABLE_SIZE)).intValue());
        this.frameSize = (Integer)writerConfig.get((RioSetting)JellyWriterSettings.FRAME_SIZE);
        this.enableNamespaceDeclarations = (Boolean)writerConfig.get((RioSetting)JellyWriterSettings.ENABLE_NAMESPACE_DECLARATIONS);
        this.isDelimited = (Boolean)writerConfig.get((RioSetting)JellyWriterSettings.DELIMITED_OUTPUT);
        this.buffer = RowBuffer.newReusableForEncoder((int)(this.frameSize + 8));
        this.allocator = EncoderAllocator.newArenaAllocator((int)(this.frameSize + 8));
        this.reusableFrame.setRows((MessageCollection)this.buffer);
        this.encoder = this.converterFactory.encoder(ProtoEncoder.Params.of((RdfStreamOptions)this.options, (boolean)this.enableNamespaceDeclarations, (RowBuffer)this.buffer, (EncoderAllocator)this.allocator));
    }

    protected void consumeStatement(Statement statement) {
        this.checkWritingStarted();
        if (this.options.getPhysicalType() == PhysicalStreamType.TRIPLES) {
            this.encoder.handleTriple((Object)statement.getSubject(), (Object)statement.getPredicate(), (Object)statement.getObject());
        } else {
            this.encoder.handleQuad((Object)statement.getSubject(), (Object)statement.getPredicate(), (Object)statement.getObject(), (Object)statement.getContext());
        }
        if (this.isDelimited && this.buffer.size() >= this.frameSize) {
            this.flushBuffer();
        }
    }

    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        if (!this.isDelimited) {
            try {
                this.reusableFrame.writeTo(this.codedOutput);
            }
            catch (Exception exception) {
                throw new RDFHandlerException("Error writing frame", (Throwable)exception);
            }
        } else if (!this.buffer.isEmpty()) {
            this.flushBuffer();
        }
        try {
            this.codedOutput.flush();
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            throw new RDFHandlerException("Error flushing output", (Throwable)iOException);
        }
    }

    public void handleComment(String string) throws RDFHandlerException {
        this.checkWritingStarted();
    }

    public void handleNamespace(String string, String string2) throws RDFHandlerException {
        this.checkWritingStarted();
        if (this.enableNamespaceDeclarations) {
            this.encoder.handleNamespace(string, (Object)this.valueFactory.createIRI(string2));
            if (this.isDelimited && this.buffer.size() >= this.frameSize) {
                this.flushBuffer();
            }
        }
    }

    private void flushBuffer() {
        this.reusableFrame.resetCachedSize();
        try {
            this.reusableFrame.writeDelimitedTo(this.codedOutput);
        }
        catch (Exception exception) {
            throw new RDFHandlerException("Error writing frame", (Throwable)exception);
        }
        finally {
            this.buffer.clear();
            this.allocator.releaseAll();
        }
    }
}

