/*
 * Decompiled with CFR 0.152.
 */
package eu.neverblink.jelly.convert.rdf4j.rio;

import eu.neverblink.jelly.core.proto.v1.LogicalStreamType;
import eu.neverblink.jelly.core.proto.v1.PhysicalStreamType;
import eu.neverblink.jelly.core.proto.v1.RdfStreamOptions;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.WriterConfig;
import org.eclipse.rdf4j.rio.helpers.BooleanRioSetting;
import org.eclipse.rdf4j.rio.helpers.ClassRioSetting;
import org.eclipse.rdf4j.rio.helpers.IntegerRioSetting;
import org.eclipse.rdf4j.rio.helpers.StringRioSetting;

public final class JellyWriterSettings
extends WriterConfig {
    public static final IntegerRioSetting FRAME_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.frameSize", "Target RDF stream frame size. Frame size may be slightly larger than this value, to fit the entire statement and its lookup entries in one frame.", Integer.valueOf(256));
    public static final BooleanRioSetting ENABLE_NAMESPACE_DECLARATIONS = new BooleanRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.enableNamespaceDeclarations", "Enable namespace declarations in the output (equivalent to PREFIX directives in Turtle syntax). This option is disabled by default and is not recommended when your only concern is performance. It is only useful when you want to preserve the namespace declarations in the output. Enabling this causes the stream to be written in protocol version 2 (Jelly 1.1.0) instead of 1.", Boolean.valueOf(false));
    public static final BooleanRioSetting DELIMITED_OUTPUT = new BooleanRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.delimitedOutput", "Write the output as delimited frames. Note: files saved to disk are recommended to be delimited, for better interoperability with other implementations. In a non-delimited file you can have ONLY ONE FRAME. If the input data is large, this will lead to an out-of-memory error. So, this makes sense only for small data. **Disable this only if you know what you are doing.**", Boolean.valueOf(true));
    public static final StringRioSetting STREAM_NAME = new StringRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.streamName", "Stream name", "");
    public static final ClassRioSetting<PhysicalStreamType> PHYSICAL_TYPE = new ClassRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.physicalType", "Physical stream type", (Object)PhysicalStreamType.QUADS);
    public static final ClassRioSetting<LogicalStreamType> LOGICAL_TYPE = new ClassRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.logicalType", "Logical stream type", (Object)LogicalStreamType.UNSPECIFIED);
    public static final BooleanRioSetting ALLOW_RDF_STAR = new BooleanRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.allowRdfStar", "Allow RDF-star statements. Enabled by default, because we cannot know this in advance. If your data does not contain RDF-star statements, it is recommended that you set this to false.", Boolean.valueOf(true));
    public static final IntegerRioSetting MAX_NAME_TABLE_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.maxNameTableSize", "Maximum size of the name table", Integer.valueOf(128));
    public static final IntegerRioSetting MAX_PREFIX_TABLE_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.maxPrefixTableSize", "Maximum size of the prefix table", Integer.valueOf(16));
    public static final IntegerRioSetting MAX_DATATYPE_TABLE_SIZE = new IntegerRioSetting("eu.neverblink.jelly.convert.rdf4j.rio.maxDatatypeTableSize", "Maximum size of the datatype table", Integer.valueOf(16));

    private JellyWriterSettings() {
    }

    public static JellyWriterSettings empty() {
        return new JellyWriterSettings();
    }

    public JellyWriterSettings setFrameSize(int n) {
        this.set((RioSetting)FRAME_SIZE, n);
        return this;
    }

    public JellyWriterSettings setEnableNamespaceDeclarations(boolean bl) {
        this.set((RioSetting)ENABLE_NAMESPACE_DECLARATIONS, bl);
        return this;
    }

    public JellyWriterSettings setDelimitedOutput(boolean bl) {
        this.set((RioSetting)DELIMITED_OUTPUT, bl);
        return this;
    }

    public JellyWriterSettings setJellyOptions(RdfStreamOptions rdfStreamOptions) {
        this.set((RioSetting)STREAM_NAME, rdfStreamOptions.getStreamName());
        this.set((RioSetting)PHYSICAL_TYPE, rdfStreamOptions.getPhysicalType());
        this.set((RioSetting)LOGICAL_TYPE, rdfStreamOptions.getLogicalType());
        this.set((RioSetting)ALLOW_RDF_STAR, rdfStreamOptions.getRdfStar());
        this.set((RioSetting)MAX_NAME_TABLE_SIZE, rdfStreamOptions.getMaxNameTableSize());
        this.set((RioSetting)MAX_PREFIX_TABLE_SIZE, rdfStreamOptions.getMaxPrefixTableSize());
        this.set((RioSetting)MAX_DATATYPE_TABLE_SIZE, rdfStreamOptions.getMaxDatatypeTableSize());
        return this;
    }
}

