/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.impl.TermMapImpl;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class ObjectMapImpl
extends TermMapImpl
implements ObjectMap {
    private List<IRI> validTermTypes = Arrays.asList(this.getRDF().createIRI("http://www.w3.org/ns/r2rml#IRI"), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#BlankNode"), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal"));
    private IRI dataType;
    private String langTag;

    ObjectMapImpl(RDF c, Template template) {
        super(c, template);
    }

    ObjectMapImpl(RDF c, String columnName) {
        super(c, columnName);
    }

    ObjectMapImpl(RDF c, RDFTerm constant) {
        super(c, constant);
    }

    @Override
    public void setTermType(IRI typeIRI) {
        super.setTermType(typeIRI);
        if (!typeIRI.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal"))) {
            this.removeLanguageTag();
            this.removeDatatype();
        }
    }

    @Override
    public List<IRI> getValidTermTypes() {
        return this.validTermTypes;
    }

    @Override
    public void setDefaultTermType() {
        this.termTypeIRI = this.termMapType == TermMap.TermMapType.COLUMN_VALUED || this.langTag != null || this.dataType != null ? this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal") : this.getRDF().createIRI("http://www.w3.org/ns/r2rml#IRI");
    }

    @Override
    public void setLanguageTag(String lang) {
        if (!this.termTypeIRI.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal"))) {
            throw new IllegalStateException("The term termMapType is " + this.termTypeIRI + ". Should be http://www.w3.org/ns/r2rml#Literal.");
        }
        this.removeDatatype();
        this.langTag = lang;
    }

    @Override
    public void setDatatype(IRI datatypeURI) {
        if (!this.termTypeIRI.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#Literal"))) {
            throw new IllegalStateException("The term termMapType is " + this.termTypeIRI + ". Should be http://www.w3.org/ns/r2rml#Literal.");
        }
        this.dataType = datatypeURI;
        this.removeLanguageTag();
    }

    @Override
    public String getLanguageTag() {
        return this.langTag;
    }

    @Override
    public IRI getDatatype() {
        return this.dataType;
    }

    @Override
    public void removeDatatype() {
        this.dataType = null;
    }

    @Override
    public void removeLanguageTag() {
        this.langTag = null;
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.addAll(super.serialize());
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#ObjectMap")));
        if (this.dataType != null) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#datatype"), (RDFTerm)this.dataType));
        }
        if (this.langTag != null) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#language"), (RDFTerm)this.getRDF().createLiteral(this.langTag)));
        }
        return stmtSet;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dataType == null ? 0 : this.dataType.hashCode());
        result = 31 * result + (this.langTag == null ? 0 : this.langTag.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof ObjectMapImpl)) {
            return false;
        }
        ObjectMapImpl other = (ObjectMapImpl)obj;
        if (this.dataType == null ? other.dataType != null : !this.dataType.equals((Object)other.dataType)) {
            return false;
        }
        return !(this.langTag == null ? other.langTag != null : !this.langTag.equals(other.langTag));
    }

    @Override
    public String toString() {
        return "ObjectMapImpl [langTag=" + this.langTag + ", dataType=" + this.dataType + ", termMapType=" + this.termMapType + ", termTypeIRI=" + this.termTypeIRI + ", template=" + this.template + ", constVal=" + this.constVal + ", columnName=" + this.columnName + ", inverseExp=" + this.inverseExp + ", node=" + this.getNode() + "]";
    }
}

