/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.MappingFactory;
import eu.optique.r2rml.api.R2RMLMappingManager;
import eu.optique.r2rml.api.model.GraphMap;
import eu.optique.r2rml.api.model.LogicalTable;
import eu.optique.r2rml.api.model.ObjectMap;
import eu.optique.r2rml.api.model.PredicateMap;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.R2RMLMappingCollection;
import eu.optique.r2rml.api.model.R2RMLView;
import eu.optique.r2rml.api.model.RefObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.InvalidR2RMLMappingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.Graph;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.Literal;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class R2RMLMappingCollectionImpl
implements R2RMLMappingCollection {
    private Map<BlankNodeOrIRI, TriplesMap> triplesMaps;
    private RDF rdf;
    private MappingFactory mfact;
    private Graph graph = null;

    public R2RMLMappingCollectionImpl(R2RMLMappingManager mm, RDF rdf, Graph graph) throws InvalidR2RMLMappingException {
        this.rdf = rdf;
        this.mfact = mm.getMappingFactory();
        this.load(graph);
    }

    @Override
    public void addTriplesMap(TriplesMap mapping) {
        this.triplesMaps.put(mapping.getNode(), mapping);
    }

    @Override
    public void addTriplesMaps(Collection<TriplesMap> mappings) {
        for (TriplesMap map : mappings) {
            this.addTriplesMap(map);
        }
    }

    @Override
    public void load(Graph graph) throws InvalidR2RMLMappingException {
        if (graph == null) {
            throw new NullPointerException("The RDF Graph supported for the mapping manager must not be null.");
        }
        this.graph = graph;
        this.triplesMaps = this.readTriplesMaps();
        for (BlankNodeOrIRI node : this.triplesMaps.keySet()) {
            this.triplesMaps.get(node).addPredicateObjectMaps(this.readPredicateObjectMaps(node));
        }
    }

    @Override
    public Collection<TriplesMap> getTriplesMaps() {
        return this.triplesMaps.values();
    }

    private Map<BlankNodeOrIRI, TriplesMap> readTriplesMaps() throws InvalidR2RMLMappingException {
        HashMap<BlankNodeOrIRI, TriplesMap> triples = new HashMap<BlankNodeOrIRI, TriplesMap>();
        Collection triplesMapNodes = this.graph.stream(null, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#logicalTable"), null).map(Triple::getSubject).collect(Collectors.toSet());
        for (BlankNodeOrIRI node : triplesMapNodes) {
            triples.put(node, this.readTriplesMap(node));
        }
        return triples;
    }

    private TriplesMap readTriplesMap(BlankNodeOrIRI node) throws InvalidR2RMLMappingException {
        LogicalTable logicalTable = this.readLogicalTable(node);
        SubjectMap subjectMap = this.readSubjectMap(node);
        TriplesMap triplesMap = this.mfact.createTriplesMap(logicalTable, subjectMap);
        triplesMap.setNode(node);
        return triplesMap;
    }

    private LogicalTable readLogicalTable(BlankNodeOrIRI node) throws InvalidR2RMLMappingException {
        RDFTerm query;
        LogicalTable toReturn = null;
        Collection<RDFTerm> logicalTableNode = this.readObjectsInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#logicalTable"));
        if (logicalTableNode.size() != 1) {
            if (logicalTableNode.isEmpty()) {
                throw new InvalidR2RMLMappingException("Invalid mapping: TriplesMap " + node + " without a LogicalTable node");
            }
            throw new InvalidR2RMLMappingException("Invalid mapping: TriplesMap " + node + " with more than one LogicalTable node");
        }
        BlankNodeOrIRI logicalTable = (BlankNodeOrIRI)logicalTableNode.toArray()[0];
        boolean isSQLTable = false;
        RDFTerm tableName = this.readObjectInMappingGraph(logicalTable, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#tableName"));
        if (tableName != null) {
            isSQLTable = true;
            toReturn = this.mfact.createSQLBaseTableOrView(((Literal)tableName).getLexicalForm());
        }
        if ((query = this.readObjectInMappingGraph(logicalTable, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#sqlQuery"))) != null) {
            if (isSQLTable) {
                throw new InvalidR2RMLMappingException("Invalid mapping: Logical table in TripleMap " + node + " has both a tablename and a SQL query.");
            }
            toReturn = this.mfact.createR2RMLView(((Literal)query).getLexicalForm());
            RDFTerm version = this.readObjectInMappingGraph(logicalTable, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#sqlVersion"));
            if (version != null) {
                ((R2RMLView)toReturn).addSQLVersion((IRI)version);
            }
        }
        if (toReturn == null) {
            throw new InvalidR2RMLMappingException("Invalid mapping: Logical table in TripleMap " + node + " has no tablename or SQL query.");
        }
        toReturn.setNode(logicalTable);
        return toReturn;
    }

    private RDFTerm readObjectInMappingGraph(BlankNodeOrIRI node, IRI resourceType) {
        Collection obj = this.graph.stream(node, resourceType, null).map(Triple::getObject).collect(Collectors.toSet());
        if (obj.size() == 1) {
            return (RDFTerm)obj.iterator().next();
        }
        return null;
    }

    private Collection<RDFTerm> readObjectsInMappingGraph(BlankNodeOrIRI node, IRI resourceType) {
        return this.graph.stream(node, resourceType, null).map(Triple::getObject).collect(Collectors.toSet());
    }

    private List<GraphMap> readGraphMap(BlankNodeOrIRI node) {
        ArrayList<GraphMap> graphMapList = new ArrayList<GraphMap>();
        Collection graphDecl = this.graph.stream(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graph"), null).map(Triple::getObject).collect(Collectors.toSet());
        if (graphDecl.size() > 0) {
            for (RDFTerm val : graphDecl) {
                graphMapList.add(this.mfact.createGraphMap((IRI)val));
            }
        } else {
            Collection graphMaps = this.graph.stream(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graphMap"), null).map(Triple::getObject).collect(Collectors.toSet());
            for (RDFTerm value : graphMaps) {
                BlankNodeOrIRI graphMapNode = (BlankNodeOrIRI)value;
                GraphMap graphMap = (GraphMap)this.readTermMap(graphMapNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graphMap"));
                graphMap.setNode(graphMapNode);
                graphMapList.add(graphMap);
            }
        }
        return graphMapList;
    }

    private SubjectMap readSubjectMap(BlankNodeOrIRI node) throws InvalidR2RMLMappingException {
        RDFTerm subject = this.readObjectInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#subject"));
        if (subject != null) {
            return this.mfact.createSubjectMap((IRI)subject);
        }
        Collection subjectMapNode = this.graph.stream(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#subjectMap"), null).map(Triple::getObject).collect(Collectors.toSet());
        if (subjectMapNode.size() != 1) {
            if (subjectMapNode.isEmpty()) {
                throw new InvalidR2RMLMappingException("Invalid mapping: TriplesMap " + node + " without a subjectMap node");
            }
            throw new InvalidR2RMLMappingException("Invalid mapping: TriplesMap " + node + " with more than one subjectMap node");
        }
        BlankNodeOrIRI subjectNode = (BlankNodeOrIRI)subjectMapNode.toArray()[0];
        SubjectMap subjectMap = (SubjectMap)this.readTermMap(subjectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#subjectMap"));
        if (subjectMap == null) {
            return null;
        }
        IRI termtype = (IRI)this.readObjectInMappingGraph(subjectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#termType"));
        if (termtype != null) {
            subjectMap.setTermType(termtype);
        }
        List<GraphMap> graphMaps = this.readGraphMap(subjectNode);
        for (GraphMap graphMap : graphMaps) {
            subjectMap.addGraphMap(graphMap);
        }
        RDFTerm invExpr = this.readObjectInMappingGraph(subjectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#inverseExpression"));
        if (invExpr != null) {
            subjectMap.setInverseExpression(this.mfact.createInverseExpression(((Literal)invExpr).getLexicalForm()));
        }
        Collection<RDFTerm> classes = this.readObjectsInMappingGraph(subjectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#class"));
        for (RDFTerm subjectClass : classes) {
            subjectMap.addClass((IRI)subjectClass);
        }
        subjectMap.setNode(subjectNode);
        return subjectMap;
    }

    private List<PredicateObjectMap> readPredicateObjectMaps(BlankNodeOrIRI tripleMapNode) throws InvalidR2RMLMappingException {
        ArrayList<PredicateObjectMap> predObjs = new ArrayList<PredicateObjectMap>();
        Collection predicateObjectNodes = this.graph.stream(tripleMapNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateObjectMap"), null).map(Triple::getObject).collect(Collectors.toSet());
        for (RDFTerm predobj : predicateObjectNodes) {
            BlankNodeOrIRI predobjNode = (BlankNodeOrIRI)predobj;
            List<PredicateMap> predicateMaps = this.readPredicateMaps(predobjNode);
            List<ObjectMap> objectMaps = this.readObjectMaps(predobjNode);
            List<RefObjectMap> refObjectMaps = this.readRefObjectMaps(predobjNode, tripleMapNode);
            if (predicateMaps.isEmpty()) {
                throw new InvalidR2RMLMappingException("Invalid mapping: PredicateObjectMap " + predobjNode + " in TripleMap " + tripleMapNode + " has no PredicateMap.");
            }
            if (objectMaps.isEmpty() && refObjectMaps.isEmpty()) {
                throw new InvalidR2RMLMappingException("Invalid mapping: PredicateObjectMap " + predobjNode + " in TripleMap " + tripleMapNode + " has no ObjectMaps or RefObjectMaps.");
            }
            PredicateObjectMap predobjMap = this.mfact.createPredicateObjectMap(predicateMaps, objectMaps, refObjectMaps);
            List<GraphMap> graphMaps = this.readGraphMap(predobjNode);
            for (GraphMap graphMap : graphMaps) {
                predobjMap.addGraphMap(graphMap);
            }
            if (predobjMap == null) continue;
            predobjMap.setNode(predobjNode);
            predObjs.add(predobjMap);
        }
        return predObjs;
    }

    private List<PredicateMap> readPredicateMaps(BlankNodeOrIRI node) {
        ArrayList<PredicateMap> predicateMaps = new ArrayList<PredicateMap>();
        Collection<RDFTerm> predicates = this.readObjectsInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicate"));
        if (predicates != null) {
            for (RDFTerm predicate : predicates) {
                predicateMaps.add(this.mfact.createPredicateMap((IRI)predicate));
            }
        }
        Collection predicateMapNodes = this.graph.stream(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateMap"), null).map(Triple::getObject).collect(Collectors.toSet());
        for (RDFTerm predMapNode : predicateMapNodes) {
            BlankNodeOrIRI predicateNode = (BlankNodeOrIRI)predMapNode;
            PredicateMap predicateMap = (PredicateMap)this.readTermMap(predicateNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateMap"));
            predicateMap.setNode(predicateNode);
            predicateMaps.add(predicateMap);
        }
        return predicateMaps;
    }

    private List<ObjectMap> readObjectMaps(BlankNodeOrIRI node) {
        ArrayList<ObjectMap> objectMaps = new ArrayList<ObjectMap>();
        Collection<RDFTerm> objects = this.readObjectsInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#object"));
        for (RDFTerm object : objects) {
            objectMaps.add(this.mfact.createObjectMap(object));
        }
        Collection<RDFTerm> objectMapNodes = this.readObjectsInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"));
        for (RDFTerm objectMapNode : objectMapNodes) {
            RDFTerm lang;
            IRI datatype;
            RDFTerm invExpr;
            BlankNodeOrIRI objectNode = (BlankNodeOrIRI)objectMapNode;
            ObjectMap objectMap = (ObjectMap)this.readTermMap(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"));
            if (objectMap == null) continue;
            IRI termtype = (IRI)this.readObjectInMappingGraph(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#termType"));
            if (termtype != null) {
                objectMap.setTermType(termtype);
            }
            if ((invExpr = this.readObjectInMappingGraph(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#inverseExpression"))) != null) {
                objectMap.setInverseExpression(this.mfact.createInverseExpression(((Literal)invExpr).getLexicalForm()));
            }
            if ((datatype = (IRI)this.readObjectInMappingGraph(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#datatype"))) != null) {
                objectMap.setDatatype(datatype);
            }
            if ((lang = this.readObjectInMappingGraph(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#language"))) != null) {
                objectMap.setLanguageTag(((Literal)lang).getLexicalForm());
            }
            objectMap.setNode(objectNode);
            objectMaps.add(objectMap);
        }
        return objectMaps;
    }

    private TermMap readTermMap(BlankNodeOrIRI node, IRI type) {
        RDFTerm resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#template"));
        TermMap.TermMapType termMapType = TermMap.TermMapType.TEMPLATE_VALUED;
        if (resource == null) {
            resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#column"));
            termMapType = TermMap.TermMapType.COLUMN_VALUED;
        }
        if (resource == null) {
            resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#constant"));
            termMapType = TermMap.TermMapType.CONSTANT_VALUED;
        }
        if (resource == null) {
            resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#termType"));
            if (resource instanceof IRI && resource.toString().equals("https://w3id.org/obda/r2rmlstar#RDFStarTermType")) {
                termMapType = TermMap.TermMapType.RDF_STAR_VALUED;
            } else {
                resource = null;
            }
        }
        if (resource != null) {
            if (type.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#subjectMap"))) {
                switch (termMapType) {
                    case COLUMN_VALUED: {
                        return this.mfact.createSubjectMap(((Literal)resource).getLexicalForm());
                    }
                    case CONSTANT_VALUED: {
                        return this.mfact.createSubjectMap((IRI)resource);
                    }
                    case TEMPLATE_VALUED: {
                        return this.mfact.createSubjectMap(this.mfact.createTemplate(((Literal)resource).getLexicalForm()));
                    }
                    case RDF_STAR_VALUED: {
                        return this.mfact.createSubjectMap((ObjectMap)this.readEmbeddedTermMap(node, "subject"), (PredicateMap)this.readEmbeddedTermMap(node, "predicate"), (ObjectMap)this.readEmbeddedTermMap(node, "object"));
                    }
                }
            } else if (type.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateMap"))) {
                switch (termMapType) {
                    case COLUMN_VALUED: {
                        return this.mfact.createPredicateMap(((Literal)resource).getLexicalForm());
                    }
                    case CONSTANT_VALUED: {
                        return this.mfact.createPredicateMap((IRI)resource);
                    }
                    case TEMPLATE_VALUED: {
                        return this.mfact.createPredicateMap(this.mfact.createTemplate(((Literal)resource).getLexicalForm()));
                    }
                }
            } else if (type.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"))) {
                switch (termMapType) {
                    case COLUMN_VALUED: {
                        return this.mfact.createObjectMap(((Literal)resource).getLexicalForm());
                    }
                    case CONSTANT_VALUED: {
                        return this.mfact.createObjectMap(resource);
                    }
                    case TEMPLATE_VALUED: {
                        return this.mfact.createObjectMap(this.mfact.createTemplate(((Literal)resource).getLexicalForm()));
                    }
                    case RDF_STAR_VALUED: {
                        return this.mfact.createObjectMap((ObjectMap)this.readEmbeddedTermMap(node, "subject"), (PredicateMap)this.readEmbeddedTermMap(node, "predicate"), (ObjectMap)this.readEmbeddedTermMap(node, "object"));
                    }
                }
            } else if (type.equals((Object)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graphMap"))) {
                switch (termMapType) {
                    case COLUMN_VALUED: {
                        return this.mfact.createGraphMap(((Literal)resource).getLexicalForm());
                    }
                    case CONSTANT_VALUED: {
                        return this.mfact.createGraphMap((IRI)resource);
                    }
                    case TEMPLATE_VALUED: {
                        return this.mfact.createGraphMap(this.mfact.createTemplate(((Literal)resource).getLexicalForm()));
                    }
                }
            }
        }
        return null;
    }

    private TermMap readEmbeddedTermMap(BlankNodeOrIRI node, String type) {
        switch (type) {
            case "subject": {
                RDFTerm resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("https://w3id.org/obda/r2rmlstar#subject"));
                return this.readTermMap((BlankNodeOrIRI)resource, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"));
            }
            case "predicate": {
                RDFTerm resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("https://w3id.org/obda/r2rmlstar#predicate"));
                return this.readTermMap((BlankNodeOrIRI)resource, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateMap"));
            }
            case "object": {
                RDFTerm resource = this.readObjectInMappingGraph(node, this.getRDF().createIRI("https://w3id.org/obda/r2rmlstar#object"));
                return this.readTermMap((BlankNodeOrIRI)resource, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"));
            }
        }
        return null;
    }

    private List<RefObjectMap> readRefObjectMaps(BlankNodeOrIRI pomNode, BlankNodeOrIRI tmNode) throws InvalidR2RMLMappingException {
        ArrayList<RefObjectMap> refObjectMaps = new ArrayList<RefObjectMap>();
        Collection objectMapNodes = this.graph.stream(pomNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#objectMap"), null).map(Triple::getObject).collect(Collectors.toSet());
        for (RDFTerm objectMapNode : objectMapNodes) {
            BlankNodeOrIRI objectNode = (BlankNodeOrIRI)objectMapNode;
            Iterator parentTriplesMap = this.graph.stream(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#parentTriplesMap"), null).map(Triple::getObject).collect(Collectors.toSet()).iterator();
            if (!parentTriplesMap.hasNext()) continue;
            BlankNodeOrIRI parentNode = (BlankNodeOrIRI)parentTriplesMap.next();
            if (!this.triplesMaps.containsKey(parentNode)) {
                throw new InvalidR2RMLMappingException("Invalid mapping: RefObjectMap in TripleMap " + tmNode + " refers to non-existent TripleMap: " + parentNode);
            }
            RefObjectMap refObjectMap = this.mfact.createRefObjectMap(this.triplesMaps.get(parentNode));
            refObjectMap.setNode(objectNode);
            refObjectMap.setChildLogicalTable(this.readLogicalTable(tmNode));
            refObjectMap.setParentLogicalTable(this.readLogicalTable(parentNode));
            Collection joinConditions = this.graph.stream(objectNode, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#joinCondition"), null).map(Triple::getObject).collect(Collectors.toSet());
            for (RDFTerm value : joinConditions) {
                BlankNodeOrIRI joinCondition = (BlankNodeOrIRI)value;
                String childColumn = ((Literal)this.readObjectInMappingGraph(joinCondition, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#child"))).getLexicalForm();
                String parentColumn = ((Literal)this.readObjectInMappingGraph(joinCondition, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#parent"))).getLexicalForm();
                if (childColumn == null || parentColumn == null) continue;
                refObjectMap.addJoinCondition(this.mfact.createJoinCondition(childColumn, parentColumn));
            }
            refObjectMaps.add(refObjectMap);
        }
        return refObjectMaps;
    }

    private RDF getRDF() {
        return this.rdf;
    }
}

