/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.SQLBaseTableOrView;
import eu.optique.r2rml.api.model.impl.LogicalTableImpl;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class SQLBaseTableOrViewImpl
extends LogicalTableImpl
implements SQLBaseTableOrView {
    String table;

    public SQLBaseTableOrViewImpl(RDF c, String tableName) {
        super(c);
        this.setTableName(tableName);
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    @Override
    public void setTableName(String tableName) {
        if (tableName == null) {
            throw new NullPointerException("A SQLBaseTableOrView must have a table name.");
        }
        this.table = tableName;
    }

    @Override
    public String getTableName() {
        return this.table;
    }

    @Override
    public String getSQLQuery() {
        return "SELECT * FROM " + this.table;
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#BaseTableOrView")));
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#tableName"), (RDFTerm)this.getRDF().createLiteral(this.getTableName())));
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLBaseTableOrViewImpl)) {
            return false;
        }
        SQLBaseTableOrViewImpl other = (SQLBaseTableOrViewImpl)obj;
        if (this.node == null ? other.node != null : !this.node.equals(other.node)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public String toString() {
        return "SQLBaseTableOrViewImpl [table=" + this.table + ", node=" + this.node + "]";
    }
}

