/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.GraphMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.Template;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.impl.TermMapImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class SubjectMapImpl
extends TermMapImpl
implements SubjectMap {
    private List<IRI> validTermTypes = Arrays.asList(this.getRDF().createIRI("http://www.w3.org/ns/r2rml#IRI"), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#BlankNode"));
    private ArrayList<IRI> classList = new ArrayList();
    private ArrayList<GraphMap> graphList = new ArrayList();

    SubjectMapImpl(RDF c, Template template) {
        super(c, template);
    }

    SubjectMapImpl(RDF c, String columnName) {
        super(c, columnName);
    }

    SubjectMapImpl(RDF c, IRI constant) {
        super(c, (RDFTerm)constant);
    }

    @Override
    public void addClass(IRI classURI) {
        this.classList.add(classURI);
    }

    @Override
    public void addGraphMap(GraphMap gm) {
        this.graphList.add(gm);
    }

    @Override
    public void addGraphMap(List<GraphMap> gms) {
        this.graphList.addAll(gms);
    }

    @Override
    public IRI getClass(int index) {
        return this.classList.get(index);
    }

    @Override
    public GraphMap getGraphMap(int index) {
        return this.graphList.get(index);
    }

    @Override
    public List<IRI> getClasses() {
        return Collections.unmodifiableList(this.classList);
    }

    @Override
    public List<GraphMap> getGraphMaps() {
        return Collections.unmodifiableList(this.graphList);
    }

    @Override
    public void removeClass(IRI classURI) {
        this.classList.remove(classURI);
    }

    @Override
    public void removeGraphMap(GraphMap gm) {
        this.graphList.remove(gm);
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.addAll(super.serialize());
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#SubjectMap")));
        for (IRI cl : this.classList) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#class"), (RDFTerm)cl));
        }
        for (GraphMap g : this.graphList) {
            if (g.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graph"), g.getConstant()));
                continue;
            }
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#graphMap"), (RDFTerm)g.getNode()));
            stmtSet.addAll(g.serialize());
        }
        return stmtSet;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.classList == null ? 0 : this.classList.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof SubjectMapImpl)) {
            return false;
        }
        SubjectMapImpl other = (SubjectMapImpl)obj;
        return !(this.classList == null ? other.classList != null : !this.classList.equals(other.classList));
    }

    @Override
    public String toString() {
        return "SubjectMapImpl [classList=" + this.classList + ", graphList=" + this.graphList + ", termMapType=" + this.termMapType + ", termTypeIRI=" + this.termTypeIRI + ", template=" + this.template + ", constVal=" + this.constVal + ", columnName=" + this.columnName + ", inverseExp=" + this.inverseExp + ", node=" + this.getNode() + "]";
    }

    @Override
    public List<IRI> getValidTermTypes() {
        return this.validTermTypes;
    }
}

