/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.Template;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.stream.Collectors;

public class TemplateImpl
implements Template {
    private ArrayList<String> segList = new ArrayList();
    private ArrayList<String> colList = new ArrayList();
    private String templateStringWithoutColumnNames;

    TemplateImpl() {
    }

    TemplateImpl(String template) {
        char[] chars = template.toCharArray();
        boolean braceFound = false;
        int prev = 0;
        int index = 0;
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '{' && !TemplateImpl.isEscaped(i, chars)) {
                if (!braceFound) {
                    braceFound = true;
                    this.addStringSegment(index, template.substring(prev, i));
                    prev = i + 1;
                    continue;
                }
                throw new IllegalArgumentException("Illegal template syntax. The curly braces don't match.");
            }
            if (chars[i] != '}' || TemplateImpl.isEscaped(i, chars)) continue;
            if (braceFound) {
                braceFound = false;
                this.addColumnName(index++, template.substring(prev, i));
                prev = i + 1;
                continue;
            }
            throw new IllegalArgumentException("Illegal template syntax. The curly braces don't match.");
        }
        if (braceFound) {
            throw new IllegalArgumentException("Illegal template syntax. The curly braces don't match.");
        }
        if (chars[chars.length - 1] != '}' || TemplateImpl.isEscaped(chars.length - 1, chars)) {
            this.addStringSegment(index, template.substring(prev, chars.length));
        }
        if (this.colList.size() == this.segList.size()) {
            this.templateStringWithoutColumnNames = this.segList.stream().collect(Collectors.joining("{}", "", "{}"));
        } else if (this.colList.size() + 1 == this.segList.size()) {
            this.templateStringWithoutColumnNames = this.segList.stream().collect(Collectors.joining("{}", "", ""));
        } else {
            throw new IllegalStateException("wont happen; bug detected!");
        }
    }

    private static boolean isEscaped(int index, char[] chars) {
        if (index >= chars.length) {
            throw new ArrayIndexOutOfBoundsException();
        }
        boolean odd = false;
        for (int i = index - 1; i >= 0; --i) {
            if (chars[i] != '\\') {
                return odd;
            }
            odd = !odd;
        }
        return odd;
    }

    @Override
    public String getStringSegment(int segIndex) {
        return this.segList.get(segIndex);
    }

    @Override
    public List<String> getStringSegments() {
        return this.segList;
    }

    @Override
    public String getTemplateStringWithoutColumnNames() {
        return this.templateStringWithoutColumnNames;
    }

    @Override
    public void addStringSegment(int segIndex, String segment) {
        try {
            this.segList.remove(segIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.segList.add(segIndex, segment);
    }

    @Override
    public String getColumnName(int colIndex) {
        return this.colList.get(colIndex);
    }

    @Override
    public List<String> getColumnNames() {
        return Collections.unmodifiableList(this.colList);
    }

    @Override
    public void addColumnName(int colIndex, String columnName) {
        try {
            this.colList.remove(colIndex);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        this.colList.add(colIndex, columnName);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.colList == null ? 0 : this.colList.hashCode());
        result = 31 * result + (this.segList == null ? 0 : this.segList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TemplateImpl)) {
            return false;
        }
        TemplateImpl other = (TemplateImpl)obj;
        if (this.colList == null ? other.colList != null : !this.colList.equals(other.colList)) {
            return false;
        }
        return !(this.segList == null ? other.segList != null : !this.segList.equals(other.segList));
    }

    public String toString() {
        ListIterator<String> segIt = this.segList.listIterator();
        ListIterator<String> colIt = this.colList.listIterator();
        StringBuilder sb = new StringBuilder();
        while (segIt.hasNext()) {
            sb.append((String)segIt.next());
            if (!colIt.hasNext()) break;
            sb.append("{" + (String)colIt.next() + "}");
        }
        return sb.toString();
    }
}

