/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.LogicalTable;
import eu.optique.r2rml.api.model.PredicateObjectMap;
import eu.optique.r2rml.api.model.SubjectMap;
import eu.optique.r2rml.api.model.TermMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.MappingComponentImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class TriplesMapImpl
extends MappingComponentImpl
implements TriplesMap {
    private LogicalTable logTable;
    private SubjectMap subMap;
    private ArrayList<PredicateObjectMap> pomList = new ArrayList();

    TriplesMapImpl(RDF rdf, LogicalTable lt, SubjectMap sm) {
        super(rdf);
        this.setLogicalTable(lt);
        this.setSubjectMap(sm);
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    TriplesMapImpl(RDF rdf, LogicalTable lt, SubjectMap sm, BlankNodeOrIRI node) {
        super(rdf);
        this.setLogicalTable(lt);
        this.setSubjectMap(sm);
        this.setNode(node);
    }

    @Override
    public void setLogicalTable(LogicalTable lt) {
        if (lt == null) {
            throw new NullPointerException("A TriplesMap must have a LogicalTable.");
        }
        this.logTable = lt;
    }

    @Override
    public void setSubjectMap(SubjectMap sm) {
        if (sm == null) {
            throw new NullPointerException("A TriplesMap must have a SubjectMap.");
        }
        this.subMap = sm;
    }

    @Override
    public void addPredicateObjectMap(PredicateObjectMap pom) {
        this.pomList.add(pom);
    }

    @Override
    public void addPredicateObjectMaps(Collection<PredicateObjectMap> poms) {
        this.pomList.addAll(poms);
    }

    @Override
    public LogicalTable getLogicalTable() {
        return this.logTable;
    }

    @Override
    public SubjectMap getSubjectMap() {
        return this.subMap;
    }

    @Override
    public PredicateObjectMap getPredicateObjectMap(int index) {
        return this.pomList.get(index);
    }

    @Override
    public List<PredicateObjectMap> getPredicateObjectMaps() {
        return Collections.unmodifiableList(this.pomList);
    }

    @Override
    public void removePredicateObjectMap(PredicateObjectMap pom) {
        this.pomList.remove(pom);
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#TriplesMap")));
        stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#logicalTable"), (RDFTerm)this.getLogicalTable().getNode()));
        stmtSet.addAll(this.getLogicalTable().serialize());
        if (this.getSubjectMap().getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#subject"), this.getSubjectMap().getConstant()));
        } else {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#subjectMap"), (RDFTerm)this.getSubjectMap().getNode()));
            stmtSet.addAll(this.getSubjectMap().serialize());
        }
        for (PredicateObjectMap pom : this.pomList) {
            stmtSet.add(this.getRDF().createTriple(this.getNode(), this.getRDF().createIRI("http://www.w3.org/ns/r2rml#predicateObjectMap"), (RDFTerm)pom.getNode()));
            stmtSet.addAll(pom.serialize());
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.logTable == null ? 0 : this.logTable.hashCode());
        result = 31 * result + (this.pomList == null ? 0 : this.pomList.hashCode());
        result = 31 * result + (this.getNode() == null ? 0 : this.getNode().hashCode());
        result = 31 * result + (this.subMap == null ? 0 : this.subMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriplesMapImpl)) {
            return false;
        }
        TriplesMapImpl other = (TriplesMapImpl)obj;
        if (this.logTable == null ? other.logTable != null : !this.logTable.equals(other.logTable)) {
            return false;
        }
        if (this.pomList == null ? other.pomList != null : !this.pomList.equals(other.pomList)) {
            return false;
        }
        return !(this.subMap == null ? other.subMap != null : !this.subMap.equals(other.subMap));
    }

    public String toString() {
        return "TriplesMapImpl [logTable=" + this.logTable + ", subMap=" + this.subMap + ", pomList=" + this.pomList + "]";
    }
}

