/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.r2rml.api.model.impl;

import eu.optique.r2rml.api.model.Join;
import eu.optique.r2rml.api.model.LogicalTable;
import eu.optique.r2rml.api.model.RefObjectMap;
import eu.optique.r2rml.api.model.TriplesMap;
import eu.optique.r2rml.api.model.impl.MappingComponentImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.rdf.api.BlankNodeOrIRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.api.RDFTerm;
import org.apache.commons.rdf.api.Triple;

public class RefObjectMapImpl
extends MappingComponentImpl
implements RefObjectMap {
    private TriplesMap parent;
    private LogicalTable parentLogicalTable;
    private LogicalTable childLogicalTable;
    private ArrayList<Join> joinList = new ArrayList();

    RefObjectMapImpl(RDF c, TriplesMap parentMap) {
        super(c);
        this.setParentMap(parentMap);
        this.setNode((BlankNodeOrIRI)this.getRDF().createBlankNode());
    }

    @Override
    public void setParentMap(TriplesMap tm) {
        this.parent = tm;
    }

    @Override
    public void setParentLogicalTable(LogicalTable lt) {
        this.parentLogicalTable = lt;
    }

    @Override
    public void setChildLogicalTable(LogicalTable lt) {
        this.childLogicalTable = lt;
    }

    @Override
    public String getChildQuery() {
        if (this.childLogicalTable == null) {
            throw new NullPointerException("The child logical table is not set.");
        }
        return this.childLogicalTable.getSQLQuery();
    }

    @Override
    public String getParentQuery() {
        if (this.parentLogicalTable == null) {
            throw new NullPointerException("The parent logical table is not set.");
        }
        return this.parentLogicalTable.getSQLQuery();
    }

    @Override
    public String getJointQuery() {
        if (this.joinList.isEmpty()) {
            return "SELECT * FROM (" + this.getChildQuery() + ") AS tmp";
        }
        Iterator<Join> it = this.joinList.iterator();
        String sql = "SELECT * FROM (" + this.getChildQuery() + ") AS child, (" + this.getParentQuery() + ") AS parent WHERE ";
        Join j = it.next();
        sql = sql + "child." + j.getChild() + "=parent." + j.getParent();
        while (it.hasNext()) {
            j = it.next();
            sql = sql + " AND child." + j.getChild() + "=parent." + j.getParent();
        }
        return sql;
    }

    @Override
    public void addJoinCondition(Join j) {
        this.joinList.add(j);
    }

    @Override
    public Join getJoinCondition(int index) {
        return this.joinList.get(index);
    }

    @Override
    public List<Join> getJoinConditions() {
        return Collections.unmodifiableList(this.joinList);
    }

    @Override
    public TriplesMap getParentMap() {
        return this.parent;
    }

    @Override
    public void removeJoinCondition(Join j) {
        this.joinList.remove(j);
    }

    @Override
    public Set<Triple> serialize() {
        HashSet<Triple> stmtSet = new HashSet<Triple>();
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/1999/02/22-rdf-syntax-ns#type"), (RDFTerm)this.getRDF().createIRI("http://www.w3.org/ns/r2rml#RefObjectMap")));
        stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#parentTriplesMap"), (RDFTerm)this.parent.getNode()));
        for (Join j : this.joinList) {
            stmtSet.add(this.getRDF().createTriple(this.node, this.getRDF().createIRI("http://www.w3.org/ns/r2rml#joinCondition"), (RDFTerm)j.getNode()));
            stmtSet.addAll(j.serialize());
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childLogicalTable == null ? 0 : this.childLogicalTable.hashCode());
        result = 31 * result + (this.joinList == null ? 0 : this.joinList.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.parentLogicalTable == null ? 0 : this.parentLogicalTable.hashCode());
        result = 31 * result + (this.node == null ? 0 : this.node.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefObjectMapImpl)) {
            return false;
        }
        RefObjectMapImpl other = (RefObjectMapImpl)obj;
        if (this.childLogicalTable == null ? other.childLogicalTable != null : !this.childLogicalTable.equals(other.childLogicalTable)) {
            return false;
        }
        if (this.joinList == null ? other.joinList != null : !this.joinList.equals(other.joinList)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.parentLogicalTable == null ? other.parentLogicalTable != null : !this.parentLogicalTable.equals(other.parentLogicalTable)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals((Object)other.node));
    }

    public String toString() {
        return "RefObjectMapImpl [parent=" + String.valueOf(this.parent) + ", parentLogicalTable=" + String.valueOf(this.parentLogicalTable) + ", childLogicalTable=" + String.valueOf(this.childLogicalTable) + ", joinList=" + String.valueOf(this.joinList) + ", node=" + String.valueOf(this.node) + "]";
    }
}

