/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.GraphMap;
import eu.optique.api.mapping.InverseExpression;
import eu.optique.api.mapping.Join;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.LogicalTable;
import eu.optique.api.mapping.MappingFactory;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.PredicateMap;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.R2RMLView;
import eu.optique.api.mapping.RefObjectMap;
import eu.optique.api.mapping.SQLTable;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.Template;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.TriplesMap;
import eu.optique.api.mapping.impl.GraphMapImpl;
import eu.optique.api.mapping.impl.InverseExpressionImpl;
import eu.optique.api.mapping.impl.JoinImpl;
import eu.optique.api.mapping.impl.ObjectMapImpl;
import eu.optique.api.mapping.impl.PredicateMapImpl;
import eu.optique.api.mapping.impl.PredicateObjectMapImpl;
import eu.optique.api.mapping.impl.R2RMLViewImpl;
import eu.optique.api.mapping.impl.RefObjectMapImpl;
import eu.optique.api.mapping.impl.SQLTableImpl;
import eu.optique.api.mapping.impl.SubjectMapImpl;
import eu.optique.api.mapping.impl.TemplateImpl;
import eu.optique.api.mapping.impl.TriplesMapImpl;
import java.util.List;

public class MappingFactoryImpl
implements MappingFactory {
    private LibConfiguration lc;

    public MappingFactoryImpl(LibConfiguration c) {
        this.lc = c;
    }

    @Override
    public TriplesMap createTriplesMap(LogicalTable lt, SubjectMap sm) {
        return new TriplesMapImpl(this.lc, lt, sm);
    }

    @Override
    public TriplesMap createTriplesMap(LogicalTable lt, SubjectMap sm, PredicateObjectMap pom) {
        TriplesMapImpl tm = new TriplesMapImpl(this.lc, lt, sm);
        tm.addPredicateObjectMap(pom);
        return tm;
    }

    @Override
    public TriplesMap createTriplesMap(LogicalTable lt, SubjectMap sm, List<PredicateObjectMap> listOfPom) {
        TriplesMapImpl tm = new TriplesMapImpl(this.lc, lt, sm);
        for (PredicateObjectMap pom : listOfPom) {
            tm.addPredicateObjectMap(pom);
        }
        return tm;
    }

    @Override
    public PredicateObjectMap createPredicateObjectMap(PredicateMap pm, ObjectMap om) {
        return new PredicateObjectMapImpl(this.lc, pm, om);
    }

    @Override
    public PredicateObjectMap createPredicateObjectMap(PredicateMap pm, RefObjectMap rom) {
        return new PredicateObjectMapImpl(this.lc, pm, rom);
    }

    @Override
    public PredicateObjectMap createPredicateObjectMap(List<PredicateMap> pms, List<ObjectMap> oms, List<RefObjectMap> roms) {
        return new PredicateObjectMapImpl(this.lc, pms, oms, roms);
    }

    @Override
    public R2RMLView createR2RMLView(String query) {
        return new R2RMLViewImpl(this.lc, query);
    }

    @Override
    public SQLTable createSQLBaseTableOrView(String tableName) {
        return new SQLTableImpl(this.lc, tableName);
    }

    @Override
    public GraphMap createGraphMap(Template template) {
        return new GraphMapImpl(this.lc, TermMap.TermMapType.TEMPLATE_VALUED, template);
    }

    @Override
    public GraphMap createGraphMap(TermMap.TermMapType type, String columnOrConst) {
        return new GraphMapImpl(this.lc, type, columnOrConst);
    }

    @Override
    public SubjectMap createSubjectMap(Template template) {
        return new SubjectMapImpl(this.lc, TermMap.TermMapType.TEMPLATE_VALUED, template);
    }

    @Override
    public SubjectMap createSubjectMap(TermMap.TermMapType type, String columnOrConst) {
        return new SubjectMapImpl(this.lc, type, columnOrConst);
    }

    @Override
    public PredicateMap createPredicateMap(Template template) {
        return new PredicateMapImpl(this.lc, TermMap.TermMapType.TEMPLATE_VALUED, template);
    }

    @Override
    public PredicateMap createPredicateMap(TermMap.TermMapType type, String columnOrConst) {
        return new PredicateMapImpl(this.lc, type, columnOrConst);
    }

    @Override
    public ObjectMap createObjectMap(Template template) {
        return new ObjectMapImpl(this.lc, TermMap.TermMapType.TEMPLATE_VALUED, template);
    }

    @Override
    public ObjectMap createObjectMap(TermMap.TermMapType type, String columnOrConst) {
        return new ObjectMapImpl(this.lc, type, columnOrConst);
    }

    @Override
    public RefObjectMap createRefObjectMap(Object parentMap) {
        return new RefObjectMapImpl(this.lc, parentMap);
    }

    @Override
    public Join createJoinCondition(String childColumn, String parentColumn) {
        return new JoinImpl(this.lc, childColumn, parentColumn);
    }

    @Override
    public Template createTemplate() {
        return new TemplateImpl();
    }

    @Override
    public Template createTemplate(String template) {
        return new TemplateImpl(template);
    }

    @Override
    public InverseExpression createInverseExpression(String invExp) {
        return new InverseExpressionImpl(invExp);
    }
}

