/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.SQLTable;
import eu.optique.api.mapping.impl.LogicalTableImpl;
import java.util.HashSet;
import java.util.Set;

public class SQLTableImpl
extends LogicalTableImpl
implements SQLTable {
    String table;

    public SQLTableImpl(LibConfiguration c, String tableName) {
        super(c);
        this.setSQLTable(tableName);
        this.setResource(this.lc.createBNode());
    }

    @Override
    public void setSQLTable(String tableName) {
        if (tableName == null) {
            throw new NullPointerException("A SQLTable must have a table name.");
        }
        this.table = tableName;
    }

    @Override
    public String getSQLTableName() {
        return this.table;
    }

    @Override
    public String getSQLQuery() {
        return "SELECT * FROM " + this.table;
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#BaseTableOrView"))));
        stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#tableName"), this.getSQLTableName())));
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.table == null ? 0 : this.table.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SQLTableImpl)) {
            return false;
        }
        SQLTableImpl other = (SQLTableImpl)obj;
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        return !(this.table == null ? other.table != null : !this.table.equals(other.table));
    }

    public String toString() {
        return "SQLTableImpl [table=" + this.table + ", res=" + this.res + "]";
    }
}

