/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.Join;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.LogicalTable;
import eu.optique.api.mapping.RefObjectMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class RefObjectMapImpl
implements RefObjectMap {
    Object parent;
    LogicalTable parentLogicalTable;
    LogicalTable childLogicalTable;
    ArrayList<Join> joinList;
    Object res;
    final LibConfiguration lc;

    public RefObjectMapImpl(LibConfiguration c, Object parentMap) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        this.joinList = new ArrayList();
        this.setParentMap(parentMap);
        this.setResource(this.lc.createBNode());
    }

    @Override
    public void setParentMap(Object tm) {
        if (tm != null && !this.lc.getResourceClass().isInstance(tm)) {
            throw new IllegalArgumentException("Parameter tm is of type " + tm.getClass() + ". Should be an instance of " + this.lc.getResourceClass() + ".");
        }
        if (tm == null) {
            throw new NullPointerException("A RefObjectMap must have a parent triples map resource.");
        }
        this.parent = tm;
    }

    @Override
    public void setParentLogicalTable(LogicalTable lt) {
        this.parentLogicalTable = lt;
    }

    @Override
    public void setChildLogicalTable(LogicalTable lt) {
        this.childLogicalTable = lt;
    }

    @Override
    public String getChildQuery() {
        if (this.childLogicalTable == null) {
            throw new NullPointerException("The child logical table is not set.");
        }
        return this.childLogicalTable.getSQLQuery();
    }

    @Override
    public String getParentQuery() {
        if (this.parentLogicalTable == null) {
            throw new NullPointerException("The parent logical table is not set.");
        }
        return this.parentLogicalTable.getSQLQuery();
    }

    @Override
    public String getJointQuery() {
        if (this.joinList.isEmpty()) {
            return "SELECT * FROM (" + this.getChildQuery() + ") AS tmp";
        }
        Iterator<Join> it = this.joinList.iterator();
        String sql = "SELECT * FROM (" + this.getChildQuery() + ") AS child, (" + this.getParentQuery() + ") AS parent WHERE ";
        Join j = it.next();
        sql = sql + "child." + j.getChild() + "=parent." + j.getParent();
        while (it.hasNext()) {
            j = it.next();
            sql = sql + " AND child." + j.getChild() + "=parent." + j.getParent();
        }
        return sql;
    }

    @Override
    public void addJoinCondition(Join j) {
        this.joinList.add(j);
    }

    @Override
    public Join getJoinCondition(int index) {
        return this.joinList.get(index);
    }

    @Override
    public List<Join> getJoinConditions() {
        return Collections.unmodifiableList(this.joinList);
    }

    @Override
    public <R> R getParentMap(Class<R> resourceClass) {
        return resourceClass.cast(this.parent);
    }

    @Override
    public void removeJoinCondition(Join j) {
        this.joinList.remove(j);
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#RefObjectMap"))));
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#parentTriplesMap"), this.parent)));
        for (Join j : this.joinList) {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#joinCondition"), j.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(j.serialize(tripleClass));
        }
        return stmtSet;
    }

    @Override
    public void setResource(Object r) {
        if (r != null && !this.lc.getResourceClass().isInstance(r)) {
            throw new IllegalArgumentException("Parameter r is of type " + r.getClass() + ". Should be an instance of " + this.lc.getResourceClass() + ".");
        }
        if (r == null) {
            throw new NullPointerException("A RefObjectMap must have a resource.");
        }
        this.res = r;
    }

    @Override
    public <R> R getResource(Class<R> resourceClass) {
        return resourceClass.cast(this.res);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.childLogicalTable == null ? 0 : this.childLogicalTable.hashCode());
        result = 31 * result + (this.joinList == null ? 0 : this.joinList.hashCode());
        result = 31 * result + (this.parent == null ? 0 : this.parent.hashCode());
        result = 31 * result + (this.parentLogicalTable == null ? 0 : this.parentLogicalTable.hashCode());
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RefObjectMapImpl)) {
            return false;
        }
        RefObjectMapImpl other = (RefObjectMapImpl)obj;
        if (this.childLogicalTable == null ? other.childLogicalTable != null : !this.childLogicalTable.equals(other.childLogicalTable)) {
            return false;
        }
        if (this.joinList == null ? other.joinList != null : !this.joinList.equals(other.joinList)) {
            return false;
        }
        if (this.parent == null ? other.parent != null : !this.parent.equals(other.parent)) {
            return false;
        }
        if (this.parentLogicalTable == null ? other.parentLogicalTable != null : !this.parentLogicalTable.equals(other.parentLogicalTable)) {
            return false;
        }
        return !(this.res == null ? other.res != null : !this.res.equals(other.res));
    }

    public String toString() {
        return "RefObjectMapImpl [parent=" + this.parent + ", parentLogicalTable=" + this.parentLogicalTable + ", childLogicalTable=" + this.childLogicalTable + ", joinList=" + this.joinList + ", res=" + this.res + "]";
    }
}

