/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.GraphMap;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.LogicalTable;
import eu.optique.api.mapping.MappingFactory;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.PredicateMap;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.R2RMLMappingCollection;
import eu.optique.api.mapping.R2RMLMappingManager;
import eu.optique.api.mapping.R2RMLView;
import eu.optique.api.mapping.RefObjectMap;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.TriplesMap;
import eu.optique.api.mapping.impl.InvalidR2RMLMappingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class R2RMLMappingCollectionImpl
implements R2RMLMappingCollection {
    private Map<Object, TriplesMap> triplesMaps;
    private LibConfiguration lcfg;
    private MappingFactory mfact;
    private Object graph = null;

    public R2RMLMappingCollectionImpl(R2RMLMappingManager mm, LibConfiguration lc, Object graph) throws InvalidR2RMLMappingException {
        this.lcfg = lc;
        this.mfact = mm.getMappingFactory();
        this.initialize(graph);
    }

    @Override
    public void addTriplesMap(TriplesMap mapping) {
        this.triplesMaps.put(mapping.getResource(this.lcfg.getResourceClass()), mapping);
    }

    @Override
    public void addTriplesMaps(Collection<TriplesMap> mappings) {
        for (TriplesMap map : mappings) {
            this.addTriplesMap(map);
        }
    }

    @Override
    public void initialize(Object graph) throws InvalidR2RMLMappingException {
        if (graph == null) {
            throw new NullPointerException("The RDF Graph supported for the mapping manager must not be null.");
        }
        this.graph = graph;
        this.triplesMaps = this.readTriplesMaps();
        for (Object node : this.triplesMaps.keySet()) {
            this.triplesMaps.get(node).addPredicateObjectMaps(this.readPredicateObjectMaps(node));
        }
    }

    @Override
    public Collection<TriplesMap> getTriplesMaps() {
        return this.triplesMaps.values();
    }

    private Map<Object, TriplesMap> readTriplesMaps() throws InvalidR2RMLMappingException {
        HashMap<Object, TriplesMap> triples = new HashMap<Object, TriplesMap>();
        Collection<Object> triplesMapNodes = this.lcfg.getSubjects(this.graph, this.lcfg.createResource("http://www.w3.org/ns/r2rml#logicalTable"), null);
        for (Object node : triplesMapNodes) {
            triples.put(node, this.readTriplesMap(node));
        }
        return triples;
    }

    private TriplesMap readTriplesMap(Object node) throws InvalidR2RMLMappingException {
        LogicalTable logicalTable = this.readLogicalTable(node);
        SubjectMap subjectMap = this.readSubjectMap(node);
        TriplesMap triplesMap = this.mfact.createTriplesMap(logicalTable, subjectMap);
        triplesMap.setResource(node);
        return triplesMap;
    }

    private LogicalTable readLogicalTable(Object node) throws InvalidR2RMLMappingException {
        String query;
        LogicalTable toReturn = null;
        Collection<Object> logicalTableNode = this.lcfg.getObjects(this.graph, node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#logicalTable"));
        if (logicalTableNode.size() != 1) {
            throw new InvalidR2RMLMappingException("Invalid mapping: TriplesMap " + node + " has no LogicalTable.");
        }
        Object logicalTable = logicalTableNode.toArray()[0];
        boolean isSQLTable = false;
        String tableName = this.readResource(logicalTable, this.lcfg.createResource("http://www.w3.org/ns/r2rml#tableName"));
        if (tableName != null) {
            isSQLTable = true;
            toReturn = this.mfact.createSQLBaseTableOrView(tableName);
        }
        if ((query = this.readResource(logicalTable, this.lcfg.createResource("http://www.w3.org/ns/r2rml#sqlQuery"))) != null) {
            if (isSQLTable) {
                throw new InvalidR2RMLMappingException("Invalid mapping: Logical table in TripleMap " + node + " has both a tablename and a SQL query.");
            }
            toReturn = this.mfact.createR2RMLView(query);
            String version = this.readResource(logicalTable, this.lcfg.createResource("http://www.w3.org/ns/r2rml#sqlVersion"));
            if (version != null) {
                ((R2RMLView)toReturn).addSQLVersion(this.lcfg.createResource(version));
            }
        }
        if (toReturn == null) {
            throw new InvalidR2RMLMappingException("Invalid mapping: Logical table in TripleMap " + node + " has no tablename or SQL query.");
        }
        toReturn.setResource(logicalTable);
        return toReturn;
    }

    private String readResource(Object node, Object resourceType) {
        Collection<Object> obj = this.lcfg.getObjects(this.graph, node, resourceType);
        if (obj.size() == 1) {
            return this.lcfg.getLexicalForm(obj.iterator().next());
        }
        return null;
    }

    private List<String> readResources(Object node, Object resourceType) {
        ArrayList<String> resources = new ArrayList<String>();
        Collection<Object> obj = this.lcfg.getObjects(this.graph, node, resourceType);
        if (obj.size() > 0) {
            for (Object val : obj) {
                resources.add(this.lcfg.getLexicalForm(val));
            }
            return resources;
        }
        return null;
    }

    private Object readResourceURI(Object node, Object resourceType) {
        Collection<Object> obj = this.lcfg.getObjects(this.graph, node, resourceType);
        if (obj.size() == 1) {
            return obj.toArray()[0];
        }
        return null;
    }

    private Set<Object> readResourceURIs(Object node, Object resourceType) {
        HashSet<Object> resources = new HashSet<Object>();
        Collection<Object> obj = this.lcfg.getObjects(this.graph, node, resourceType);
        for (Object value : obj) {
            resources.add(value);
        }
        return resources;
    }

    private List<GraphMap> readGraphMap(Object node) {
        ArrayList<GraphMap> graphMapList = new ArrayList<GraphMap>();
        Collection<Object> graphDecl = this.lcfg.getObjects(this.graph, node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#graph"));
        if (graphDecl.size() > 0) {
            for (Object val : graphDecl) {
                graphMapList.add(this.mfact.createGraphMap(TermMap.TermMapType.CONSTANT_VALUED, val.toString()));
            }
        } else {
            Collection<Object> graphMaps = this.lcfg.getObjects(this.graph, node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#graphMap"));
            Iterator<Object> iterator = graphMaps.iterator();
            while (iterator.hasNext()) {
                Object value;
                Object graphMapNode = value = iterator.next();
                GraphMap graphMap = (GraphMap)this.readTermMap(graphMapNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#graphMap"));
                graphMap.setResource(graphMapNode);
                graphMapList.add(graphMap);
            }
        }
        return graphMapList;
    }

    private SubjectMap readSubjectMap(Object node) throws InvalidR2RMLMappingException {
        String subject = this.readResource(node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#subject"));
        if (subject != null) {
            return this.mfact.createSubjectMap(TermMap.TermMapType.CONSTANT_VALUED, subject);
        }
        Collection<Object> subjectMapNode = this.lcfg.getObjects(this.graph, node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#subjectMap"));
        if (subjectMapNode.size() != 1) {
            throw new InvalidR2RMLMappingException("Invalid mapping: TriplesMap without subjectMap node");
        }
        Object subjectNode = subjectMapNode.toArray()[0];
        SubjectMap subjectMap = (SubjectMap)this.readTermMap(subjectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#subjectMap"));
        if (subjectMap == null) {
            return null;
        }
        Object termtype = this.readResourceURI(subjectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#termType"));
        if (termtype != null) {
            subjectMap.setTermType(termtype);
        }
        List<GraphMap> graphMaps = this.readGraphMap(subjectNode);
        for (GraphMap graphMap : graphMaps) {
            subjectMap.addGraphMap(graphMap);
        }
        String invExpr = this.readResource(subjectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#inverseExpression"));
        if (invExpr != null) {
            subjectMap.setInverseExpression(this.mfact.createInverseExpression(invExpr));
        }
        Set<Object> classes = this.readResourceURIs(subjectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#class"));
        for (Object subjectClass : classes) {
            subjectMap.addClass(subjectClass);
        }
        subjectMap.setResource(subjectNode);
        return subjectMap;
    }

    private List<PredicateObjectMap> readPredicateObjectMaps(Object tripleMapNode) throws InvalidR2RMLMappingException {
        ArrayList<PredicateObjectMap> predObjs = new ArrayList<PredicateObjectMap>();
        Collection<Object> predicateObjectNodes = this.lcfg.getObjects(this.graph, tripleMapNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#predicateObjectMap"));
        Iterator<Object> iterator = predicateObjectNodes.iterator();
        while (iterator.hasNext()) {
            Object predobj;
            Object predobjNode = predobj = iterator.next();
            List<PredicateMap> predicateMaps = this.readPredicateMaps(predobjNode);
            List<ObjectMap> objectMaps = this.readObjectMaps(predobjNode);
            List<RefObjectMap> refObjectMaps = this.readRefObjectMaps(predobjNode, tripleMapNode);
            if (predicateMaps.isEmpty()) {
                throw new InvalidR2RMLMappingException("Invalid mapping: PredicateObjectMap " + predobjNode + " in TripleMap " + tripleMapNode + " has no PredicateMap.");
            }
            if (objectMaps.isEmpty() && refObjectMaps.isEmpty()) {
                throw new InvalidR2RMLMappingException("Invalid mapping: PredicateObjectMap " + predobjNode + " in TripleMap " + tripleMapNode + " has no ObjectMaps or RefObjectMaps.");
            }
            PredicateObjectMap predobjMap = this.mfact.createPredicateObjectMap(predicateMaps, objectMaps, refObjectMaps);
            List<GraphMap> graphMaps = this.readGraphMap(predobjNode);
            for (GraphMap graphMap : graphMaps) {
                predobjMap.addGraphMap(graphMap);
            }
            if (predobjMap == null) continue;
            predobjMap.setResource(predobjNode);
            predObjs.add(predobjMap);
        }
        return predObjs;
    }

    private List<PredicateMap> readPredicateMaps(Object node) {
        ArrayList<PredicateMap> predicateMaps = new ArrayList<PredicateMap>();
        List<String> predicates = this.readResources(node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#predicate"));
        if (predicates != null) {
            for (String predicate : predicates) {
                predicateMaps.add(this.mfact.createPredicateMap(TermMap.TermMapType.CONSTANT_VALUED, predicate));
            }
        }
        Collection<Object> predicateMapNodes = this.lcfg.getObjects(this.graph, node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#predicateMap"));
        Iterator<Object> iterator = predicateMapNodes.iterator();
        while (iterator.hasNext()) {
            Object predMapNode;
            Object predicateNode = predMapNode = iterator.next();
            PredicateMap predicateMap = (PredicateMap)this.readTermMap(predicateNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#predicateMap"));
            predicateMap.setResource(predicateNode);
            predicateMaps.add(predicateMap);
        }
        return predicateMaps;
    }

    private List<ObjectMap> readObjectMaps(Object node) {
        ArrayList<ObjectMap> objectMaps = new ArrayList<ObjectMap>();
        List<String> objects = this.readResources(node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#object"));
        if (objects != null) {
            for (String object : objects) {
                objectMaps.add(this.mfact.createObjectMap(TermMap.TermMapType.CONSTANT_VALUED, object));
            }
        }
        Collection<Object> objectMapNodes = this.lcfg.getObjects(this.graph, node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#objectMap"));
        for (Object objectMapNode : objectMapNodes) {
            String lang;
            Object datatype;
            String invExpr;
            Object objectNode = objectMapNode;
            ObjectMap objectMap = (ObjectMap)this.readTermMap(objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#objectMap"));
            if (objectMap == null) continue;
            Object termtype = this.readResourceURI(objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#termType"));
            if (termtype != null) {
                objectMap.setTermType(termtype);
            }
            if ((invExpr = this.readResource(objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#inverseExpression"))) != null) {
                objectMap.setInverseExpression(this.mfact.createInverseExpression(invExpr));
            }
            if ((datatype = this.readResourceURI(objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#datatype"))) != null) {
                objectMap.setDatatype(datatype);
            }
            if ((lang = this.readResource(objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#language"))) != null) {
                objectMap.setLanguageTag(lang);
            }
            objectMap.setResource(objectNode);
            objectMaps.add(objectMap);
        }
        return objectMaps;
    }

    private TermMap readTermMap(Object node, Object type) {
        String resource = this.readResource(node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#template"));
        TermMap.TermMapType termMapType = TermMap.TermMapType.TEMPLATE_VALUED;
        if (resource == null) {
            resource = this.readResource(node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#column"));
            termMapType = TermMap.TermMapType.COLUMN_VALUED;
        }
        if (resource == null) {
            resource = this.readResource(node, this.lcfg.createResource("http://www.w3.org/ns/r2rml#constant"));
            termMapType = TermMap.TermMapType.CONSTANT_VALUED;
        }
        if (resource != null) {
            if (type.equals(this.lcfg.createResource("http://www.w3.org/ns/r2rml#subjectMap"))) {
                if (termMapType.equals((Object)TermMap.TermMapType.TEMPLATE_VALUED)) {
                    return this.mfact.createSubjectMap(this.mfact.createTemplate(resource));
                }
                return this.mfact.createSubjectMap(termMapType, resource);
            }
            if (type.equals(this.lcfg.createResource("http://www.w3.org/ns/r2rml#predicateMap"))) {
                if (termMapType.equals((Object)TermMap.TermMapType.TEMPLATE_VALUED)) {
                    return this.mfact.createPredicateMap(this.mfact.createTemplate(resource));
                }
                return this.mfact.createPredicateMap(termMapType, resource);
            }
            if (type.equals(this.lcfg.createResource("http://www.w3.org/ns/r2rml#objectMap"))) {
                if (termMapType.equals((Object)TermMap.TermMapType.TEMPLATE_VALUED)) {
                    return this.mfact.createObjectMap(this.mfact.createTemplate(resource));
                }
                return this.mfact.createObjectMap(termMapType, resource);
            }
            if (type.equals(this.lcfg.createResource("http://www.w3.org/ns/r2rml#graphMap"))) {
                if (termMapType.equals((Object)TermMap.TermMapType.TEMPLATE_VALUED)) {
                    return this.mfact.createGraphMap(this.mfact.createTemplate(resource));
                }
                return this.mfact.createGraphMap(termMapType, resource);
            }
        }
        return null;
    }

    private List<RefObjectMap> readRefObjectMaps(Object pomNode, Object tmNode) throws InvalidR2RMLMappingException {
        ArrayList<RefObjectMap> refObjectMaps = new ArrayList<RefObjectMap>();
        Collection<Object> objectMapNodes = this.lcfg.getObjects(this.graph, pomNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#objectMap"));
        for (Object objectMapNode : objectMapNodes) {
            Object objectNode = objectMapNode;
            Iterator<Object> parentTriplesMap = this.lcfg.getObjects(this.graph, objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#parentTriplesMap")).iterator();
            if (!parentTriplesMap.hasNext()) continue;
            Object parentNode = parentTriplesMap.next();
            if (!this.triplesMaps.containsKey(parentNode)) {
                throw new InvalidR2RMLMappingException("Invalid mapping: RefObjectMap in TripleMap " + tmNode + " refers to non-existent TripleMap: " + parentNode);
            }
            RefObjectMap refObjectMap = this.mfact.createRefObjectMap(this.triplesMaps.get(parentNode));
            refObjectMap.setResource(objectNode);
            refObjectMap.setChildLogicalTable(this.readLogicalTable(tmNode));
            refObjectMap.setParentLogicalTable(this.readLogicalTable(parentNode));
            Collection<Object> joinConditions = this.lcfg.getObjects(this.graph, objectNode, this.lcfg.createResource("http://www.w3.org/ns/r2rml#joinCondition"));
            Iterator<Object> iterator = joinConditions.iterator();
            while (iterator.hasNext()) {
                Object value;
                Object joinCondition = value = iterator.next();
                String childColumn = this.readResource(joinCondition, this.lcfg.createResource("http://www.w3.org/ns/r2rml#child"));
                String parentColumn = this.readResource(joinCondition, this.lcfg.createResource("http://www.w3.org/ns/r2rml#parent"));
                if (childColumn == null || parentColumn == null) continue;
                refObjectMap.addJoinCondition(this.mfact.createJoinCondition(childColumn, parentColumn));
            }
            refObjectMaps.add(refObjectMap);
        }
        return refObjectMaps;
    }
}

