/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.MappingFactory;
import eu.optique.api.mapping.R2RMLMappingCollection;
import eu.optique.api.mapping.R2RMLMappingManager;
import eu.optique.api.mapping.TriplesMap;
import eu.optique.api.mapping.impl.InvalidR2RMLMappingException;
import eu.optique.api.mapping.impl.MappingFactoryImpl;
import eu.optique.api.mapping.impl.R2RMLMappingCollectionImpl;
import java.util.Collection;

public class R2RMLMappingManagerImpl
implements R2RMLMappingManager {
    private LibConfiguration lc;
    private MappingFactory mf;

    public R2RMLMappingManagerImpl(LibConfiguration lc) {
        this.lc = lc;
        this.mf = new MappingFactoryImpl(lc);
    }

    @Override
    public MappingFactory getMappingFactory() {
        return this.mf;
    }

    @Override
    public Collection<TriplesMap> importMappings(Object graph) throws IllegalArgumentException, InvalidR2RMLMappingException {
        R2RMLMappingCollection mc = this.extractR2RMLMapping(graph);
        if (mc == null || mc.getTriplesMaps().isEmpty()) {
            throw new IllegalArgumentException("Does not contain any (valid) TriplesMaps");
        }
        for (TriplesMap map : mc.getTriplesMaps()) {
            if (map.getLogicalTable() == null) {
                throw new IllegalArgumentException("No logical table for TriplesMap " + map.getResource(this.lc.getResourceClass()).toString());
            }
            if (map.getLogicalTable().getResource(this.lc.getResourceClass()) == null && map.getLogicalTable().getSQLQuery() == null) {
                throw new IllegalArgumentException("No logical table for TriplesMap " + map.getResource(this.lc.getResourceClass()).toString());
            }
            if (map.getSubjectMap() != null) continue;
            throw new IllegalArgumentException(map.getResource(this.lc.getResourceClass()).toString() + " does not have any SubjectMap");
        }
        return mc.getTriplesMaps();
    }

    @Override
    public <G> G exportMappings(Collection<TriplesMap> maps, Class<G> graphClass) throws IllegalArgumentException {
        if (maps == null) {
            throw new NullPointerException("The mapping collection is null.");
        }
        if (maps.isEmpty()) {
            throw new IllegalArgumentException("The mapping collection is empty");
        }
        return graphClass.cast(this.lc.createGraph(maps));
    }

    protected R2RMLMappingCollection extractR2RMLMapping(Object graph) throws InvalidR2RMLMappingException {
        return new R2RMLMappingCollectionImpl(this, this.lc, graph);
    }
}

