/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.LogicalTable;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.SubjectMap;
import eu.optique.api.mapping.TermMap;
import eu.optique.api.mapping.TriplesMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class TriplesMapImpl
implements TriplesMap {
    LogicalTable logTable;
    SubjectMap subMap;
    ArrayList<PredicateObjectMap> pomList;
    Object res;
    final LibConfiguration lc;

    public TriplesMapImpl(LibConfiguration c, LogicalTable lt, SubjectMap sm) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        this.pomList = new ArrayList();
        this.setLogicalTable(lt);
        this.setSubjectMap(sm);
        this.setResource(this.lc.createBNode());
    }

    @Override
    public void setLogicalTable(LogicalTable lt) {
        if (lt == null) {
            throw new NullPointerException("A TriplesMap must have a LogicalTable.");
        }
        this.logTable = lt;
    }

    @Override
    public void setSubjectMap(SubjectMap sm) {
        if (sm == null) {
            throw new NullPointerException("A TriplesMap must have a SubjectMap.");
        }
        this.subMap = sm;
    }

    @Override
    public void addPredicateObjectMap(PredicateObjectMap pom) {
        this.pomList.add(pom);
    }

    @Override
    public void addPredicateObjectMaps(Collection<PredicateObjectMap> poms) {
        this.pomList.addAll(poms);
    }

    @Override
    public LogicalTable getLogicalTable() {
        return this.logTable;
    }

    @Override
    public SubjectMap getSubjectMap() {
        return this.subMap;
    }

    @Override
    public PredicateObjectMap getPredicateObjectMap(int index) {
        return this.pomList.get(index);
    }

    @Override
    public List<PredicateObjectMap> getPredicateObjectMaps() {
        return Collections.unmodifiableList(this.pomList);
    }

    @Override
    public void removePredicateObjectMap(PredicateObjectMap pom) {
        this.pomList.remove(pom);
    }

    @Override
    public void setResource(Object r) {
        if (r != null && !this.lc.getResourceClass().isInstance(r)) {
            throw new IllegalArgumentException("Parameter r is of type " + r.getClass() + ". Should be an instance of " + this.lc.getResourceClass() + ".");
        }
        if (r == null) {
            throw new NullPointerException("A TriplesMap must have a resource.");
        }
        this.res = r;
    }

    @Override
    public <R> R getResource(Class<R> resourceClass) {
        return resourceClass.cast(this.res);
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#TriplesMap"))));
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#logicalTable"), this.getLogicalTable().getResource(this.lc.getResourceClass()))));
        stmtSet.addAll(this.getLogicalTable().serialize(tripleClass));
        if (this.getSubjectMap().getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#subject"), this.lc.createResource(this.getSubjectMap().getConstant()))));
        } else {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#subjectMap"), this.getSubjectMap().getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(this.getSubjectMap().serialize(tripleClass));
        }
        for (PredicateObjectMap pom : this.pomList) {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#predicateObjectMap"), pom.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(pom.serialize(tripleClass));
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.logTable == null ? 0 : this.logTable.hashCode());
        result = 31 * result + (this.pomList == null ? 0 : this.pomList.hashCode());
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.subMap == null ? 0 : this.subMap.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriplesMapImpl)) {
            return false;
        }
        TriplesMapImpl other = (TriplesMapImpl)obj;
        if (this.logTable == null ? other.logTable != null : !this.logTable.equals(other.logTable)) {
            return false;
        }
        if (this.pomList == null ? other.pomList != null : !this.pomList.equals(other.pomList)) {
            return false;
        }
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        return !(this.subMap == null ? other.subMap != null : !this.subMap.equals(other.subMap));
    }

    public String toString() {
        return "TriplesMapImpl [logTable=" + this.logTable + ", subMap=" + this.subMap + ", pomList=" + this.pomList + ", res=" + this.res + "]";
    }
}

