/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.R2RMLView;
import eu.optique.api.mapping.impl.LogicalTableImpl;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class R2RMLViewImpl
extends LogicalTableImpl
implements R2RMLView {
    String sqlQuery;
    ArrayList<Object> versionList;

    public R2RMLViewImpl(LibConfiguration c, String sqlQuery) {
        super(c);
        this.setR2RMLView(sqlQuery);
        this.versionList = new ArrayList();
        this.setResource(this.lc.createBNode());
    }

    @Override
    public void setR2RMLView(String sqlQuery) {
        if (sqlQuery == null) {
            throw new NullPointerException("An R2RMLView must have a SQL query.");
        }
        this.sqlQuery = sqlQuery;
    }

    @Override
    public void addSQLVersion(Object version) {
        if (version != null && !this.lc.getResourceClass().isInstance(version)) {
            throw new IllegalArgumentException("Parameter version is of type " + version.getClass() + ". Should be an instance of " + this.lc.getResourceClass() + ".");
        }
        this.versionList.add(version);
    }

    @Override
    public String getSQLQuery() {
        return this.sqlQuery;
    }

    @Override
    public <R> R getSQLVersion(Class<R> resourceClass, int index) {
        return resourceClass.cast(this.versionList.get(index));
    }

    @Override
    public <R> List<R> getSQLVersions(Class<R> resourceClass) {
        ArrayList<R> l = new ArrayList<R>();
        for (Object o : this.versionList) {
            l.add(resourceClass.cast(o));
        }
        return Collections.unmodifiableList(l);
    }

    @Override
    public void removeSQLVersion(Object version) {
        this.versionList.remove(version);
    }

    public <R> Set<R> serialize(Class<R> trpl) {
        HashSet<R> stmtSet = new HashSet<R>();
        stmtSet.add(trpl.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#R2RMLView"))));
        stmtSet.add(trpl.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#sqlQuery"), this.getSQLQuery())));
        for (Object version : this.versionList) {
            stmtSet.add(trpl.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#sqlVersion"), version)));
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        result = 31 * result + (this.sqlQuery == null ? 0 : this.sqlQuery.hashCode());
        result = 31 * result + (this.versionList == null ? 0 : this.versionList.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof R2RMLViewImpl)) {
            return false;
        }
        R2RMLViewImpl other = (R2RMLViewImpl)obj;
        if (this.res == null ? other.res != null : !this.res.equals(other.res)) {
            return false;
        }
        if (this.sqlQuery == null ? other.sqlQuery != null : !this.sqlQuery.equals(other.sqlQuery)) {
            return false;
        }
        return !(this.versionList == null ? other.versionList != null : !this.versionList.equals(other.versionList));
    }

    public String toString() {
        return "R2RMLViewImpl [sqlQuery=" + this.sqlQuery + ", versionList=" + this.versionList + ", res=" + this.res + "]";
    }
}

