/*
 * Decompiled with CFR 0.152.
 */
package eu.optique.api.mapping.impl;

import eu.optique.api.mapping.GraphMap;
import eu.optique.api.mapping.LibConfiguration;
import eu.optique.api.mapping.ObjectMap;
import eu.optique.api.mapping.PredicateMap;
import eu.optique.api.mapping.PredicateObjectMap;
import eu.optique.api.mapping.RefObjectMap;
import eu.optique.api.mapping.TermMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PredicateObjectMapImpl
implements PredicateObjectMap {
    ArrayList<PredicateMap> predList;
    ArrayList<ObjectMap> objList;
    ArrayList<RefObjectMap> refObjList;
    ArrayList<GraphMap> graphList;
    final LibConfiguration lc;
    Object res;

    public PredicateObjectMapImpl(LibConfiguration c, PredicateMap pm, ObjectMap om) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        this.predList = new ArrayList();
        this.objList = new ArrayList();
        this.refObjList = new ArrayList();
        this.graphList = new ArrayList();
        if (pm == null) {
            throw new NullPointerException("A PredicateObjectMap must have a PredicateMap.");
        }
        if (om == null) {
            throw new NullPointerException("A PredicateObjectMap must have an ObjectMap or a RefObjectMap.");
        }
        this.addPredicateMap(pm);
        this.addObjectMap(om);
        this.setResource(this.lc.createBNode());
    }

    public PredicateObjectMapImpl(LibConfiguration c, PredicateMap pm, RefObjectMap rom) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        this.predList = new ArrayList();
        this.objList = new ArrayList();
        this.refObjList = new ArrayList();
        this.graphList = new ArrayList();
        if (pm == null) {
            throw new NullPointerException("A PredicateObjectMap must have at least one PredicateMap.");
        }
        if (rom == null) {
            throw new NullPointerException("A PredicateObjectMap must have an ObjectMap or a RefObjectMap.");
        }
        this.addPredicateMap(pm);
        this.addRefObjectMap(rom);
        this.setResource(this.lc.createBNode());
    }

    public PredicateObjectMapImpl(LibConfiguration c, List<PredicateMap> pms, List<ObjectMap> oms, List<RefObjectMap> roms) {
        if (c == null) {
            throw new NullPointerException("LibConfiguration was null.");
        }
        this.lc = c;
        this.predList = new ArrayList();
        this.objList = new ArrayList();
        this.refObjList = new ArrayList();
        this.graphList = new ArrayList();
        if (pms == null) {
            throw new NullPointerException("A PredicateObjectMap must have at least one PredicateMap.");
        }
        if (pms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one PredicateMap.");
        }
        if (oms == null && roms == null) {
            throw new NullPointerException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        if (oms == null && roms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        if (roms == null && oms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        if (oms != null && roms != null && oms.isEmpty() && roms.isEmpty()) {
            throw new IllegalArgumentException("A PredicateObjectMap must have at least one ObjectMap or RefObjectMap.");
        }
        for (PredicateMap pm : pms) {
            this.addPredicateMap(pm);
        }
        if (oms != null) {
            for (ObjectMap om : oms) {
                this.addObjectMap(om);
            }
        }
        if (roms != null) {
            for (RefObjectMap rom : roms) {
                this.addRefObjectMap(rom);
            }
        }
        this.setResource(this.lc.createBNode());
    }

    @Override
    public void addPredicateMap(PredicateMap pm) {
        this.predList.add(pm);
    }

    @Override
    public void addObjectMap(ObjectMap om) {
        this.objList.add(om);
    }

    @Override
    public void addRefObjectMap(RefObjectMap rom) {
        this.refObjList.add(rom);
    }

    @Override
    public void addGraphMap(GraphMap gm) {
        this.graphList.add(gm);
    }

    @Override
    public void addGraphMap(List<GraphMap> gms) {
        this.graphList.addAll(gms);
    }

    @Override
    public GraphMap getGraphMap(int index) {
        return this.graphList.get(index);
    }

    @Override
    public RefObjectMap getRefObjectMap(int index) {
        return this.refObjList.get(index);
    }

    @Override
    public ObjectMap getObjectMap(int index) {
        return this.objList.get(index);
    }

    @Override
    public PredicateMap getPredicateMap(int index) {
        return this.predList.get(index);
    }

    @Override
    public List<GraphMap> getGraphMaps() {
        return Collections.unmodifiableList(this.graphList);
    }

    @Override
    public List<RefObjectMap> getRefObjectMaps() {
        return Collections.unmodifiableList(this.refObjList);
    }

    @Override
    public List<ObjectMap> getObjectMaps() {
        return Collections.unmodifiableList(this.objList);
    }

    @Override
    public List<PredicateMap> getPredicateMaps() {
        return Collections.unmodifiableList(this.predList);
    }

    @Override
    public void removeGraphMap(GraphMap gm) {
        this.graphList.remove(gm);
    }

    @Override
    public void removeRefObjectMap(RefObjectMap rom) {
        if (this.refObjList.size() + this.objList.size() == 1) {
            throw new IllegalStateException("Can't remove the last ObjectMap or RefObjectMap.");
        }
        this.refObjList.remove(rom);
    }

    @Override
    public void removeObjectMap(ObjectMap om) {
        if (this.objList.size() == 1) {
            throw new IllegalStateException("Can't remove the last ObjectMap or RefObjectMap.");
        }
        this.objList.remove(om);
    }

    @Override
    public void removePredicateMap(PredicateMap pm) {
        if (this.predList.size() == 1) {
            throw new IllegalStateException("Can't remove the last PredicateMap.");
        }
        this.predList.remove(pm);
    }

    @Override
    public void setResource(Object r) {
        if (r != null && !this.lc.getResourceClass().isInstance(r)) {
            throw new IllegalArgumentException("Parameter r is of type " + r.getClass() + ". Should be an instance of " + this.lc.getResourceClass() + ".");
        }
        if (r == null) {
            throw new NullPointerException("A PredicateObjectMap must have a resource.");
        }
        this.res = r;
    }

    @Override
    public <R> R getResource(Class<R> resourceClass) {
        return resourceClass.cast(this.res);
    }

    @Override
    public <T> Set<T> serialize(Class<T> tripleClass) {
        HashSet<T> stmtSet = new HashSet<T>();
        stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.getRDFType(), this.lc.createResource("http://www.w3.org/ns/r2rml#PredicateObjectMap"))));
        for (PredicateMap pm : this.predList) {
            if (pm.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#predicate"), this.lc.createResource(pm.getConstant()))));
                continue;
            }
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#predicateMap"), pm.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(pm.serialize(tripleClass));
        }
        for (ObjectMap om : this.objList) {
            if (om.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                if (om.getTermType(this.lc.getResourceClass()).equals(this.lc.createResource("http://www.w3.org/ns/r2rml#IRI"))) {
                    stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#object"), this.lc.createResource(om.getConstant()))));
                    continue;
                }
                if (!om.getTermType(this.lc.getResourceClass()).equals(this.lc.createResource("http://www.w3.org/ns/r2rml#Literal"))) continue;
                stmtSet.add(tripleClass.cast(this.lc.createLiteralTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#object"), om.getConstant())));
                continue;
            }
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#objectMap"), om.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(om.serialize(tripleClass));
        }
        for (RefObjectMap rom : this.refObjList) {
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#objectMap"), rom.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(rom.serialize(tripleClass));
        }
        for (GraphMap g : this.graphList) {
            if (g.getTermMapType() == TermMap.TermMapType.CONSTANT_VALUED) {
                stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#graph"), this.lc.createResource(g.getConstant()))));
                continue;
            }
            stmtSet.add(tripleClass.cast(this.lc.createTriple(this.res, this.lc.createResource("http://www.w3.org/ns/r2rml#graphMap"), g.getResource(this.lc.getResourceClass()))));
            stmtSet.addAll(g.serialize(tripleClass));
        }
        return stmtSet;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.objList == null ? 0 : this.objList.hashCode());
        result = 31 * result + (this.predList == null ? 0 : this.predList.hashCode());
        result = 31 * result + (this.res == null ? 0 : this.res.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PredicateObjectMapImpl)) {
            return false;
        }
        PredicateObjectMapImpl other = (PredicateObjectMapImpl)obj;
        if (this.objList == null ? other.objList != null : !this.objList.equals(other.objList)) {
            return false;
        }
        if (this.predList == null ? other.predList != null : !this.predList.equals(other.predList)) {
            return false;
        }
        return !(this.res == null ? other.res != null : !this.res.equals(other.res));
    }

    public String toString() {
        return "PredicateObjectMapImpl [predList=" + this.predList + ", objList=" + this.objList + ", res=" + this.res + "]";
    }
}

