/*
 * Decompiled with CFR 0.152.
 */
package eu.over9000.eu.zole;

import eu.over9000.eu.zole.ZoleException;
import eu.over9000.eu.zole.ZoleInvalidInputException;
import eu.over9000.eu.zole.ZoleTransitionCallback;
import java.lang.reflect.Array;
import java.util.EnumSet;
import java.util.Objects;
import java.util.function.Consumer;

public class ZoleStateMachine<S extends Enum<S>, I extends Enum<I>> {
    private final Class<S> states;
    private final Class<I> inputs;
    private boolean started = false;
    private final S[][] transitionTable;
    private Consumer<S> handlerOnEntry;
    private Consumer<S> handlerOnExit;
    private ZoleTransitionCallback<S, I> handlerOnTransition;
    private final S startState;
    private S currentState;
    private final EnumSet<S> acceptedStates;

    public ZoleStateMachine(Class<S> states, Class<I> inputs, S startState, EnumSet<S> acceptedStates) {
        Objects.requireNonNull(states);
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(startState);
        Objects.requireNonNull(acceptedStates);
        this.states = states;
        this.inputs = inputs;
        if (((Enum[])states.getEnumConstants()).length == 0) {
            throw new ZoleException("can't create state machine with empty state enum");
        }
        if (((Enum[])inputs.getEnumConstants()).length == 0) {
            throw new ZoleException("can't create state machine with empty input enum");
        }
        this.transitionTable = (Enum[][])Array.newInstance(states, ((Enum[])states.getEnumConstants()).length, ((Enum[])inputs.getEnumConstants()).length);
        this.startState = startState;
        this.acceptedStates = acceptedStates;
        this.currentState = startState;
    }

    public void addTransition(S fromState, I withInput, S toState) {
        Objects.requireNonNull(fromState);
        Objects.requireNonNull(withInput);
        Objects.requireNonNull(toState);
        if (this.started) {
            throw new ZoleException("can't add a transition after the state machine has been started");
        }
        this.transitionTable[((Enum)fromState).ordinal()][((Enum)withInput).ordinal()] = toState;
    }

    public void addTrapTransitions(S state) {
        Objects.requireNonNull(state);
        for (Enum input : (Enum[])this.inputs.getEnumConstants()) {
            this.addTransition(state, input, state);
        }
    }

    public void setStateEntryCallback(Consumer<S> callback) {
        if (this.started) {
            throw new ZoleException("can't add a callback after the state machine has been started");
        }
        this.handlerOnEntry = callback;
    }

    public void setStateExitCallback(Consumer<S> callback) {
        if (this.started) {
            throw new ZoleException("can't add a callback after the state machine has been started");
        }
        this.handlerOnExit = callback;
    }

    public void setTransitionCallback(ZoleTransitionCallback<S, I> callback) {
        if (this.started) {
            throw new ZoleException("can't add a callback after the state machine has been started");
        }
        this.handlerOnTransition = callback;
    }

    public void processInput(I input) throws ZoleInvalidInputException {
        Objects.requireNonNull(input);
        this.started = true;
        S nextState = this.transitionTable[((Enum)this.currentState).ordinal()][((Enum)input).ordinal()];
        if (nextState == null) {
            throw new ZoleInvalidInputException("No transition in state " + this.currentState + " for input " + input);
        }
        if (this.handlerOnExit != null) {
            this.handlerOnExit.accept(this.currentState);
        }
        if (this.handlerOnTransition != null) {
            this.handlerOnTransition.accept(this.currentState, input, nextState);
        }
        this.currentState = nextState;
        if (this.handlerOnEntry != null) {
            this.handlerOnEntry.accept(this.currentState);
        }
    }

    public void reset() {
        this.currentState = this.startState;
    }

    public S getCurrentState() {
        return this.currentState;
    }

    public boolean inAcceptedState() {
        return this.acceptedStates.contains(this.currentState);
    }

    public static <S2 extends Enum<S2>, I2 extends Enum<I2>> ZoleStateMachine<S2, I2> buildFrom(Class<S2> states, Class<I2> inputs) {
        Objects.requireNonNull(states);
        Objects.requireNonNull(inputs);
        if (((Enum[])states.getEnumConstants()).length == 0) {
            throw new ZoleException("can't create state machine with empty state enum");
        }
        return new ZoleStateMachine<Enum, I2>(states, inputs, ((Enum[])states.getEnumConstants())[0], EnumSet.noneOf(states));
    }

    public static <S2 extends Enum<S2>, I2 extends Enum<I2>> ZoleStateMachine<S2, I2> buildFrom(Class<S2> states, Class<I2> inputs, EnumSet<S2> acceptedStates) {
        Objects.requireNonNull(states);
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(acceptedStates);
        if (((Enum[])states.getEnumConstants()).length == 0) {
            throw new ZoleException("can't create state machine with empty state enum");
        }
        return new ZoleStateMachine<Enum, I2>(states, inputs, ((Enum[])states.getEnumConstants())[0], acceptedStates);
    }

    public static <S2 extends Enum<S2>, I2 extends Enum<I2>> ZoleStateMachine<S2, I2> buildFrom(Class<S2> states, Class<I2> inputs, S2 startState) {
        Objects.requireNonNull(states);
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(startState);
        return new ZoleStateMachine<S2, I2>(states, inputs, startState, EnumSet.noneOf(states));
    }

    public static <S2 extends Enum<S2>, I2 extends Enum<I2>> ZoleStateMachine<S2, I2> buildFrom(Class<S2> states, Class<I2> inputs, S2 startState, EnumSet<S2> acceptedStates) {
        Objects.requireNonNull(states);
        Objects.requireNonNull(inputs);
        Objects.requireNonNull(startState);
        Objects.requireNonNull(acceptedStates);
        return new ZoleStateMachine<S2, I2>(states, inputs, startState, acceptedStates);
    }
}

