/*
 * Copyright 2016-2017 Plumbr OÜ
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.plumbr.api;

import eu.plumbr.api.noop.NullSpan;

/**
 * This class consists of static methods which can be used to either create a new {@link Span} or access the currently
 * active {@link Span}. If Plumbr Agent is attached and supports this API version, then API calls will be delegated to
 * it. Otherwise, all calls will be a NO-OP.
 *
 * @see <a href="https://plumbr.eu/support/manual#what-are-services">What are services?</a>
 * @see <a href="https://plumbr.eu/support/manual#what-are-transactions">What are transactions?</a>
 */
@SuppressWarnings("unused")
public class Plumbr {

  public static final int API_VERSION = 7;

  /**
   * Create a new transaction and return its root span. Returned span has to be manually started by calling
   * {@link Span#start()}.
   *
   * @return Root span of a new transaction, which can be further customized. Returns a null span ({@link Span#isNull()}
   *         returns true) if Plumbr Agent is not attached or is too old to support this API version.
   */
  public static Span newSpan() {
    return new NullSpan();
  }

  /**
   * Return currently active span, if any. This allows to access spans which are automatically created by Plumbr Agent
   * and to change the properties of those spans, or manually end them or mark them as failed.
   *
   * @return Currently active span or a null span ({@link Span#isNull()} returns true) if there is no active span, or if
   *         Plumbr Agent is not attached or is too old to support this API version.
   */
  public static Span getCurrentSpan() {
    return new NullSpan();
  }
}
