/*
 * Copyright 2016-2017 Plumbr OÜ
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package eu.plumbr.api.noop;

import eu.plumbr.api.Span;

import java.util.HashMap;
import java.util.Map;

/**
 * Represents a null span. Since none of the methods returning a {@link Span} return <code>null</code>, they instead
 * return an instance of {@link Span} where {@link Span#isNull()} returns <code>true</code> and which is an instance of
 * this class.
 */
public class NullSpan implements Span {

  private volatile String serviceName;
  private volatile String appName;
  private volatile String userId;
  private Map<String, String> metadata;

  @Override
  public boolean isNull() {
    return true;
  }

  @Override
  public String getTransactionId() {
    return "no-plumbr-agent-attached";
  }

  @Override
  public Span setAppName(String appName) {
    this.appName = appName;
    return this;
  }

  @Override
  public String getAppName() {
    return appName;
  }

  @Override
  public Span setServiceName(String serviceName) {
    this.serviceName = serviceName;
    return this;
  }

  @Override
  public String getServiceName() {
    return serviceName;
  }

  @Override
  public Span setUserId(String userId) {
    this.userId = userId;
    return this;
  }

  @Override
  public String getUserId() {
    return userId;
  }

  @Override
  public synchronized Span addMetadata(String name, String value) {
    if (metadata == null) {
      metadata = new HashMap<String, String>();
    }

    metadata.put(name, value);
    return this;
  }

  @Override
  public synchronized String getMetadata(String name) {
    return metadata != null ? metadata.get(name) : null;
  }

  @Override
  public void start() {

  }

  @Override
  public Span createChildSpan() {
    return new NullSpan();
  }

  @Override
  public void finishChildSpan(Span child) {

  }

  @Override
  public void finish() {

  }

  @Override
  public void fail(Throwable t) {

  }

  @Override
  public void fail(Throwable t, boolean failEntireTransaction) {

  }
}
