/*
 * Decompiled with CFR 0.152.
 */
package eu.prismacapacity.unixuid_maven_plugin;

import com.sun.security.auth.module.UnixSystem;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="unixuid", threadSafe=true, defaultPhase=LifecyclePhase.INITIALIZE, executionStrategy="always", requiresProject=true)
public class UnixUidMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.properties}", required=true)
    private Map<String, String> properties;
    @Parameter(defaultValue="${project}", readonly=true)
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        if (System.getProperty("os.name").toLowerCase().startsWith("windows")) {
            this.getLog().info((CharSequence)"Skipping because windows was detected");
        } else {
            long uid = new UnixSystem().getUid();
            this.getLog().debug((CharSequence)("Adding property: os.detected.userid=" + uid));
            this.project.getProperties().put("os.detected.userid", String.valueOf(uid));
        }
    }
}

