/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.bean;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Transient;
import org.apache.commons.beanutils.PropertyUtils;
import rs.baselib.bean.BeanSupport;
import rs.baselib.bean.IBean;
import rs.baselib.lang.LangUtils;
import rs.baselib.util.CommonUtils;

public abstract class AbstractBean
implements IBean {
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);
    private boolean dirty = false;
    private Map<String, PropertyChangeEvent> registeredChanges = new HashMap<String, PropertyChangeEvent>();

    public AbstractBean() {
        this.init();
    }

    private void init() {
        this.dirty = false;
    }

    @Override
    @Transient
    public boolean isDirty() {
        return this.dirty;
    }

    protected void setDirty(boolean dirty) {
        this.dirty = dirty;
        if (!dirty) {
            this.registeredChanges.clear();
        }
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    public void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(propertyName, listener);
    }

    protected PropertyChangeListener[] getPropertyChangeListeners() {
        return this.changeSupport.getPropertyChangeListeners();
    }

    protected PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.changeSupport.getPropertyChangeListeners(propertyName);
    }

    protected boolean firePropertyChange(String propertyName, Object oldValue, Object newValue) {
        return this.firePropertyChange(propertyName, oldValue, newValue, true);
    }

    protected boolean firePropertyChange(String propertyName, Object oldValue, Object newValue, boolean makeDirty) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue), makeDirty);
    }

    protected boolean firePropertyChange(String propertyName, int oldValue, int newValue) {
        return this.firePropertyChange(propertyName, oldValue, newValue, true);
    }

    protected boolean firePropertyChange(String propertyName, int oldValue, int newValue, boolean makeDirty) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue), makeDirty);
    }

    protected boolean firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        return this.firePropertyChange(propertyName, oldValue, newValue, true);
    }

    protected boolean firePropertyChange(String propertyName, boolean oldValue, boolean newValue, boolean makeDirty) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, oldValue, newValue), makeDirty);
    }

    public boolean firePropertyChange(String propertyName, float oldValue, float newValue) {
        return this.firePropertyChange(propertyName, oldValue, newValue, true);
    }

    public boolean firePropertyChange(String propertyName, float oldValue, float newValue, boolean makeDirty) {
        return this.firePropertyChange(new PropertyChangeEvent(this, propertyName, Float.valueOf(oldValue), Float.valueOf(newValue)), makeDirty);
    }

    protected boolean firePropertyChange(PropertyChangeEvent event) {
        return this.firePropertyChange(event, true);
    }

    protected boolean firePropertyChange(PropertyChangeEvent event, boolean makeDirty) {
        if (!CommonUtils.equals(event.getOldValue(), event.getNewValue())) {
            if (makeDirty) {
                this.registerChange(event.getPropertyName(), event.getOldValue(), event.getNewValue());
                this.setDirty(true);
            }
            this.changeSupport.firePropertyChange(event);
            return true;
        }
        return false;
    }

    protected boolean fireIndexedPropertyChange(String propertyName, int index, Object oldValue, Object newValue) {
        this.changeSupport.fireIndexedPropertyChange(propertyName, index, oldValue, newValue);
        return true;
    }

    protected boolean fireIndexedPropertyChange(String propertyName, int index, int oldValue, int newValue) {
        this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        return true;
    }

    protected boolean fireIndexedPropertyChange(String propertyName, int index, boolean oldValue, boolean newValue) {
        this.fireIndexedPropertyChange(propertyName, index, (Object)oldValue, (Object)newValue);
        return true;
    }

    protected boolean hasListeners(String propertyName) {
        return this.changeSupport.hasListeners(propertyName);
    }

    protected void registerChange(String propertyName, Object oldValue, Object newValue) {
        PropertyChangeEvent evt = this.registeredChanges.get(propertyName);
        if (evt != null) {
            if (CommonUtils.equals(newValue, evt.getOldValue())) {
                this.registeredChanges.remove(propertyName);
            } else {
                evt = new PropertyChangeEvent(this, propertyName, evt.getOldValue(), newValue);
                this.registeredChanges.put(propertyName, evt);
            }
        } else if (!CommonUtils.equals(newValue, oldValue)) {
            evt = new PropertyChangeEvent(this, propertyName, oldValue, newValue);
            this.registeredChanges.put(propertyName, evt);
        }
    }

    protected Object getOriginalValue(String propertyName) {
        PropertyChangeEvent evt = this.registeredChanges.get(propertyName);
        if (evt != null) {
            return evt.getOldValue();
        }
        return this.get(propertyName);
    }

    @Override
    public void set(String name, Object value) {
        try {
            PropertyUtils.setProperty((Object)this, (String)name, (Object)value);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot set property: " + name + "=" + value, e);
        }
    }

    @Override
    public Object get(String name) {
        try {
            return PropertyUtils.getProperty((Object)this, (String)name);
        }
        catch (NoSuchMethodException e) {
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get property: " + name, e);
        }
        return null;
    }

    @Override
    @Transient
    public Collection<PropertyChangeEvent> getChanges() {
        return new ArrayList<PropertyChangeEvent>(this.registeredChanges.values());
    }

    @Override
    public void copyTo(Object destination) {
        PropertyDescriptor[] descriptors;
        if (!this.getClass().equals(destination.getClass())) {
            throw new IllegalArgumentException("The destination must be of same type but is of " + destination.getClass().getName());
        }
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(this.getClass())) {
            String name = descriptor.getName();
            if (!this.isCopyAllowed(descriptor) || !PropertyUtils.isReadable((Object)this, (String)name) || !PropertyUtils.isWriteable((Object)destination, (String)name)) continue;
            try {
                Object value = PropertyUtils.getProperty((Object)this, (String)name);
                PropertyUtils.setProperty((Object)destination, (String)name, (Object)value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    protected boolean isCopyAllowed(PropertyDescriptor descriptor) {
        return !BeanSupport.INSTANCE.isCopyForbidden(this.getClass(), descriptor.getName());
    }

    @Override
    public void reset() {
        Collection<PropertyChangeEvent> changes = this.getChanges();
        for (PropertyChangeEvent evt : changes) {
            this.set(evt.getPropertyName(), evt.getOldValue());
        }
        this.setDirty(false);
    }

    public String toString() {
        PropertyDescriptor[] descriptors;
        ArrayList<Object> properties = new ArrayList<Object>();
        for (PropertyDescriptor descriptor : descriptors = PropertyUtils.getPropertyDescriptors(this.getClass())) {
            if (BeanSupport.INSTANCE.isTransient(this, descriptor.getName())) continue;
            try {
                String name = descriptor.getName();
                Object value = PropertyUtils.getProperty((Object)this, (String)name);
                properties.add(name);
                properties.add(value);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return LangUtils.toString(this.getClass().getSimpleName(), properties.toArray());
    }
}

