/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.configuration;

import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.SubnodeConfiguration;
import rs.baselib.configuration.IConfigurable;
import rs.baselib.lang.LangUtils;

public class ConfigurationUtils {
    public static Object load(Configuration config, boolean configure) {
        String className = config.getString("[@class]");
        return ConfigurationUtils.load(className, config, configure);
    }

    public static Object load(String className, Configuration config, boolean configure) {
        try {
            Class<?> clazz = LangUtils.forName(className);
            return ConfigurationUtils.load(clazz, config, configure);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Cannot load class from configuration", e);
        }
    }

    public static <T> T load(Class<T> clazz, Configuration config, boolean configure) {
        try {
            T rc = clazz.newInstance();
            if (configure && rc instanceof IConfigurable) {
                ConfigurationUtils.configure((IConfigurable)rc, config);
            }
            return rc;
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot load class from configuration", e);
        }
    }

    public static void configure(IConfigurable configurable, Configuration config) throws ConfigurationException {
        configurable.configure(config);
    }

    public static String getParam(SubnodeConfiguration config, String name) {
        if (config == null) {
            return null;
        }
        int index = 0;
        try {
            while (true) {
                SubnodeConfiguration cfg;
                if ((cfg = config.configurationAt("param(" + index + ")")) == null) {
                    return null;
                }
                String n = cfg.getString("[@name]");
                if (name.equals(n)) {
                    return config.getString("param(" + index + ")");
                }
                ++index;
            }
        }
        catch (Exception e) {
            return null;
        }
    }
}

