/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import org.apache.commons.codec.binary.Base64;
import rs.baselib.crypto.DecryptionException;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.crypto.SigningException;

public class DataSigner {
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public DataSigner() throws DecryptionException {
        this(null, null);
    }

    public DataSigner(KeyPair keyPair) throws DecryptionException {
        this(keyPair.getPrivate(), keyPair.getPublic());
    }

    public DataSigner(PrivateKey privateKey, PublicKey publicKey) throws DecryptionException {
        this.setPublicKey(publicKey);
        this.setPrivateKey(privateKey);
    }

    public DataSigner(PrivateKey privateKey) throws DecryptionException {
        this(privateKey, null);
    }

    public DataSigner(PublicKey publicKey) throws DecryptionException {
        this(null, publicKey);
    }

    public PrivateKey getPrivateKey() {
        return this.privateKey;
    }

    public void setPrivateKey(PrivateKey privateKey) {
        this.privateKey = privateKey;
    }

    public void setPrivateKey(String privateKey) throws SigningException {
        try {
            this.setPrivateKey(EncryptionUtils.decodeBase64PrivateKey(privateKey));
        }
        catch (Throwable t) {
            throw new SigningException(t);
        }
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public void setPublicKey(String publicKey) throws SigningException {
        try {
            this.setPublicKey(EncryptionUtils.decodeBase64PublicKey(publicKey));
        }
        catch (Throwable t) {
            throw new SigningException(t);
        }
    }

    public String sign(Reader reader) throws SigningException {
        return Base64.encodeBase64String((byte[])this.getByteSignature(reader)).trim();
    }

    public byte[] getByteSignature(Reader reader) throws SigningException {
        try {
            Signature dsa = Signature.getInstance("SHA1withDSA");
            dsa.initSign(this.getPrivateKey());
            this.update(dsa, reader);
            return dsa.sign();
        }
        catch (SigningException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SigningException(t);
        }
    }

    public String sign(InputStream in) throws SigningException {
        return Base64.encodeBase64String((byte[])this.getByteSignature(in)).trim();
    }

    public byte[] getByteSignature(InputStream in) throws SigningException {
        try {
            Signature dsa = Signature.getInstance("SHA1withDSA");
            dsa.initSign(this.getPrivateKey());
            this.update(dsa, in);
            return dsa.sign();
        }
        catch (SigningException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SigningException(t);
        }
    }

    public void update(Signature signature, InputStream in) throws SigningException {
        try {
            int rc = -1;
            byte[] buf = new byte[1024];
            while ((rc = in.read(buf)) >= 0) {
                if (rc == 0) continue;
                signature.update(buf, 0, rc);
            }
        }
        catch (Throwable t) {
            throw new SigningException(t);
        }
    }

    protected void update(Signature signature, Reader reader) throws SigningException {
        try {
            int rc = -1;
            char[] buf = new char[1024];
            while ((rc = reader.read(buf)) >= 0) {
                if (rc == 0) continue;
                String s = new String(buf, 0, rc);
                signature.update(s.getBytes("UTF8"));
            }
        }
        catch (Throwable t) {
            throw new SigningException(t);
        }
    }

    public String sign(String str) throws SigningException {
        return this.sign(new StringReader(str));
    }

    public byte[] getByteSignature(String str) throws SigningException {
        return this.getByteSignature(new StringReader(str));
    }

    public String sign(byte[] bytes) throws SigningException {
        return this.sign(new ByteArrayInputStream(bytes));
    }

    public byte[] getByteSignature(byte[] bytes) throws SigningException {
        return this.getByteSignature(new ByteArrayInputStream(bytes));
    }

    public boolean verify(String signature, InputStream in) throws SigningException {
        return this.verify(EncryptionUtils.decodeBase64(signature), in);
    }

    public boolean verify(byte[] signature, InputStream in) throws SigningException {
        try {
            Signature dsa = Signature.getInstance("SHA1withDSA");
            dsa.initVerify(this.getPublicKey());
            this.update(dsa, in);
            return dsa.verify(signature);
        }
        catch (SigningException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SigningException("Cannot verify signature: " + t.getMessage(), t);
        }
    }

    public boolean verify(String signature, Reader in) throws SigningException {
        return this.verify(EncryptionUtils.decodeBase64(signature), in);
    }

    public boolean verify(byte[] signature, Reader in) throws SigningException {
        try {
            Signature dsa = Signature.getInstance("SHA1withDSA");
            dsa.initVerify(this.getPublicKey());
            this.update(dsa, in);
            return dsa.verify(signature);
        }
        catch (SigningException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new SigningException("Cannot verify signature: " + t.getMessage(), t);
        }
    }

    public boolean verify(String signature, String str) throws SigningException {
        return this.verify(signature, (Reader)new StringReader(str));
    }

    public boolean verify(byte[] signature, byte[] data) throws SigningException {
        return this.verify(signature, (InputStream)new ByteArrayInputStream(data));
    }
}

