/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import rs.baselib.crypto.DecryptionException;
import rs.baselib.crypto.EncryptionUtils;

public class Decrypter {
    private Cipher dcipher;
    private AlgorithmParameterSpec algorithmParameterSpec;

    public Decrypter(Cipher dCipher) {
        this.dcipher = dCipher;
    }

    public Decrypter(Key key, String algorithm) throws DecryptionException {
        this(key, algorithm, null);
    }

    public Decrypter(Key key, String algorithm, AlgorithmParameterSpec paramSpec) throws DecryptionException {
        this.init(key, algorithm, paramSpec);
    }

    public Decrypter(Key key, String algorithm, byte[] salt, int iterationCount) throws DecryptionException {
        this.init(key, algorithm, EncryptionUtils.generateParamSpec(salt, iterationCount));
    }

    public Decrypter(byte[] bytephrase, byte[] salt, int iterationCount) throws DecryptionException {
        try {
            if (iterationCount < 1) {
                iterationCount = 19;
            }
            if (salt == null) {
                salt = EncryptionUtils.generateSalt(0L);
            }
            PBEKeySpec keySpec = new PBEKeySpec(new String(bytephrase, "UTF8").toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.init(key, "PBEWithMD5AndDES", EncryptionUtils.generateParamSpec(salt, iterationCount));
        }
        catch (UnsupportedEncodingException e) {
            throw new DecryptionException("Unsupported encoding: " + e.getMessage(), e);
        }
        catch (InvalidKeySpecException e) {
            throw new DecryptionException("Invalid key specification: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DecryptionException("No such algorithm: " + e.getMessage(), e);
        }
    }

    public Decrypter(char[] passPhrase) throws DecryptionException {
        this(new String(passPhrase));
    }

    public Decrypter(char[] passPhrase, byte[] salt) throws DecryptionException {
        this(new String(passPhrase), salt);
    }

    public Decrypter(String passPhrase) throws DecryptionException {
        this(passPhrase, null, 0);
    }

    public Decrypter(String passPhrase, byte[] salt) throws DecryptionException {
        this(passPhrase, salt, 0);
    }

    public Decrypter(String passPhrase, byte[] salt, int iterationCount) throws DecryptionException {
        try {
            if (iterationCount < 1) {
                iterationCount = 19;
            }
            if (salt == null) {
                salt = EncryptionUtils.generateSalt(0L);
            }
            PBEKeySpec keySpec = new PBEKeySpec(passPhrase.toCharArray(), salt, iterationCount);
            SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
            this.init(key, "PBEWithMD5AndDES", EncryptionUtils.generateParamSpec(salt, iterationCount));
        }
        catch (InvalidKeySpecException e) {
            throw new DecryptionException("Invalid key specification: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DecryptionException("No such algorithm: " + e.getMessage(), e);
        }
    }

    private void init(Key key, String algorithm, AlgorithmParameterSpec paramSpec) throws DecryptionException {
        try {
            this.algorithmParameterSpec = paramSpec;
            if (algorithm == null) {
                algorithm = key.getAlgorithm();
            }
            this.dcipher = Cipher.getInstance(algorithm);
            if (paramSpec != null) {
                this.dcipher.init(2, key, paramSpec);
            } else {
                this.dcipher.init(2, key);
            }
        }
        catch (NoSuchPaddingException e) {
            throw new DecryptionException("No such padding: " + e.getMessage(), e);
        }
        catch (NoSuchAlgorithmException e) {
            throw new DecryptionException("No such algorithm: " + e.getMessage(), e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new DecryptionException("Invalid algorithm: " + e.getMessage(), e);
        }
        catch (InvalidKeyException e) {
            throw new DecryptionException("Invalid key: " + e.getMessage(), e);
        }
        catch (Throwable t) {
            throw new DecryptionException("Cannot initialize decrypter: " + t.getMessage(), t);
        }
    }

    public String getAlgorithm() {
        return this.dcipher.getAlgorithm();
    }

    public AlgorithmParameterSpec getAlgorithmParameterSpec() {
        return this.algorithmParameterSpec;
    }

    public String decrypt(String str) throws DecryptionException {
        try {
            byte[] dec = EncryptionUtils.decodeBase64(str);
            byte[] utf8 = this.dcipher.doFinal(dec);
            return new String(utf8, "UTF8");
        }
        catch (Throwable t) {
            throw new DecryptionException("Cannot decrypt string: " + t.getMessage(), t);
        }
    }

    public byte[] decrypt(byte[] bytes) throws DecryptionException {
        try {
            return this.dcipher.doFinal(bytes);
        }
        catch (Throwable t) {
            throw new DecryptionException("Cannot decrypt: " + t.getMessage(), t);
        }
    }
}

