/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.security.Key;
import java.security.KeyPair;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.crypto.ICryptingDelegate;
import rs.baselib.crypto.ICryptingDelegateFactory;

public class DefaultCryptingDelegate
implements ICryptingDelegate {
    private static Logger log = LoggerFactory.getLogger(DefaultCryptingDelegate.class);
    private Cipher eCipher;
    private Cipher dCipher;
    private boolean blockBased;

    @Override
    public void init(ICryptingDelegateFactory factory) {
        try {
            KeyPair keyPair = factory.getKeyPair();
            String algorithm = factory.getAlgorithm();
            if (keyPair != null) {
                if (algorithm == null) {
                    algorithm = keyPair.getPrivate().getAlgorithm();
                }
                log.debug("Key uses algorithm: " + algorithm);
                AlgorithmParameterSpec spec = factory.getParamSpec();
                if (algorithm == null) {
                    algorithm = "PBEWithMD5AndDES";
                }
                this.dCipher = Cipher.getInstance(algorithm);
                this.eCipher = Cipher.getInstance(algorithm);
                SecureRandom random = new SecureRandom();
                if (spec == null) {
                    this.dCipher.init(2, (Key)keyPair.getPrivate(), random);
                    this.eCipher.init(1, (Key)keyPair.getPublic(), random);
                } else {
                    this.dCipher.init(2, (Key)keyPair.getPrivate(), spec, random);
                    this.eCipher.init(1, (Key)keyPair.getPublic(), spec, random);
                }
                this.blockBased = true;
            } else {
                char[] passphrase = factory.getPassphrase();
                int iterationCount = 19;
                byte[] salt = factory.getSalt();
                PBEKeySpec keySpec = new PBEKeySpec(passphrase, salt, iterationCount);
                SecretKey key = SecretKeyFactory.getInstance("PBEWithMD5AndDES").generateSecret(keySpec);
                AlgorithmParameterSpec paramSpec = factory.getParamSpec();
                algorithm = factory.getAlgorithm();
                if (algorithm == null) {
                    algorithm = key.getAlgorithm();
                }
                this.eCipher = Cipher.getInstance(algorithm);
                this.dCipher = Cipher.getInstance(algorithm);
                if (paramSpec != null) {
                    this.eCipher.init(1, (Key)key, paramSpec);
                    this.dCipher.init(2, (Key)key, paramSpec);
                } else {
                    this.eCipher.init(1, key);
                    this.dCipher.init(2, key);
                }
                this.blockBased = false;
            }
            log.debug("Cipher block length (encrypt) = " + this.eCipher.getBlockSize());
            log.debug("Cipher block length (decrypt) = " + this.dCipher.getBlockSize());
        }
        catch (Exception e) {
            throw new RuntimeException("Canot create ciphers", e);
        }
    }

    @Override
    public byte[] encrypt(byte[] bytes) throws Exception {
        if (this.isBlockBased()) {
            int blockSize = this.eCipher.getBlockSize();
            if (blockSize == 0) {
                blockSize = 245;
            }
            return EncryptionUtils.crypt(bytes, this.eCipher, blockSize);
        }
        return EncryptionUtils.crypt(bytes, this.eCipher);
    }

    @Override
    public byte[] decrypt(byte[] bytes) throws Exception {
        if (this.isBlockBased()) {
            int blockSize = this.dCipher.getBlockSize();
            if (blockSize == 0) {
                blockSize = 256;
            }
            return EncryptionUtils.crypt(bytes, this.dCipher, blockSize);
        }
        return EncryptionUtils.crypt(bytes, this.dCipher);
    }

    public boolean isBlockBased() {
        return this.blockBased;
    }
}

