/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.crypto;

import java.security.KeyPair;
import org.apache.commons.io.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.crypto.EncryptionUtils;

public class KeyGen {
    private static Logger log = LoggerFactory.getLogger(KeyGen.class);

    public static KeyPair generateKeyPair(String seed) {
        try {
            if (seed == null) {
                seed = EncryptionUtils.generatePassword(8);
            }
            KeyPair keyPair = EncryptionUtils.generateKey(seed.getBytes(Charsets.UTF_8));
            String privateKey = EncryptionUtils.encodeBase64(keyPair.getPrivate());
            String publicKey = EncryptionUtils.encodeBase64(keyPair.getPublic());
            log.info("Private Key: " + privateKey);
            log.info("Public Key : " + publicKey);
            return keyPair;
        }
        catch (Throwable t) {
            throw new RuntimeException(t.getMessage(), t);
        }
    }
}

