/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Currency;
import java.util.Date;
import java.util.TimeZone;
import rs.baselib.util.RsDate;
import rs.baselib.util.RsDay;
import rs.baselib.util.RsMonth;
import rs.baselib.util.RsYear;

public class ConverterUtils {
    public static byte[] toBytes(short param) {
        ByteBuffer b = ByteBuffer.allocate(2);
        b.putShort(param);
        return b.array();
    }

    public static byte[] toBytes(Short param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes((short)param);
    }

    public static short toShort(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf.getShort();
    }

    public static Short toShortObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ConverterUtils.toShort(bytes);
    }

    public static byte[] toBytes(int param) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putInt(param);
        return b.array();
    }

    public static byte[] toBytes(Integer param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes((int)param);
    }

    public static int toInt(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf.getInt();
    }

    public static Integer toIntObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ConverterUtils.toInt(bytes);
    }

    public static byte[] toBytes(long param) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.putLong(param);
        return b.array();
    }

    public static byte[] toBytes(Long param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes((long)param);
    }

    public static long toLong(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf.getLong();
    }

    public static Long toLongObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ConverterUtils.toLong(bytes);
    }

    public static byte[] toBytes(float param) {
        ByteBuffer b = ByteBuffer.allocate(4);
        b.putFloat(param);
        return b.array();
    }

    public static byte[] toBytes(Float param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.floatValue());
    }

    public static float toFloat(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf.getFloat();
    }

    public static Float toFloatObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return Float.valueOf(ConverterUtils.toFloat(bytes));
    }

    public static byte[] toBytes(double param) {
        ByteBuffer b = ByteBuffer.allocate(8);
        b.putDouble(param);
        return b.array();
    }

    public static byte[] toBytes(Double param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes((double)param);
    }

    public static double toDouble(byte[] bytes) {
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return buf.getDouble();
    }

    public static Double toDoubleObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ConverterUtils.toDouble(bytes);
    }

    public static byte[] toBytes(char param) {
        ByteBuffer b = ByteBuffer.allocate(2);
        b.putChar(param);
        return b.array();
    }

    public static byte[] toBytes(Character param) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.charValue());
    }

    public static char toChar(byte[] bytes) throws UnsupportedEncodingException {
        ByteBuffer b = ByteBuffer.wrap(bytes);
        return b.getChar();
    }

    public static Character toCharObject(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        return Character.valueOf(ConverterUtils.toChar(bytes));
    }

    public static byte[] toBytes(char[] param) throws UnsupportedEncodingException {
        return ConverterUtils.toBytes(new String(param));
    }

    public static char[] toCharArray(byte[] bytes) throws UnsupportedEncodingException {
        return ConverterUtils.toString(bytes).toCharArray();
    }

    public static byte[] toBytes(byte param) {
        return new byte[]{param};
    }

    public static byte[] toBytes(Byte param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes((byte)param);
    }

    public static byte toByte(byte[] bytes) {
        return bytes[0];
    }

    public static Byte toByteObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ConverterUtils.toByte(bytes);
    }

    public static byte[] toBytes(boolean param) {
        return new byte[]{param ? (byte)1 : 0};
    }

    public static byte[] toBytes(Boolean param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes((boolean)param);
    }

    public static boolean toBoolean(byte[] bytes) {
        if (bytes == null || bytes.length == 0) {
            return false;
        }
        return bytes[0] > 0;
    }

    public static Boolean toBooleanObject(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return ConverterUtils.toBoolean(bytes);
    }

    public static byte[] toBytes(String param) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        return param.getBytes("UTF8");
    }

    public static String toString(byte[] bytes) throws UnsupportedEncodingException {
        return new String(bytes, "UTF8");
    }

    public static byte[] toBytes(Date param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getTime());
    }

    public static byte[] toBytes(RsDate param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getTime());
    }

    public static byte[] toBytes(RsMonth param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getTime());
    }

    public static byte[] toBytes(RsYear param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getTime());
    }

    public static byte[] toBytes(RsDay param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getTime());
    }

    public static Date toDate(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new Date(ConverterUtils.toLong(bytes));
    }

    public static RsDate toRsDay(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new RsDay(ConverterUtils.toLong(bytes));
    }

    public static RsDate toRsDate(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new RsDate(ConverterUtils.toLong(bytes));
    }

    public static RsMonth toRsMonth(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new RsMonth(ConverterUtils.toLong(bytes));
    }

    public static RsYear toRsYear(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new RsYear(ConverterUtils.toLong(bytes));
    }

    public static byte[] toBytes(Timestamp param) {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getTime());
    }

    public static Timestamp toTimestamp(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new Timestamp(ConverterUtils.toLong(bytes));
    }

    public static byte[] toBytes(Currency param) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getCurrencyCode());
    }

    public static Currency toCurrency(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        return Currency.getInstance(ConverterUtils.toString(bytes));
    }

    public static byte[] toBytes(TimeZone param) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.getID());
    }

    public static TimeZone toTimeZone(byte[] bytes) throws UnsupportedEncodingException {
        if (bytes == null) {
            return null;
        }
        return TimeZone.getTimeZone(ConverterUtils.toString(bytes));
    }

    public static byte[] toBytes(URL param) throws UnsupportedEncodingException {
        if (param == null) {
            return null;
        }
        return ConverterUtils.toBytes(param.toExternalForm());
    }

    public static URL toURL(byte[] bytes) throws UnsupportedEncodingException, MalformedURLException {
        if (bytes == null) {
            return null;
        }
        return new URL(ConverterUtils.toString(bytes));
    }

    public static byte[] toBytes(Serializable o) throws IOException {
        if (o == null) {
            return null;
        }
        ByteArrayOutputStream bOut = new ByteArrayOutputStream(1000);
        ObjectOutputStream out = new ObjectOutputStream(bOut);
        out.writeObject(o);
        out.close();
        return bOut.toByteArray();
    }

    public static Object toObject(byte[] bytes) throws ClassNotFoundException, IOException {
        ByteArrayInputStream bIn = new ByteArrayInputStream(bytes);
        ObjectInputStream in = new ObjectInputStream(bIn);
        return in.readObject();
    }
}

