/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.util.CommonUtils;

public class FileFinder {
    private static Logger log = LoggerFactory.getLogger(FileFinder.class);

    public static URL find(String name) {
        return FileFinder.find(null, name);
    }

    public static URL find(Class<?> clazz, String name) {
        ClassLoader loader;
        URL rc;
        block9: {
            rc = null;
            if (clazz == null) {
                clazz = FileFinder.class;
            }
            try {
                File f = new File(name);
                if (f.exists() && f.isFile() && f.canRead()) {
                    rc = f.toURI().toURL();
                }
            }
            catch (Exception e) {
                if (!log.isDebugEnabled()) break block9;
                log.debug("No such local file: " + name, (Throwable)e);
            }
        }
        String[] dirs = null;
        if (!name.startsWith("/")) {
            dirs = clazz.getPackage().getName().split("\\.");
        }
        if (rc == null && clazz != null) {
            loader = clazz.getClassLoader();
            rc = FileFinder.find(loader, dirs, name);
        }
        if (rc == null && (loader = Thread.currentThread().getContextClassLoader()) != null) {
            rc = FileFinder.find(loader, dirs, name);
        }
        if (log.isDebugEnabled()) {
            log.debug(name + " located at " + rc);
        }
        if (rc == null && !name.startsWith("/") && !name.startsWith(".")) {
            rc = FileFinder.find(clazz, "/" + name);
        }
        return rc;
    }

    private static URL find(ClassLoader classLoader, String[] dirs, String name) {
        URL rc;
        block6: {
            rc = null;
            if (dirs != null) {
                try {
                    if (!name.startsWith("/")) {
                        String pkgDir;
                        for (int i = dirs.length; i > 0 && (rc = classLoader.getResource((pkgDir = StringUtils.join((Object[])dirs, (char)'/', (int)0, (int)i)) + "/" + name)) == null; --i) {
                        }
                    }
                }
                catch (Exception e) {
                    if (!log.isDebugEnabled()) break block6;
                    log.debug("No such classpath file: " + name, (Throwable)e);
                }
            }
        }
        if (rc == null) {
            rc = classLoader.getResource(name);
        }
        return rc;
    }

    public static InputStream open(String name) throws IOException {
        return FileFinder.open(null, name);
    }

    public static InputStream open(Class<?> clazz, String name) throws IOException {
        URL url = FileFinder.find(clazz, name);
        if (url != null) {
            return url.openStream();
        }
        return null;
    }

    public static String load(String name) throws IOException {
        return FileFinder.load(null, name);
    }

    public static String load(Class<?> clazz, String name) throws IOException {
        InputStream in = FileFinder.open(clazz, name);
        return CommonUtils.loadContent(in);
    }
}

