/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.lang;

import java.beans.PropertyDescriptor;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Array;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import javax.persistence.Transient;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.io.Charsets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rs.baselib.bean.NoCopy;
import rs.baselib.util.RsDate;

public class LangUtils {
    private static Logger log = LoggerFactory.getLogger(LangUtils.class);
    private static String javaVersion = null;

    public static Class<?> forName(String className) throws ClassNotFoundException {
        return LangUtils.forName(className, null);
    }

    public static Class<?> forName(String className, ClassLoader classLoader) throws ClassNotFoundException {
        if (classLoader == null) {
            try {
                classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader != null) {
                    return Class.forName(className, true, classLoader);
                }
            }
            catch (ClassNotFoundException e) {
                classLoader = null;
            }
        }
        if (classLoader != null) {
            return Class.forName(className, true, classLoader);
        }
        return Class.forName(className);
    }

    public static Object newInstance(String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return LangUtils.newInstance(className, null);
    }

    public static Object newInstance(String className, ClassLoader classLoader) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        Class<?> clazz = LangUtils.forName(className, classLoader);
        return clazz.newInstance();
    }

    public static Class<?> getClass(Type type) {
        if (type instanceof Class) {
            return (Class)type;
        }
        if (type instanceof ParameterizedType) {
            return LangUtils.getClass(((ParameterizedType)type).getRawType());
        }
        if (type instanceof GenericArrayType) {
            Type componentType = ((GenericArrayType)type).getGenericComponentType();
            Class<?> componentClass = LangUtils.getClass(componentType);
            if (componentClass != null) {
                return Array.newInstance(componentClass, 0).getClass();
            }
            return null;
        }
        return null;
    }

    public static <T> List<Class<?>> getTypeArguments(Class<T> baseClass, Class<? extends T> childClass) {
        HashMap resolvedTypes = new HashMap();
        Type type = childClass;
        Class<?> typeClass = LangUtils.getClass(type);
        while (typeClass != null && !typeClass.equals(baseClass)) {
            if (type instanceof Class) {
                type = type.getGenericSuperclass();
            } else {
                ParameterizedType parameterizedType = (ParameterizedType)type;
                Class rawType = (Class)parameterizedType.getRawType();
                Type[] actualTypeArguments = parameterizedType.getActualTypeArguments();
                TypeVariable<Class<T>>[] typeParameters = rawType.getTypeParameters();
                for (int i = 0; i < actualTypeArguments.length; ++i) {
                    resolvedTypes.put(typeParameters[i], actualTypeArguments[i]);
                }
                if (!rawType.equals(baseClass)) {
                    type = rawType.getGenericSuperclass();
                }
            }
            typeClass = LangUtils.getClass(type);
        }
        Type[] actualTypeArguments = type instanceof Class ? type.getTypeParameters() : ((ParameterizedType)type).getActualTypeArguments();
        ArrayList typeArgumentsAsClasses = new ArrayList();
        for (Type baseType : actualTypeArguments) {
            while (resolvedTypes.containsKey(baseType)) {
                baseType = (Type)resolvedTypes.get(baseType);
            }
            typeArgumentsAsClasses.add(LangUtils.getClass(baseType));
        }
        return typeArgumentsAsClasses;
    }

    public static String getString(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public static int getInt(Object o) {
        if (o == null) {
            return 0;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        return Integer.parseInt(o.toString());
    }

    public static int getInt(Object o, int defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).intValue();
        }
        try {
            return Integer.parseInt(o.toString());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static long getLong(Object o) {
        if (o == null) {
            return 0L;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Long.parseLong(o.toString());
    }

    public static long getLong(Object o, long defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static float getFloat(Object o) {
        if (o == null) {
            return 0.0f;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        return Float.parseFloat(o.toString());
    }

    public static float getFloat(Object o, float defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).floatValue();
        }
        try {
            return Float.parseFloat(o.toString());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static double getDouble(Object o) {
        if (o == null) {
            return 0.0;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        return Double.parseDouble(o.toString());
    }

    public static double getDouble(Object o, double defaultValue) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Number) {
            return ((Number)o).doubleValue();
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (Exception exception) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(Object o) {
        if (o == null) {
            return false;
        }
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        String s = o.toString().toLowerCase().trim();
        if (s.equals("1")) {
            return true;
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("on")) {
            return true;
        }
        if (s.equals("yes")) {
            return true;
        }
        return s.equals("y");
    }

    public static RsDate getRsDate(Object o, DateFormat[] formats) {
        return LangUtils.getRsDate(o, formats, null);
    }

    public static RsDate getRsDate(Object o, DateFormat[] formats, RsDate defaultValue) {
        DateFormat format;
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof RsDate) {
            return (RsDate)o;
        }
        RsDate rc = null;
        DateFormat[] arr$ = formats;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (rc = LangUtils.getRsDate(o, format = arr$[i$], null, false)) == null; ++i$) {
        }
        if (rc == null) {
            rc = defaultValue;
        }
        return rc;
    }

    public static RsDate getRsDate(Object o) {
        return LangUtils.getRsDate(o, DateFormat.getDateTimeInstance(), null, true);
    }

    public static RsDate getRsDate(Object o, DateFormat format) {
        return LangUtils.getRsDate(o, format, null, true);
    }

    public static RsDate getRsDate(Object o, DateFormat format, RsDate defaultValue) {
        return LangUtils.getRsDate(o, format, defaultValue, true);
    }

    public static RsDate getRsDate(Object o, DateFormat format, RsDate defaultValue, boolean logError) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof RsDate) {
            return (RsDate)o;
        }
        try {
            String s = o.toString().trim();
            if (s.length() == 0) {
                return defaultValue;
            }
            return new RsDate(format.parse(s));
        }
        catch (ParseException e) {
            if (logError) {
                log.error("Cannot parse date: " + o.toString(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static Date getDate(Object o, DateFormat[] formats) {
        return LangUtils.getDate(o, formats, null);
    }

    public static Date getDate(Object o, DateFormat[] formats, Date defaultValue) {
        DateFormat format;
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        Date rc = null;
        DateFormat[] arr$ = formats;
        int len$ = arr$.length;
        for (int i$ = 0; i$ < len$ && (rc = LangUtils.getDate(o, format = arr$[i$], null, false)) == null; ++i$) {
        }
        if (rc == null) {
            rc = defaultValue;
        }
        return rc;
    }

    public static Date getDate(Object o) {
        return LangUtils.getDate(o, DateFormat.getDateTimeInstance(), null, true);
    }

    public static Date getDate(Object o, DateFormat format) {
        return LangUtils.getDate(o, format, null, true);
    }

    public static Date getDate(Object o, DateFormat format, Date defaultValue) {
        return LangUtils.getDate(o, format, defaultValue, true);
    }

    public static Date getDate(Object o, DateFormat format, Date defaultValue, boolean logError) {
        if (o == null) {
            return defaultValue;
        }
        if (o instanceof Date) {
            return (Date)o;
        }
        try {
            String s = o.toString().trim();
            if (s.length() == 0) {
                return defaultValue;
            }
            return format.parse(s);
        }
        catch (ParseException e) {
            if (logError) {
                log.error("Cannot parse date: " + o.toString(), (Throwable)e);
            }
            return defaultValue;
        }
    }

    public static boolean isJava6() {
        if (javaVersion == null && (javaVersion = System.getProperty("java.specification.version")) == null) {
            log.error("Cannot determine Java version.");
            javaVersion = "unknown";
        }
        return javaVersion.equals("1.6");
    }

    public static Locale getLocale(String id) {
        return LangUtils.getLocale(id, Locale.getDefault());
    }

    public static Locale getLocale(String id, Locale defaultLocale) {
        Locale rc = defaultLocale;
        for (Locale l : Locale.getAvailableLocales()) {
            if (!l.toString().equals(id)) continue;
            rc = l;
            break;
        }
        return rc;
    }

    public static String serializeBase64(Object value) throws IOException {
        return new String(Base64.encodeBase64((byte[])LangUtils.serialize(value)), Charsets.UTF_8);
    }

    public static byte[] serialize(Object value) throws IOException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ObjectOutputStream s = new ObjectOutputStream(stream);
        s.writeObject(value);
        s.close();
        return stream.toByteArray();
    }

    public static Object unserialize(String value) throws ClassNotFoundException, IOException {
        return LangUtils.unserialize(Base64.decodeBase64((String)value));
    }

    public static Object unserialize(byte[] bytes) throws ClassNotFoundException, IOException {
        ByteArrayInputStream in = new ByteArrayInputStream(bytes);
        ObjectInputStream s = new ObjectInputStream(in);
        return s.readObject();
    }

    public static String toString(String className, Object ... properties) {
        StringBuilder rc = new StringBuilder();
        rc.append(className);
        rc.append("[");
        for (int i = 0; i < properties.length; i += 2) {
            if (i != 0) {
                rc.append(';');
            }
            rc.append(properties[i]);
            rc.append("=");
            rc.append(properties[i + 1]);
        }
        rc.append("]");
        return rc.toString();
    }

    public static boolean isTransient(PropertyDescriptor desc) {
        Method rm = desc.getReadMethod();
        Method wm = desc.getWriteMethod();
        if (rm == null || wm == null) {
            return true;
        }
        return rm.isAnnotationPresent(Transient.class);
    }

    public static boolean isNoCopy(PropertyDescriptor desc) {
        Method rm = desc.getReadMethod();
        Method wm = desc.getWriteMethod();
        if (rm == null || wm == null) {
            return true;
        }
        return rm.isAnnotationPresent(NoCopy.class);
    }

    public static void sleep(long milliseconds) {
        try {
            Thread.sleep(milliseconds);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

