/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.lang;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.regex.Pattern;
import rs.baselib.lang.JarDescriptor;

public class ResourceList {
    private static String classPath = System.getProperty("java.class.path", ".");
    private static String[] classPathElements = classPath.split(File.pathSeparator);

    public static Collection<Manifest> getManifests() {
        ArrayList<Manifest> rc = new ArrayList<Manifest>();
        for (String element : classPathElements) {
            rc.addAll(ResourceList.getManifests(element));
        }
        return rc;
    }

    private static Collection<Manifest> getManifests(String fileName) {
        ArrayList<Manifest> rc = new ArrayList<Manifest>();
        try {
            File file = new File(fileName);
            if (!file.isDirectory()) {
                rc.add(ResourceList.getManifest(file));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rc;
    }

    private static Manifest getManifest(File file) throws IOException {
        JarFile jarFile = new JarFile(file);
        return jarFile.getManifest();
    }

    public static Collection<JarDescriptor> getJars() {
        ArrayList<JarDescriptor> rc = new ArrayList<JarDescriptor>();
        for (String element : classPathElements) {
            rc.addAll(ResourceList.getJars(element));
        }
        return rc;
    }

    private static Collection<JarDescriptor> getJars(String fileName) {
        ArrayList<JarDescriptor> rc = new ArrayList<JarDescriptor>();
        try {
            File file = new File(fileName);
            if (!file.isDirectory()) {
                rc.add(new JarDescriptor(file));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rc;
    }

    public static Collection<File> getDirectories() {
        ArrayList<File> rc = new ArrayList<File>();
        for (String element : classPathElements) {
            rc.addAll(ResourceList.getDirectories(element));
        }
        return rc;
    }

    private static Collection<File> getDirectories(String fileName) {
        ArrayList<File> rc = new ArrayList<File>();
        File file = new File(fileName);
        if (file.isDirectory()) {
            rc.add(file);
        }
        return rc;
    }

    public static Collection<URL> getResources(Pattern pattern) {
        ArrayList<URL> rc = new ArrayList<URL>();
        for (String element : classPathElements) {
            rc.addAll(ResourceList.getResources(element, pattern));
        }
        return rc;
    }

    private static Collection<URL> getResources(String element, Pattern pattern) {
        ArrayList<URL> rc = new ArrayList<URL>();
        try {
            File file = new File(element);
            if (file.isDirectory()) {
                rc.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
            } else {
                rc.addAll(ResourceList.getResourcesFromJarFile(file, pattern));
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return rc;
    }

    private static Collection<URL> getResourcesFromJarFile(File file, Pattern pattern) throws IOException {
        ArrayList<URL> rc = new ArrayList<URL>();
        JarFile jarFile = new JarFile(file);
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String fileName = entry.getName();
            boolean accept = pattern.matcher(fileName).matches();
            if (!accept) continue;
            rc.add(new URL("jar:file:" + file.getCanonicalPath() + "!/" + fileName));
        }
        jarFile.close();
        return rc;
    }

    private static Collection<URL> getResourcesFromDirectory(File directory, Pattern pattern) {
        File[] fileList;
        ArrayList<URL> retval = new ArrayList<URL>();
        for (File file : fileList = directory.listFiles()) {
            if (file.isDirectory()) {
                retval.addAll(ResourceList.getResourcesFromDirectory(file, pattern));
                continue;
            }
            try {
                String fileName = file.getCanonicalPath();
                boolean accept = pattern.matcher(fileName).matches();
                if (!accept) continue;
                retval.add(new File(fileName).toURI().toURL());
            }
            catch (IOException e) {
                throw new Error(e);
            }
        }
        return retval;
    }
}

