/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import java.util.Date;
import rs.baselib.lang.LangUtils;
import rs.baselib.licensing.AbstractLicense;
import rs.baselib.licensing.ILicenseContext;
import rs.baselib.licensing.LicenseException;
import rs.baselib.util.CommonUtils;
import rs.baselib.util.RsDate;

public class DefaultLicense
extends AbstractLicense {
    private static final long serialVersionUID = 1L;

    @Override
    public void init(ILicenseContext context) {
        this.initProperty("product", context);
        this.initProperty("expirationDate", context);
        this.initProperty("owner", context);
        this.initProperty("minVersion", context);
        this.initProperty("minVersionIncluded", context);
        this.initProperty("maxVersion", context);
        this.initProperty("maxVersionIncluded", context);
    }

    public String getProduct() {
        return LangUtils.getString(this.getProperty("product"));
    }

    public void setProduct(String s) {
        this.setProperty("product", s);
    }

    public Date getExpirationDate() {
        long l = this.getExpiration();
        if (l == 0L) {
            return null;
        }
        return new Date(l);
    }

    private long getExpiration() {
        return this.getDate(this.getProperty("expirationDate"));
    }

    public void setExpirationDate(Date d) {
        if (d != null) {
            this.setProperty("expirationDate", d.getTime());
        } else {
            this.removeProperty("expirationDate");
        }
    }

    public String getOwner() {
        return LangUtils.getString(this.getProperty("owner"));
    }

    public void setOwner(String s) {
        this.setProperty("owner", s);
    }

    public boolean isMinVersionIncluded() {
        return LangUtils.getBoolean(this.getProperty("minVersionIncluded"));
    }

    public void setMinVersionIncluded(boolean b) {
        this.setProperty("minVersionIncluded", b);
    }

    public String getMinVersion() {
        return LangUtils.getString(this.getProperty("minVersion"));
    }

    public void setMinVersion(String s) {
        this.setProperty("minVersion", s);
    }

    public boolean isMaxVersionIncluded() {
        return LangUtils.getBoolean(this.getProperty("maxVersionIncluded"));
    }

    public void setMaxVersionIncluded(boolean b) {
        this.setProperty("maxVersionIncluded", b);
    }

    public String getMaxVersion() {
        return LangUtils.getString(this.getProperty("maxVersion"));
    }

    public void setMaxVersion(String s) {
        this.setProperty("maxVersion", s);
    }

    protected long getDate(Object o) {
        if (o instanceof Date) {
            return ((Date)o).getTime();
        }
        if (o instanceof RsDate) {
            return ((RsDate)o).getTimeInMillis();
        }
        return LangUtils.getLong(o, 0L);
    }

    @Override
    public void verify(ILicenseContext context) {
        String version;
        Date d;
        this.verifyEquals("product", context, true);
        this.verifyEquals("owner", context, true);
        if (!context.hasKey("expirationDate")) {
            context.set("expirationDate", (Object)System.currentTimeMillis());
        }
        if ((d = this.getExpirationDate()) != null) {
            long l = this.getDate(context.get("expirationDate"));
            if (d.getTime() < l) {
                throw new LicenseException("License expired on " + d.toString());
            }
        }
        if ((version = (String)context.get("version")) != null) {
            int cmp;
            if (this.hasProperty("minVersion")) {
                cmp = CommonUtils.compareVersion(this.getMinVersion(), version);
                if (this.isMinVersionIncluded() && cmp > 0) {
                    throw new LicenseException("License is not valid for this version (" + version + "). " + this.toString());
                }
                if (!this.isMinVersionIncluded() && cmp >= 0) {
                    throw new LicenseException("License is not valid for this version (" + version + "). " + this.toString());
                }
            }
            if (this.hasProperty("maxVersion")) {
                cmp = CommonUtils.compareVersion(this.getMaxVersion(), version);
                if (this.isMaxVersionIncluded() && cmp < 0) {
                    throw new LicenseException("License is not valid for this version (" + version + "). " + this.toString());
                }
                if (!this.isMaxVersionIncluded() && cmp <= 0) {
                    throw new LicenseException("License is not valid for this version (" + version + "). " + this.toString());
                }
            }
        }
    }

    public String toString() {
        Date d;
        StringBuilder buf = new StringBuilder();
        buf.append("Valid for \"" + this.getProduct() + "\"");
        String minVersion = this.getMinVersion();
        String maxVersion = this.getMaxVersion();
        if (minVersion != null || maxVersion != null) {
            if (minVersion != null) {
                if (this.isMinVersionIncluded()) {
                    buf.append('[');
                } else {
                    buf.append('(');
                }
                buf.append(minVersion);
            } else {
                buf.append('(');
            }
            buf.append(',');
            if (maxVersion != null) {
                buf.append(maxVersion);
                if (this.isMaxVersionIncluded()) {
                    buf.append(']');
                } else {
                    buf.append(')');
                }
            } else {
                buf.append(')');
            }
        }
        if ((d = this.getExpirationDate()) != null) {
            buf.append(" until ");
            buf.append(CommonUtils.DATE_TIME_FORMATTER().format(d));
        } else {
            buf.append(" (unlimited)");
        }
        buf.append(". Licensed to \"" + this.getOwner() + "\".");
        return buf.toString();
    }
}

