/*
 * Decompiled with CFR 0.152.
 */
package rs.baselib.licensing;

import java.io.File;
import java.security.Key;
import java.security.PrivateKey;
import java.util.Date;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import rs.baselib.crypto.EncryptionUtils;
import rs.baselib.licensing.DefaultLicenseContext;
import rs.baselib.licensing.LicenseGenerator;
import rs.baselib.util.CommonUtils;

public class LicGen
implements Runnable {
    private static LicGen licgen;
    private String product;
    private long expirationTime;
    private String owner;
    private String licenseKey;

    public LicGen(String product, long expirationTime, String owner) {
        this.product = product;
        this.expirationTime = expirationTime;
        this.owner = owner;
    }

    public String getLicenseKey() {
        return this.licenseKey;
    }

    @Override
    public void run() {
        try {
            System.out.print("Generating \"" + this.product + "\" license (");
            if (this.expirationTime > 0L) {
                System.out.print("expires " + CommonUtils.DATE_FORMATTER().format(new Date(this.expirationTime)));
            } else {
                System.out.print("unlimited");
            }
            System.out.println("):");
            File f = new File(this.product + ".private");
            PrivateKey privateKey = EncryptionUtils.loadPrivateKey(f, "RSA");
            LicenseGenerator licgen = new LicenseGenerator();
            DefaultLicenseContext context = new DefaultLicenseContext();
            context.set("product", this.product);
            context.set("expirationDate", (Object)this.expirationTime);
            context.set("owner", this.owner);
            context.set(Key.class, privateKey);
            this.licenseKey = licgen.createLicenseKey(context);
            System.out.println(this.licenseKey);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void main(String[] args) {
        Options options = LicGen.getOptions();
        String product = null;
        long expirationTime = 0L;
        String owner = null;
        try {
            GnuParser parser = new GnuParser();
            CommandLine cmd = parser.parse(options, args);
            product = cmd.getOptionValue("p");
            owner = cmd.getOptionValue("o");
            expirationTime = LicGen.parseTime(cmd.getOptionValue("e"));
            if (CommonUtils.isEmpty(product, true) || CommonUtils.isEmpty(owner, true)) {
                LicGen.printHelp(options);
                System.exit(-1);
            }
        }
        catch (ParseException e) {
            LicGen.printHelp(options);
            System.exit(-1);
        }
        try {
            licgen = new LicGen(product, expirationTime, owner);
            licgen.run();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected static void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("KeyGen", options);
    }

    public static Options getOptions() {
        Options rc = new Options();
        Option option = new Option("e", "expiry", true, "time of expiry (dd.MM.yyyy or days)");
        option.setOptionalArg(false);
        rc.addOption(option);
        option = new Option("p", "product", true, "name of product (\"rsbudget\", ...");
        option.setOptionalArg(false);
        rc.addOption(option);
        option = new Option("o", "owner", true, "license owner");
        option.setOptionalArg(false);
        rc.addOption(option);
        return rc;
    }

    protected static long parseTime(String s) {
        if (s == null) {
            return 0L;
        }
        try {
            return CommonUtils.DATE_FORMATTER().parse(s).getTime();
        }
        catch (java.text.ParseException e) {
            int days = Integer.parseInt(s);
            return System.currentTimeMillis() + (long)days * 86400000L;
        }
    }

    public static LicGen getLicgen() {
        return licgen;
    }

    public String getProduct() {
        return this.product;
    }

    public long getExpirationTime() {
        return this.expirationTime;
    }

    public String getOwner() {
        return this.owner;
    }
}

